<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: blog_related_categoryDb.php 3826 2010-11-15 10:13:21Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class blog_related_categoryDb extends BaseDb
{
	/**
	 * ブログ記事に関連したカテゴリー一覧を取得
	 *
	 * @param string	$entryId			記事ID
	 * @param string	$langId				言語
	 * @param function	$callback			コールバック関数
	 * @return 			なし
	 */
	function getCategoryByEntryId($entryId, $langId, $callback)
	{
		// ブログ記事を取得
		$queryStr  = 'SELECT * FROM blog_entry ';
		$queryStr .=   'WHERE be_deleted = false ';	// 削除されていない
		$queryStr .=   'AND be_id = ? ';
		$queryStr .=   'AND be_language_id = ? ';
		$ret = $this->selectRecord($queryStr, array($entryId, $langId), $row);
		if (!$ret) return;
		
		$queryStr  = 'SELECT * FROM blog_entry_with_category LEFT JOIN blog_category ON bw_category_id = bc_id AND bc_deleted = false AND bc_language_id = ? ';
		$queryStr .=   'WHERE bw_entry_serial = ? ';
		$queryStr .=     'AND bc_visible = true ';		// 表示状態
		$queryStr .=   'ORDER BY bc_sort_order ';
		$this->selectLoop($queryStr, array($langId, $row['be_serial']), $callback, null);
	}
}
?>
