<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainEditsourceWidgetContainer.php 2355 2009-09-25 05:34:08Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainEditsourceWidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト
	const SAMPLE_DIR = 'sample';				// サンプルSQLディレクトリ名
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'selectfile'){		// ファイルを選択、Ajaxでデータ送信
			return '';
		} else {
			return 'editsource.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
				
		$act = $request->trimValueOf('act');
		$filepath = $request->trimValueOf('selfile');
		$fileType = 'generic';
		if ($act == 'selectfile'){		// ファイルを選択
			if (file_exists($filepath)){
				// ファイルの情報取得
				$pathParts = pathinfo($filepath);
				$ext = strtolower($pathParts['extension']);
				
				// 拡張子をチェック
				switch ($ext){
					case 'html':
						$fileType = 'html';
						break;
					case 'js':
						$fileType = 'javascript';
						break;
					case 'php':
						$fileType = 'php';
						break;
					case 'sql':
						$fileType = 'sql';
						break;
					case 'css':
						$fileType = 'css';
						break;
					case 'perl':
						$fileType = 'perl';
						break;
					case 'txt':
					case 'csv':
						$fileType = 'text';
						break;
					case 'java':
						$fileType = 'java';
						break;
				}
				if ($fileType != 'generic'){
					// ファイルを読み込み
					$fileContents = file_get_contents($filepath);
				} else {
					$fileContents = 'ファイルが読み込めません';
				}
			} else {
				$fileContents = 'ファイルが存在しません';
			}
			$this->gInstance->getAjaxManager()->addData('filecontents', $fileContents);
			$this->gInstance->getAjaxManager()->addData('filetype', $fileType);
		} else {
			// ファイルツリーのトップディレクトリ
			$topDir = $gEnvManager->getWidgetsPath();		// ウィジェットディレクトリ
		
			// ファイルツリー作成
			$listHtml = '';
			$ret = $this->createFileTreeLoop($topDir, $listHtml);
			if ($ret) $this->tmpl->addVar("_widget", "file_tree", $listHtml);
		
			// パスの設定
			$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
			
			// デフォルトのファイル形式設定
			$this->tmpl->addVar("_widget", "ext", $fileType);
		}
	}
	/**
	 * ファイルツリーリスト作成
	 *
	 * @param string    $path				ルートディレクトリパス
	 * @param array     $destArray			ツリー化したカテゴリー
	 * @return bool							true=作成成功、false=作成失敗
	 */
	function createFileTreeLoop($path, &$listHtml)
	{
		if (is_dir($path)){
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . DIRECTORY_SEPARATOR . $file;
				// ディレクトリかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_dir($filePath)){
					$id = $filePath;
					$selectStr = '';
		//			if ($id == $this->categoryId) $selectStr = 'select="1"';		// カテゴリーが選択されているときは選択状態にする
					$listHtml .= '<item text="' . $file . '" id="' . $id . '" ' . $selectStr . '>' . M3_NL;
					$this->createFileTreeLoop($id, $listHtml);
					$listHtml .= '</item>' . M3_NL;
				} else if (is_file($filePath)){		// ファイルのとき
					$id = $filePath;
					$selectStr = '';
		//			if ($id == $this->categoryId) $selectStr = 'select="1"';		// カテゴリーが選択されているときは選択状態にする
					$listHtml .= '<item text="' . $file . '" id="' . $id . '" ' . $selectStr . '>' . M3_NL;
					$listHtml .= '</item>' . M3_NL;
				}
			}
			$dir->close();
			return true;
		} else {		// ファイルのとき
			return false;
		}
		//$listHtml .= '<item text="' . $rows[$i]['pc_name'] . '" id="' . $id . '" open="1" ' . $selectStr . '>' . M3_NL;
	}
}
?>
