<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_blog_mainConfigWidgetContainer.php 3614 2010-09-22 05:09:39Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_blog_mainBaseWidgetContainer.php');

class admin_blog_mainConfigWidgetContainer extends admin_blog_mainBaseWidgetContainer
{
	const DEFAULT_VIEW_COUNT	= 10;				// デフォルトの表示記事数
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_config.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$defaultLang	= $this->gEnv->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$entryViewCount = $request->trimValueOf('entry_view_count');		// 記事表示数
		$entryViewOrder = $request->trimValueOf('entry_view_order');		// 記事表示順
		$categoryCount = $request->trimValueOf('category_count');		// カテゴリ数
		$receiveComment = ($request->trimValueOf('receive_comment') == 'on') ? 1 : 0;		// コメントを受け付けるかどうか
		$useMultiBlog = ($request->trimValueOf('use_multi_blog') == 'on') ? 1 : 0;		// マルチブログ機能を使用するかどうか
		$topContent = $request->valueOf('top_content');	// トップコンテンツ
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkNumeric($entryViewCount, '記事表示順');
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;
				
				if (!$isErr){
					if (!$this->_db->updateConfig(self::CF_ENTRY_VIEW_COUNT, $entryViewCount)) $isErr = true;// 記事表示数
				}
				if (!$isErr){
					if (!$this->_db->updateConfig(self::CF_ENTRY_VIEW_ORDER, $entryViewOrder)) $isErr = true;// 記事表示順
				}
				if (!$isErr){
					if (!$this->_db->updateConfig(self::CF_CATEGORY_COUNT, $categoryCount)) $isErr = true;// カテゴリ数
				}
				if (!$isErr){
					if (!$this->_db->updateConfig(self::CF_RECEIVE_COMMENT, $receiveComment)) $isErr = true;// コメントを受け付けるかどうか
				}
				if (!$isErr){
					if (!$this->_db->updateConfig(self::CF_USE_MULTI_BLOG, $useMultiBlog)) $isErr = true;// マルチブログ機能を使用するかどうか
				}
				if (!$isErr){
					if (!$this->_db->updateConfig(self::CF_MULTI_BLOG_TOP_CONTENT, $topContent)) $isErr = true;// マルチブログ時のトップコンテンツ
				}
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
				// 値を再取得
				$entryViewCount	= $this->_db->getConfig(self::CF_ENTRY_VIEW_COUNT);// 記事表示数
				$entryViewOrder	= $this->_db->getConfig(self::CF_ENTRY_VIEW_ORDER);// 記事表示順
				$categoryCount	= $this->_db->getConfig(self::CF_CATEGORY_COUNT);// カテゴリ数
				$receiveComment	= $this->_db->getConfig(self::CF_RECEIVE_COMMENT);
				$useMultiBlog = $this->_db->getConfig(self::CF_USE_MULTI_BLOG);// マルチブログ機能を使用するかどうか
				$topContent = $this->_db->getConfig(self::CF_MULTI_BLOG_TOP_CONTENT);// マルチブログ時のトップコンテンツ
			}
		} else {		// 初期表示の場合
			$entryViewCount	= $this->_db->getConfig(self::CF_ENTRY_VIEW_COUNT);// 記事表示数
			if (empty($entryViewCount)) $entryViewCount = self::DEFAULT_VIEW_COUNT;
			$entryViewOrder	= $this->_db->getConfig(self::CF_ENTRY_VIEW_ORDER);// 記事表示順
			$categoryCount	= $this->_db->getConfig(self::CF_CATEGORY_COUNT);// カテゴリ数
			if (empty($categoryCount)) $categoryCount = self::DEFAULT_CATEGORY_COUNT;
			$receiveComment	= $this->_db->getConfig(self::CF_RECEIVE_COMMENT);
			$useMultiBlog = $this->_db->getConfig(self::CF_USE_MULTI_BLOG);// マルチブログ機能を使用するかどうか
			if (is_null($useMultiBlog)) $useMultiBlog = '0';
			$topContent = $this->_db->getConfig(self::CF_MULTI_BLOG_TOP_CONTENT);// マルチブログ時のトップコンテンツ
		}
		// 画面に書き戻す
		$this->tmpl->addVar("_widget", "view_count", $entryViewCount);// 記事表示数
		if (empty($entryViewOrder)){	// 順方向
			$this->tmpl->addVar("_widget", "view_order_inc_selected", 'selected');// 記事表示順
		} else {
			$this->tmpl->addVar("_widget", "view_order_dec_selected", 'selected');// 記事表示順
		}
		$this->tmpl->addVar("_widget", "category_count", $categoryCount);// カテゴリ数
		$checked = '';
		if ($receiveComment) $checked = 'checked';
		$this->tmpl->addVar("_widget", "receive_comment", $checked);// コメントを受け付けるかどうか
		$checked = '';
		if ($useMultiBlog) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_multi_blog", $checked);// マルチブログ機能を使用するかどうか
		$this->tmpl->addVar("_widget", "top_content", $topContent);		// マルチブログ時のトップコンテンツ
	}
}
?>
