<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: static_contentWidgetContainer.php 3531 2010-08-26 05:34:41Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/static_contentDb.php');

class static_contentWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $langId;		// 現在の言語
	const DEFAULT_CONFIG_ID = 0;
	const CONTENT_TYPE = '';			// コンテンツタイプ
	const VIEW_CONTENT_TYPE = 'ct';		// 参照数カウント用
	const DEFAULT_TITLE = 'コンテンツ';			// デフォルトのウィジェットタイトル
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new static_contentDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'main.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$now = date("Y/m/d H:i:s");	// 現在日時
		$this->langId = $this->gEnv->getCurrentLanguage();
		
		// 定義ID取得
		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// パラメータオブジェクトを取得
		$showWidget = false;		// ウィジェットを表示するかどうか
		$targetObj = $this->getWidgetParamObjByConfigId($configId);
		if (!empty($targetObj)){		// 定義データが取得できたとき
			$name = $targetObj->name;// 定義名
			$contentId	= $targetObj->contentId;		// コンテンツID
			$hideInLogin = $targetObj->hideInLogin;		// ログイン中は非表示にする
			
			// コンテンツを取得
			$ret = $this->db->getContentByContentId(self::CONTENT_TYPE, $contentId, $this->langId, $now, $row);
			if ($ret){
				// Magic3マクロ変換
				$html = $this->convertM3ToHtml($row['cn_html']);

				// コンテンツを設定
				$this->tmpl->addVar("_widget", "content", $html);
			
				// ログインユーザに表示が制限されている場合は非表示
				if ($this->gEnv->isCurrentUserLogined() || !$row['cn_user_limited']) $showWidget = true;
				
				// ログイン中は非表示に設定されているときは非表示にする
				if (!empty($hideInLogin) && $this->gEnv->isCurrentUserLogined()) $showWidget = false;
			}
		}
		// ウィジェットの表示
		if ($showWidget){
			// ビューカウントを更新
			if (!$this->gEnv->isSystemManageUser()){		// システム運用者以上の場合はカウントしない
				$currentDay = date("Y/m/d");		// 日
				$currentHour = (int)date("H");		// 時間
				$this->gInstance->getAnalyzeManager()->updateContentViewCount(self::VIEW_CONTENT_TYPE, $row['cn_serial'], $currentDay, $currentHour);
			}
		} else {
			// 出力抑止
			$this->cancelParse();
		}
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return self::DEFAULT_TITLE;
	}
}
?>
