<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: blog_mainWidgetContainer.php 3615 2010-09-22 09:25:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/blog_mainBaseWidgetContainer.php');

class blog_mainWidgetContainer extends blog_mainBaseWidgetContainer
{
	const DEFAULT_TASK = 'top';				// デフォルトの画面
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// ウィジェットオブジェクト取得
		self::$_paramObj = $this->getWidgetParamObj();
		
		// 定義ID取得
/*		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = 0;
		
		// パラメータオブジェクトを取得
		self::$_paramObj = $this->getWidgetParamObjByConfigId($configId);*/
	}
	/**
	 * ディスパッチ処理(メインコンテナのみ実行)
	 *
     * HTTPリクエストの内容を見て処理をコンテナに振り分ける
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return bool 						このクラスの_setTemplate(), _assign()へ処理を継続するかどうかを返す。
	 *                                      true=処理を継続、false=処理を終了
	 */
	function _dispatch($request, &$param)
	{
		// 実行処理を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = self::DEFAULT_TASK;
		$blogId = $request->trimValueOf(M3_REQUEST_PARAM_BLOG_ID);
		if (empty($blogId)) $blogId = $request->trimValueOf(M3_REQUEST_PARAM_BLOG_ID_SHORT);		// 略式ブログID

		// ##### アクセス制御 #####
		self::$_canEditContent = false;		// コンテンツ編集権限
		
		// 設定値を取得
		if ($this->gEnv->isSystemManageUser()){			// システム運用可能ユーザのとき
			self::$_canEditContent = true;		// コンテンツ編集権限
		} else if ($this->gEnv->getCurrentUserType() >= UserInfo::USER_TYPE_AUTHOR){		// ユーザ権限(投稿者以上)のチェック
			// ブログの所有者のときは編集権限あり
			$ret = self::$_localDb->getBlogInfoById($blogId, $row);
			if ($ret && $this->gEnv->getCurrentUserId() == $row['bl_owner_id']) self::$_canEditContent = true;		// コンテンツ編集権限
		}

		// ##### コンテナを起動 #####
		$goWidget = false;		// サブウィジェットを実行するかどうか
		switch ($task){
			case self::TASK_TOP:			// トップ画面
				$goWidget = true;		// サブウィジェットを実行するかどうか
				break;				
			case self::TASK_CONTENT:				// コンテンツ編集画面(別ウィンドウ)
			case self::TASK_CONTENT_DETAIL:			// コンテンツ編集画面詳細
				if (empty(self::$_canEditContent)){	// コンテンツが編集可能かどうか
					$this->SetMsg(self::MSG_APP_ERR, "アクセスできません");
					return true;				
				} else {
					$task = self::TASK_CONTENT;
					$goWidget = true;		// サブウィジェットを実行するかどうか
				}
				break;
		}
		if ($goWidget){		// サブウィジェットを実行するかどうか
			$this->gLaunch->goSubWidget($task);		// 一般機能で呼び出し
			return false;
		} else {
			$this->SetMsg(self::MSG_APP_ERR, "画面が見つかりません");
			return true;
		}
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		return 'message.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);

		// 要求画面によってテンプレートを変更
		switch ($task){
			case self::TASK_TOP:			// トップ画面
			default:
				// メッセージを表示
				//$this->tmpl->addVar("_widget", "login_url", $this->gEnv->createCurrentPageUrl() . '&task=login');		// ログイン用URL
				break;
		}
	}
}
?>
