<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: blog_mainBaseWidgetContainer.php 3615 2010-09-22 09:25:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_mainDb.php');

class blog_mainBaseWidgetContainer extends BaseWidgetContainer
{
	protected static $_localDb;			// DB接続オブジェクト
	protected static $_configArray;		// ブログ定義値
	protected static $_paramObj;		// ウィジェットパラメータオブジェクト
	protected static $_canEditContent;	// コンテンツが編集可能かどうか
	const CF_RECEIVE_COMMENT		= 'receive_comment';		// コメントを受け付けるかどうか
	const CF_RECEIVE_TRACKBACK		= 'receive_trackback';		// トラックバックを受け付けるかどうか
	const CF_ENTRY_VIEW_COUNT		= 'entry_view_count';			// 記事表示数
	const CF_ENTRY_VIEW_ORDER		= 'entry_view_order';			// 記事表示方向
	const CF_USE_MULTI_BLOG		= 'use_multi_blog';		// マルチブログ機能を使用するかどうか
	const CF_MULTI_BLOG_TOP_CONTENT	= 'multi_blog_top_content';		// マルチブログ時のトップコンテンツ
	
	// 画面
	const TASK_TOP = 'top';			// トップ画面
	const TASK_CONTENT = 'content';			// コンテンツ編集画面
	const TASK_CONTENT_DETAIL = 'content_detail';			// コンテンツ編集画面詳細
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();

		// DBオブジェクト作成
		//$this->_db = new blog_mainDb();
		if (!isset(self::$_localDb)) self::$_localDb = new blog_mainDb();
			
		// ブログ定義を読み込む
		if (!isset(self::$_configArray)) $this->_loadConfig();
	}
	/**
	 * ブログ定義値をDBから取得
	 *
	 * @return bool			true=取得成功、false=取得失敗
	 */
	function _loadConfig()
	{
		self::$_configArray = array();

		// ブログ定義を読み込み
		//$ret = $this->_db->getAllConfig($rows);
		$ret = self::$_localDb->getAllConfig($rows);
		if ($ret){
			// 取得データを連想配列にする
			$configCount = count($rows);
			for ($i = 0; $i < $configCount; $i++){
				$key = $rows[$i]['bg_id'];
				$value = $rows[$i]['bg_value'];
				self::$_configArray[$key] = $value;
			}
		}
		return $ret;
	}
}
?>
