<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: bbs_accessDb.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class bbs_accessDb extends BaseDb
{
	/**
	 * ユーザグループ情報を取得
	 *
	 * @param string	$lang				言語
	 * @param array	$rows					取得情報
	 * @return bool							true=取得、false=取得せず
	 */
	function getAllGroupInfo($lang, &$rows)
	{
		$queryStr = 'SELECT * FROM bbs_group ';
		$queryStr .=  'WHERE sg_language_id = ? ';
		$queryStr .=    'AND sg_deleted = false ';		// 削除されていない
		$queryStr .=  'ORDER BY sg_sort_order';
		$retValue = $this->selectRecords($queryStr, array($lang), $rows);
		return $retValue;
	}
	/**
	 * BBSカテゴリー一覧を取得
	 *
	 * @param function	$callback			コールバック関数
	 * @param string	$lang				言語
	 * @return 			なし
	 */
	function getAllCategory($callback, $lang)
	{
		$queryStr = 'SELECT * FROM bbs_category ';
		$queryStr .=  'WHERE sr_language_id = ? ';
		$queryStr .=    'AND sr_deleted = false ';		// 削除されていない
		$queryStr .=  'ORDER BY sr_sort_order';
		$this->selectLoop($queryStr, array($lang), $callback, null);
	}
	/**
	 * BBSカテゴリー情報を取得
	 *
	 * @param string	$lang				言語
	 * @param array	$rows					取得情報
	 * @return bool							true=取得、false=取得せず
	 */
	function getAllCategoryInfo($lang, &$rows)
	{
		$queryStr = 'SELECT * FROM bbs_category ';
		$queryStr .=  'WHERE sr_language_id = ? ';
		$queryStr .=    'AND sr_deleted = false ';		// 削除されていない
		$queryStr .=  'ORDER BY sr_sort_order';
		$retValue = $this->selectRecords($queryStr, array($lang), $rows);
		return $retValue;
	}
	/**
	 * アクセス権限を取得
	 *
	 * @param int	$groupId				グループID
	 * @param int	$categoryId				カテゴリーID
	 * @param array	$accessRow				取得情報
	 * @return bool							true=取得、false=取得せず
	 */
	function getAccessRecord($groupId, $categoryId, &$accessRow)
	{
		$queryStr = 'SELECT * FROM bbs_group_access ';
		$queryStr .=  'WHERE so_group_id = ? ';
		$queryStr .=    'AND so_category_id = ? ';
		$retValue = $this->selectRecord($queryStr, array($groupId, $categoryId), $accessRow);
		return $retValue;
	}
	/**
	 * アクセス権限を更新
	 *
	 * @param int	$groupId				グループID
	 * @param int	$categoryId				カテゴリーID
	 * @param int	$canRead				読み込み権限
	 * @param int	$canWrite				書き込み権限
	 * @param int	$userId					更新者ユーザID
	 * @return bool							true = 成功、false = 失敗
	 */
	function updateAccessRecord($groupId, $categoryId, $canRead, $canWrite, $userId)
	{
		// トランザクション開始
		$this->startTransaction();
		
		$queryStr = 'SELECT * FROM bbs_group_access ';
		$queryStr .=  'WHERE so_group_id = ? ';
		$queryStr .=    'AND so_category_id = ? ';
		$ret = $this->isRecordExists($queryStr, array($groupId, $categoryId));
		if ($ret){
			$queryStr  = 'UPDATE bbs_group_access ';
			$queryStr .=   'SET so_read = ?, ';
			$queryStr .=     'so_write = ?, ';
			$queryStr .=     'so_update_user_id = ?, ';
			$queryStr .=     'so_update_dt = now() ';
			$queryStr .=  'WHERE so_group_id = ? ';
			$queryStr .=    'AND so_category_id = ? ';
			$this->execStatement($queryStr, array($canRead, $canWrite, $userId, $groupId, $categoryId));
		} else {
			// 新規レコード追加
			$queryStr = 'INSERT INTO bbs_group_access ';
			$queryStr .=  '(';
			$queryStr .=  'so_group_id, ';
			$queryStr .=  'so_category_id, ';
			$queryStr .=  'so_read, ';
			$queryStr .=  'so_write, ';
			$queryStr .=  'so_update_user_id, ';
			$queryStr .=  'so_update_dt) ';
			$queryStr .=  'VALUES ';
			$queryStr .=  '(?, ?, ?, ?, ?, now())';
			$this->execStatement($queryStr, array($groupId, $categoryId, $canRead, $canWrite, $userId));
		}
		
		// トランザクション確定
		$ret = $this->endTransaction();
		return $ret;
	}
	
	/**
	 * アクセス可能カテゴリーの取得
	 *
	 * @param int	$userId					ユーザID(IDが0のときは、ゲストグループのカテゴリーを取得)
	 * @param string	$lang				言語
	 * @param array	$rows					取得情報
	 * @return bool							true=取得、false=取得せず
	 */
	function getCategoryAccessInfo($userId, $lang, &$rows)
	{
		if ($userId == 0){
			// アクセス情報を取得
			$queryStr = 'SELECT * FROM bbs_group_access LEFT JOIN bbs_category ON so_category_id = sr_id AND sr_deleted = false ';
			$queryStr .=  'WHERE so_group_id = 1 ';		// ゲストグループ
			$queryStr .=  'ORDER BY sr_sort_order, so_write desc, so_read desc';
			$retValue = $this->selectRecords($queryStr, array(), $rows);
			return $retValue;
		} else {
			// 会員情報を取得
			$queryStr  = 'SELECT * FROM bbs_member ';
			$queryStr .=   'WHERE sv_login_user_id = ? AND sv_deleted = false';
			$ret = $this->selectRecord($queryStr, array($userId), $row);
			if (!$ret) return false;

			// アクセス情報を取得
			$queryStr = 'SELECT * FROM bbs_group_access LEFT JOIN bbs_category ON so_category_id = sr_id AND sr_deleted = false ';
			$queryStr .=  'WHERE so_group_id in (' . $row['sv_group'] . ') ';
			$queryStr .=  'ORDER BY sr_sort_order, so_write desc, so_read desc';
			$retValue = $this->selectRecords($queryStr, array(), $rows);
			return $retValue;
		}
	}
}
?>
