<?php
/**
 * Joomla!パラメータクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: JParameter.php 3047 2010-04-21 04:08:16Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($this->gEnv->getJoomlaRootPath() . '/class/object.php');
require_once($this->gEnv->getJoomlaRootPath() . '/class/registry.php');
//class JParameter
class JParameter extends JRegistry
{
	private $params = array();

	/**
	 * コンストラクタ
	 *
	 * @param string $data		初期化データ
	 * @param string $path		初期設定ファイル
	 */
	function __construct($data = '', $path = '')
	{
		$data = trim($data);
		if (!empty($data)){
			$lines = explode("\n", $data);
			$count = count($lines);
			for ($i = 0; $i < $count; $i++){
				list($key, $value) = explode("=", $lines[$i]);
				$this->params[$key] = $value;
			}
		}
	}
	/**
	 * キーを指定して値を設定
	 *
	 * @param string $key		取得キー
	 * @param string			設定値
	 * @return 					なし
	 */
	public function set($key, $value)
	{
		$this->params[$key] = $value;
	}
	/**
	 * キーを指定して値を取得
	 *
	 * @param string $key		取得キー
	 * @return string			取得値
	 */
	public function get($key)
	{
		return isset($this->params[$key]) ? $this->params[$key] : '';
	}
}
class JUser
{
	/**
	 */
	public function authorize()
	{
		return true;
	}
}
/*class JHTML
{
	function _($type)
	{
		return false;
	}
}*/
class JText
{
	private static $_strings = array(	'DATE_FORMAT_LC'	=> '%A, %d %B %Y',
										'DATE_FORMAT_LC1'	=> '%A, %d %B %Y',
										'DATE_FORMAT_LC2'	=> '%A, %d %B %Y %H:%M',
										'DATE_FORMAT_LC3'	=> '%d %B %Y',
										'DATE_FORMAT_LC4'	=> '%d.%m.%y',
										'DATE_FORMAT_JS1'	=> 'y-m-d');
	/**
	 * コンストラクタ
	 */
	function __construct()
	{

	}
	
	function _($string, $jsSafe = false)
	{
		$key = strtoupper($string);
		$key = substr($key, 0, 1) == '_' ? substr($key, 1) : $key;

		if (isset(self::$_strings[$key])) $string = self::$_strings[$key];

		if ($jsSafe) $string = addslashes($string);
		return $string;
	}
	function sprintf($string)
	{
		$lang =& JFactory::getLanguage();
		$args = func_get_args();
		if (count($args) > 0) {
			$args[0] = $lang->_($args[0]);
			return call_user_func_array('sprintf', $args);
		}
		return '';
	}
	function printf($string)
	{
		$lang =& JFactory::getLanguage();
		$args = func_get_args();
		if (count($args) > 0) {
			$args[0] = $lang->_($args[0]);
			return call_user_func_array('printf', $args);
		}
		return '';
	}
}
class JRequest
{
	function getURI()
	{
		global $gEnvManager;
		
		return $gEnvManager->getCurrentRequestUri();
	}
	function getMethod()
	{
		$method = strtoupper($_SERVER['REQUEST_METHOD']);
		return $method;
	}
	function getVar($name, $default = null, $hash = 'default', $type = 'none', $mask = 0)
	{
		global $gRequestManager;
		
		return $gRequestManager->trimValueOf($name);
	}
	function getInt($name, $default = 0, $hash = 'default')
	{
		return intval(self::getVar($name, $default, $hash, 'int'));
	}
	function getFloat($name, $default = 0.0, $hash = 'default')
	{
		return self::getVar($name, $default, $hash, 'float');
	}
	function getBool($name, $default = false, $hash = 'default')
	{
		return self::getVar($name, $default, $hash, 'bool');
	}
	function getWord($name, $default = '', $hash = 'default')
	{
		return self::getVar($name, $default, $hash, 'word');
	}
	function getCmd($name, $default = '', $hash = 'default')
	{
		return self::getVar($name, $default, $hash, 'cmd');
	}
	function getString($name, $default = '', $hash = 'default', $mask = 0)
	{
		return self::getVar($name, $default, $hash, 'string', $mask);
	}
}
class JConfig {
	/**
	* -------------------------------------------------------------------------
	* Site configuration section
	* -------------------------------------------------------------------------
	*/
	/* Site Settings */
	var $offline = '0';
	var $offline_message = 'This site is down for maintenance.<br /> Please check back again soon.';
	var $sitename = 'Joomla!';			// Name of Joomla site
	var $editor = 'tinymce';
	var $list_limit = '20';
	var $legacy = '0';

	/**
	* -------------------------------------------------------------------------
	* Database configuration section
	* -------------------------------------------------------------------------
	*/
	/* Database Settings */
	var $dbtype = 'mysql';					// Normally mysql
	var $host = 'localhost';				// This is normally set to localhost
	var $user = '';							// MySQL username
	var $password = '';						// MySQL password
	var $db = '';							// MySQL database name
	var $dbprefix = 'jos_';					// Do not change unless you need to!

	/* Server Settings */
	var $secret = 'FBVtggIk5lAzEU9H'; 		//Change this to something more secure
	var $gzip = '0';
	var $error_reporting = '-1';
	var $helpurl = 'http://help.joomla.org';
	var $xmlrpc_server = '1';
	var $ftp_host = '';
	var $ftp_port = '';
	var $ftp_user = '';
	var $ftp_pass = '';
	var $ftp_root = '';
	var $ftp_enable = '';
	var $tmp_path	= '/tmp';
	var $log_path	= '/var/logs';
	var $offset = '0';
	var $live_site = ''; 					// Optional, Full url to Joomla install.
	var $force_ssl = 0;		//Force areas of the site to be SSL ONLY.  0 = None, 1 = Administrator, 2 = Both Site and Administrator

	/* Session settings */
	var $lifetime = '15';					// Session time
	var $session_handler = 'database';

	/* Mail Settings */
	var $mailer = 'mail';
	var $mailfrom = '';
	var $fromname = '';
	var $sendmail = '/usr/sbin/sendmail';
	var $smtpauth = '0';
	var $smtpuser = '';
	var $smtppass = '';
	var $smtphost = 'localhost';

	/* Cache Settings */
	var $caching = '0';
	var $cachetime = '15';
	var $cache_handler = 'file';

	/* Debug Settings */
	var $debug      = '0';
	var $debug_db 	= '0';
	var $debug_lang = '0';

	/* Meta Settings */
	var $MetaDesc = 'Joomla! - the dynamic portal engine and content management system';
	var $MetaKeys = 'joomla, Joomla';
	var $MetaTitle = '1';
	var $MetaAuthor = '1';

	/* SEO Settings */
	var $sef = '0';
	var $sef_rewrite = '0';
	var $sef_suffix = '';

	/* Feed Settings */
	var $feed_limit   = 10;
	var $feed_email   = 'author';
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gEnvManager;
		
		$this->sitename = $gEnvManager->getSiteName();// サイト名称
		$this->tmp_path = $gEnvManager->getWorkDirPath();		// 一時ディレクトリ
	}
}
?>
