<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_mainPaymentWidgetContainer.php 2264 2009-08-28 06:08:21Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');

class ec_mainPaymentWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $cartDb;		// カートアクセス用ＤＢオブジェクト
	private $langId;			// 現在の言語
	private $userId;
	private $payMethod;			// 支払い方法
	private $ecObj;					// EC共通ライブラリオブジェクト
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const STANDARD_PRICE = 'selling';		// 通常価格
	const NEXT_TASK = 'confirm';		// 購入処理中の次の処理
	const GOBACK_TASK = 'delivmethod';		// 購入処理中の前の処理
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new ec_mainOrderDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $this->gInstance->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'payment.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$now = date("Y/m/d H:i:s");	// 現在日時
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$this->userId = $this->gEnv->getCurrentUserId();
		$defaultCurrency = $this->ecObj->getDefaultCurrency();		// 通貨
		
		$this->payMethod = $request->trimValueOf('item_payment_method');	// 支払い方法
		
		$act = $request->trimValueOf('act');
		if ($act == 'regist'){			// 確認画面へ
			$this->checkInput($this->payMethod, 'お支払い方法', 'お支払い方法が選択されていません');
			// エラーなしの場合
			if ($this->getMsgCount() == 0){
				// 保存値を取得
				if (empty($this->userId)){			// 非会員の購入の場合
					$cid = $this->gAccess->getClientId();			// ブラウザのクライアントID
					$ret = $this->db->getOrderSheetByClientId($cid, $row);		// クライアントIDで注文情報を取得
					if (!$ret) $this->db->delOrderSheetByClientId($this->gAccess->getClientId());		// エラーのときはエラーデータを削除
				} else {
					// 受注処理
					$cid = '';			// ブラウザのクライアントIDは使用しない
					$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
				}
				if ($ret){
					// 請求先の設定(顧客データをコピー)
					$row['oe_bill_id']			= $row['oe_custm_id'];
					$row['oe_bill_name']		= $row['oe_custm_name'];
					$row['oe_bill_name_kana']	= $row['oe_custm_name_kana'];
					$row['oe_bill_person']		= $row['oe_custm_person'];
					$row['oe_bill_person_kana']	= $row['oe_custm_person_kana'];
					$row['oe_bill_zipcode']		= $row['oe_custm_zipcode'];
					$row['oe_bill_state_id']	= $row['oe_custm_state_id'];
					$row['oe_bill_address1']	= $row['oe_custm_address1'];
					$row['oe_bill_address2']	= $row['oe_custm_address2'];
					$row['oe_bill_phone']		= $row['oe_custm_phone'];
					$row['oe_bill_fax']			= $row['oe_custm_fax'];
					$row['oe_bill_email']		= $row['oe_custm_email'];
					$row['oe_bill_country_id']	= $row['oe_custm_country_id'];
						
					$ret = $this->db->updateOrderSheet($this->userId, $this->langId, $cid,
						$row['oe_custm_id'], $row['oe_custm_name'], $row['oe_custm_name_kana'], $row['oe_custm_person'], $row['oe_custm_person_kana'],
						$row['oe_custm_zipcode'], $row['oe_custm_state_id'], $row['oe_custm_address1'], $row['oe_custm_address2'], $row['oe_custm_phone'], $row['oe_custm_fax'], $row['oe_custm_email'], $row['oe_custm_country_id'], 
						$row['oe_deliv_id'], $row['oe_deliv_name'], $row['oe_deliv_name_kana'], $row['oe_deliv_person'], $row['oe_deliv_person_kana'],
						$row['oe_deliv_zipcode'], $row['oe_deliv_state_id'], $row['oe_deliv_address1'], $row['oe_deliv_address2'], $row['oe_deliv_phone'], $row['oe_deliv_fax'], $row['oe_deliv_email'], $row['oe_deliv_country_id'],
						$row['oe_bill_id'], $row['oe_bill_name'], $row['oe_bill_name_kana'], $row['oe_bill_person'], $row['oe_bill_person_kana'], 
						$row['oe_bill_zipcode'], $row['oe_bill_state_id'], $row['oe_bill_address1'], $row['oe_bill_address2'], $row['oe_bill_phone'], $row['oe_bill_fax'], $row['oe_bill_email'], $row['oe_bill_country_id'],
						$row['oe_deliv_method_id'], $this->payMethod, $row['oe_card_type'], $row['oe_card_owner'], $row['oe_card_number'], $row['oe_card_expires'],
						$row['oe_demand_dt'], $row['oe_demand_time'], $row['oe_appoint_dt'], $row['oe_currency_id'], $row['oe_subtotal'], $row['oe_discount'], $row['oe_deliv_fee'], $row['oe_charge'], $row['oe_total']);
					if ($ret){
						// 確認画面へ遷移
						$deliveryPage = $this->gEnv->createCurrentPageUrl() . '&task=' . self::NEXT_TASK;
						$this->gPage->redirect($deliveryPage);
						return;
					}
				}
				$this->setAppErrorMsg('データ更新に失敗しました');
			}
		} else {		// 初期表示
			// 保存値を取得
			if (empty($this->userId)){			// 非会員の購入の場合
				$ret = $this->db->getOrderSheetByClientId($this->gAccess->getClientId(), $row);		// クライアントIDで注文情報を取得
				if (!$ret) $this->db->delOrderSheetByClientId($this->gAccess->getClientId());		// エラーのときはエラーデータを削除
			} else {
				$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
			}
			if ($ret){
				$this->payMethod = $row['oe_pay_method_id'];		// 支払い方法
			}
		}
		// 支払い方法メニューを作成
		$this->db->getAllPaymentMethod($this->langId, array($this, 'paymentMethodLoop'));
		
		// タイトルのCSSを設定
		$this->tmpl->addVar("_widget", "class", $this->gDesign->getDefaultContentHeadClassString());		// コンテンツヘッダ用CSSクラス
		
		// 遷移先を設定
		$this->tmpl->addVar("_widget", "goback_url", $this->getUrl($this->gEnv->createCurrentPageUrl() . '&task=' . self::GOBACK_TASK, true));		// 戻りボタン用画面
	}
	/**
	 * 取得した支払い方法をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function paymentMethodLoop($index, $fetchedRow, $param)
	{
		$checked = '';
		if ($fetchedRow['po_id'] == $this->payMethod){		// 選択中の支払い方法
			$checked = 'checked';
		}

		$row = array(
			'value'		=> $this->convertToDispString($fetchedRow['po_id']),			// ID
			'name'		=> $this->convertToDispString($fetchedRow['po_name']),		// 表示名
			'desc'		=> $fetchedRow['po_description'],							// 説明
			'checked'	=> $checked														// 選択中かどうか
		);
		$this->tmpl->addVars('payment_method_list', $row);
		$this->tmpl->parseTemplate('payment_method_list', 'a');
		return true;
	}
}
?>
