<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainEditmenuWidgetContainer.php 2479 2009-10-28 06:45:03Z fishbone $
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainEditmenuWidgetContainer extends admin_mainBaseWidgetContainer
{
	private $menuBasicItems;			// 元となるメニュー項目
	private $adminPages;			// 管理機能ウィジェットの選択可能画面
	private $widgets = array();				// ウィジェット情報
	private $widgetInfoStr;			// ウィジェット情報文字列
	private $pageInfoStr;			// 管理画面情報文字列
	private $menuItemExists;			// メニュー項目があるかどうか
	const TOPPAGE_IMAGE_PATH = 'toppage_image_path';				// トップページ画像
	const DEFAULT_NAV_ID = 'admin_menu';		// メニューID
	const DEFAULT_IMAGE_SIZE = 32;	// アイコンサイズ
	const TASK_ID_HEADE_WIDGET = 'configwidget_';		// ウィジェット管理画面
	const TASK_ID_HEAD_TITLE = '_';						// タイトル表示
	
	// メニュー項目タイプ
	const ITEM_TYPE_TITLE		= 'type_title';		// タイトル
	const ITEM_TYPE_CR			= 'type_cr';			// 改行
	const ITEM_TYPE_ADMIN_PAGE	= 'type_admin';	// 管理ウィジェットの管理画面
	const ITEM_TYPE_WIDGET_PAGE	= 'type_widget';	// ウィジェットの管理画面
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
		
		// 元となるメニュー項目
		$this->menuBasicItems = array(	array('type' => self::ITEM_TYPE_ADMIN_PAGE,	'name' => '管理機能の画面',		'desc' => '管理機能の画面を表示します。'),
										array('type' => self::ITEM_TYPE_WIDGET_PAGE,	'name' => 'ウィジェットの管理画面',	'desc' => 'ウィジェットの管理画面を表示します。'),
										array('type' => self::ITEM_TYPE_TITLE,		'name' => 'タイトル',		'desc' => 'メニューカテゴリのタイトル名を作成します。'),
										array('type' => self::ITEM_TYPE_CR,			'name' => '改行',			'desc' => 'メニューの項目ブロックを改行します。')
								);
		// 管理機能ウィジェットの選択可能画面
		$this->adminPages = array(	array('task' => 'pagedef',			'name' => 'PC用画面編集',		'desc' => 'PC用Webサイトの画面を作成します。'),
									array('task' => 'pagedef_mobile',	'name' => '携帯用画面編集',		'desc' => '携帯用Webサイトの画面を作成します。'),
									array('task' => 'widgetlist',		'name' => 'ウィジェット管理',	'desc' => 'ウィジェットの管理を行います。'),
									array('task' => 'templist',			'name' => 'テンプレート管理',	'desc' => 'テンプレートの管理を行います。'),
									array('task' => 'menudef',			'name' => 'メニュー定義(多階層)',		'desc' => '多階層でメニューを定義します。'),
									array('task' => 'smenudef',			'name' => 'メニュー定義(単一階層)',		'desc' => '単一階層でメニューを定義します。'),
									array('task' => 'master',			'name' => 'システムマスター管理', 		'desc' => 'システムに関するマスターデータの管理を行います。'),
									array('task' => 'userlist',			'name' => 'ユーザ一覧',			'desc' => 'ログイン可能なユーザを管理します。'),
									array('task' => 'loginstatus',		'name' => 'ログイン状況',		'desc' => 'ユーザのログイン状況を表示します。'),
									array('task' => 'configsite',		'name' => '基本情報',			'desc' => 'サイト運営者の設定を行います。'),
									array('task' => 'usercustom',		'name' => 'ユーザ定義変数管理',	'desc' => 'ユーザ定義の変数を管理します。'),
									array('task' => 'configsys',		'name' => 'システム情報',		'desc' => 'システム全体の設定、運用状況を管理します。'),
									array('task' => 'opelog',			'name' => '運用ログ参照',		'desc' => '運用ログを参照します。'),
									array('task' => 'accesslog',		'name' => 'アクセスログ参照',	'desc' => 'アクセスログを参照します。'),
									array('task' => 'resbrowse',		'name' => 'リソースブラウズ',	'desc' => 'リソースファイルを管理します。'),
									array('task' => 'initsystem',		'name' => 'DBメンテナンス',		'desc' => 'データの初期化などDBのメンテナンスを行います。'),
									array('task' => 'editmenu',			'name' => '管理メニュー編集',	'desc' => '管理メニューの編集を行います。'),
									array('task' => 'editsource',		'name' => 'ソース参照',			'desc' => 'ソースコードが参照できます。'),
									array('task' => 'createtable',		'name' => 'ユーザ定義テーブル', 'desc' => 'ユーザ定義のテーブルの作成、データの編集を行います。'),
									array('task' => 'logout',			'name' => 'ログアウト',			'desc' => 'ログアウト処理を行います。')
								);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'editmenu_others'){		// その他設定画面
			return 'editmenu_others.tmpl.html';
		} else {
			return 'editmenu.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'editmenu_others'){	// その他設定画面
			return $this->configOthers($request);
		} else {			// メニュー項目編集
			return $this->editMenuItems($request);
		}
	}
	/**
	 * メニュー項目編集
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function editMenuItems($request)
	{
		global $gEnvManager;
		
		$act = $request->trimValueOf('act');
		if ($act == 'update'){		// 設定更新のとき
			$valuesType = $request->trimValueOf('items_type');
			$valuesName = $request->trimValueOf('items_name');
			$valuesOption = $request->trimValueOf('items_option');
			$valuesParam = $request->trimValueOf('items_param');
			$valuesDesc = $request->trimValueOf('items_desc');
			
			$menuId = self::DEFAULT_NAV_ID;		// デフォルトの識別ID
			
			// トランザクション開始
			$this->db->startTransaction();
		
			// 一旦すべて削除
			$ret = $this->db->DelNavItems($menuId);
		
			// IDを求める
			$maxId = $this->db->getNavItemsMaxId();
			if (empty($maxId)){
				$maxId = 1;
			} else {
				$maxId++;
			}
			$parentId = $maxId;
			$id = $maxId;
			$index = 0;		// 表示順
			for ($i = 0; $i < count($valuesType); $i++){
				$type = $valuesType[$i];
				$name = $valuesName[$i];		// 表示名
				$param = $valuesParam[$i];
				$taskId = '';
				$control = 0;
				$helpTitle = $name;
				$helpBody = $valuesDesc[$i];// ヘルプ本文
				if ($type == self::ITEM_TYPE_ADMIN_PAGE){		// 管理機能ページ
					$index++;		// 表示順更新
					$taskId = $valuesOption[$i];		// 管理機能画面
				} else if ($type == self::ITEM_TYPE_WIDGET_PAGE){	// ウィジェットの管理画面
					$index++;		// 表示順更新
					$taskId = self::TASK_ID_HEADE_WIDGET . $valuesOption[$i];		// ウィジェット管理画面
				} else if ($type == self::ITEM_TYPE_TITLE){			// タイトル
					$parentId = 0;
					$index = 0;
					$taskId = self::TASK_ID_HEAD_TITLE . $id;						// 「_」付きのIDはリンクなし
				} else if ($type == self::ITEM_TYPE_CR){			// 改行
					$parentId = 0;
					$index = 0;
					$taskId = self::TASK_ID_HEAD_TITLE . $id;						// 「_」付きのIDはリンクなし
					$control = 1;
				}
				// キーの存在チェック
				$ret = $this->db->isExistsNavItemKey($menuId, $taskId, $param);
				if ($ret){			// キーが存在する場合は終了
					$this->setMsg(self::MSG_USER_ERR, '項目「' . $name . '」は重複しています');
					
					// トランザクション中止
					$this->db->cancelTransaction();
					break;
				} else {
					$ret = $this->db->addNavItems($menuId, $id, $parentId, $index, $taskId, $param, $control, $name, $helpTitle, $helpBody);
					// 項目ID更新
					if ($type == self::ITEM_TYPE_TITLE){			// タイトル
						$parentId = $id;
					}
					$id++;
				}
			}
			
			// トランザクション終了
			$ret = $this->db->endTransaction();
			if ($ret){
				$this->setMsg(self::MSG_GUIDANCE, '管理メニューを更新しました');
			} else {
				if ($this->getMsgCount() == 0) $this->setMsg(self::MSG_APP_ERR, '管理メニュー更新に失敗しました');
			}
		}
		// 管理画面メニュー作成
		$this->pageInfoStr = '';			// 管理画面情報
		$this->createAdminPageMenu();
		
		// ウィジェットメニュー作成
		$this->widgetInfoStr = '';
		$this->db->getAvailableWidgetListForEditMenu(array($this, 'widgetListLoop'));
		
		// メニュー基本項目一覧作成
		$this->createMenuBasicItemList();
		
		// メニュー設定項目作成
		$this->db->getNavItemsAll(self::DEFAULT_NAV_ID, array($this, 'menuItemListLoop'));
		if (!$this->menuItemExists) $this->tmpl->setAttribute('menuassignedlist', 'visibility', 'hidden');// メニュー項目を非表示
		
		// ウィジェット情報を設定
		$this->widgetInfoStr = rtrim($this->widgetInfoStr, ',');
		$this->widgetInfoStr = '[' . $this->widgetInfoStr . ']';
		$this->tmpl->addVar("_widget", "widget_info", $this->widgetInfoStr);
		// 管理画面情報を設定
		$this->pageInfoStr = rtrim($this->pageInfoStr, ',');
		$this->pageInfoStr = '[' . $this->pageInfoStr . ']';
		$this->tmpl->addVar("_widget", "page_info", $this->pageInfoStr);
		
		// パスを設定
		$this->tmpl->addVar("_widget", "top_url", $this->getUrl($gEnvManager->getDefaultAdminUrl()));		// トップメニュー画面URL
	}
	/**
	 * その他の設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function configOthers($request)
	{
		global $gEnvManager;
		
		$reloadData = false;
		$act = $request->trimValueOf('act');
		if ($act == 'update'){		// 行更新のとき
			$topImage = $request->trimValueOf('item_image');		// 管理メニュー画像
			if (!empty($topImage) && strncmp($topImage, '/', strlen('/')) != 0) $topImage = '/' . $topImage;
			
			// 入力チェック
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$isErr = false;
				if (!$isErr){
					if (!$this->db->updateSystemConfig(self::TOPPAGE_IMAGE_PATH, $topImage)) $isErr = true;
				}
				if ($isErr){		// エラーのとき
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$reloadData = true;		// データの再読み込み					
				}
			}
		} else {
			$reloadData = true;
		}
		if ($reloadData){		// データ再取得のとき
			$toppageImg = $this->db->getSystemConfig(self::TOPPAGE_IMAGE_PATH);
		}
		$this->tmpl->addVar('_widget', 'image', $toppageImg);
	}
	/**
	 * ウィジェットリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function widgetListLoop($index, $fetchedRow, $param)
	{
		$id = $fetchedRow['wd_id'];
		$name = $this->convertToDispString($fetchedRow['wd_name']);
		$selected = '';
		$row = array(
			'value'    => $this->convertToDispString($id),			// ウィジェットID
			'name'     => $name,			// ウィジェット名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('widget_list', $row);
		$this->tmpl->parseTemplate('widget_list', 'a');
		
		$this->widgets[] = $row;				// ウィジェット情報
		$image = $this->getUrl($this->gDesign->getWidgetIconUrl($id, self::DEFAULT_IMAGE_SIZE));
		$desc = $this->convertToDispString($fetchedRow['wd_description']);
		$this->widgetInfoStr .= '{id:"' . $id . '",image:"' . $image . '",desc:"' . $desc . '"},';
		return true;
	}
	/**
	 * 管理画面メニュー作成
	 *
	 * @return なし						
	 */
	function createAdminPageMenu()
	{
		for ($j = 0; $j < count($this->adminPages); $j++){
			$task = $this->adminPages[$j]['task'];
			$name = $this->adminPages[$j]['name'];
			$selected = '';
			$menurow = array(
				'value'		=> $task,			// 機能値
				'name'		=> $name,			// 機能名
				'selected' => $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('admin_list', $menurow);
			$this->tmpl->parseTemplate('admin_list', 'a');
			
			$desc = $this->convertToDispString($this->adminPages[$j]['desc']);
			$this->pageInfoStr .= '{id:"' . $task . '",desc:"' . $desc . '"},';
		}
	}
	/**
	 * メニュー基本項目一覧作成
	 *
	 * @return なし						
	 */
	function createMenuBasicItemList()
	{
		for ($i = 0; $i < count($this->menuBasicItems); $i++){
			$targetObj = $this->menuBasicItems[$i];

			if ($targetObj['type'] == self::ITEM_TYPE_ADMIN_PAGE){		// 管理機能画面への遷移項目のとき
				$this->tmpl->addVar('menuavailablelist', 'type', 'admin_page');// 管理機能画面
			} else if ($targetObj['type'] == self::ITEM_TYPE_WIDGET_PAGE){		// ウィジェット管理画面への遷移項目のとき
				$this->tmpl->addVar('menuavailablelist', 'type', 'widget');// ウィジェット管理画面
			} else {
			}
			$row = array(
				'item_type' => $targetObj['type'],		// メニュー項目タイプ
				'name' => $targetObj['name'],		// 名前
				'desc' => $targetObj['desc']		// 説明
			);
			$this->tmpl->addVars('menuavailablelist', $row);
			$this->tmpl->parseTemplate('menuavailablelist', 'a');
		}
	}
	/**
	 * メニュー項目リスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function menuItemListLoop($index, $fetchedRow, $param)
	{
		$id = $fetchedRow['ni_id'];
		$name = $this->convertToDispString($fetchedRow['ni_name']);
		$task = $fetchedRow['ni_task_id'];
		$param = $fetchedRow['ni_param'];
		$desc = $fetchedRow['ni_help_body'];
		$title = '';	// 項目タイトル
		$option = '';	// 追加情報
		if (empty($fetchedRow['ni_view_control'])){			// 通常項目のとき
			if (strncmp($task, '_', strlen('_')) == 0){		// タイトル項目
				$type = 'type_title';		// 項目タイプ
				$title = 'タイトル';	// 項目タイトル
				$this->tmpl->addVar('menuassignedlist', 'type', 'title');		// タイトル、
			} else if (strncmp($task, self::TASK_ID_HEADE_WIDGET, strlen(self::TASK_ID_HEADE_WIDGET)) == 0){		// ウィジェット管理画面
				$widgetId = str_replace(self::TASK_ID_HEADE_WIDGET, '', $task);
				$widgetName = '';
				for ($i = 0; $i < count($this->widgets); $i++){
					if ($this->widgets[$i]['value'] == $widgetId){
						$widgetName = $this->widgets[$i]['name'];
						break;
					}
				}
				$type = 'type_widget';		// 項目タイプ
				$option = $widgetId;	// 追加情報
				$title = 'ウィジェット[' . $widgetName . ']';
				$this->tmpl->addVar('menuassignedlist', 'type', 'subitem');// 管理機能、ウィジェット管理画面
			} else {		// 管理機能画面
				// 管理機能画面情報取得
				$taskName = '';
				for ($i = 0; $i < count($this->adminPages); $i++){
					if ($this->adminPages[$i]['task'] == $task){
						$taskName = $this->adminPages[$i]['name'];
						break;
					}
				}
				$type = 'type_admin';		// 項目タイプ
				$option = $task;	// 追加情報
				$title = '管理機能[' . $taskName . ']';
				$this->tmpl->addVar('menuassignedlist', 'type', 'subitem');// 管理機能、ウィジェット管理画面
			}
		} else {	// 改行項目のとき
			$type = 'type_cr';		// 項目タイプ
			$title = '改行';	// 項目タイトル
		}
		$row = array(
			'item_type'		=> $type,
			'option'	=> $option,
			'title'		=> $this->convertToDispString($title),
			'name'		=> $name,			// 表示名
			'desc'		=> $desc,			// 説明
			'param'		=> $param			// 追加パラメータ
		);
		$this->tmpl->addVars('menuassignedlist', $row);
		$this->tmpl->parseTemplate('menuassignedlist', 'a');
		
		$this->menuItemExists = true;			// メニュー項目があるかどうか
		return true;
	}
}
?>
