<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainWidgetContainer.php 2517 2009-11-05 04:56:20Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');

class admin_mainWidgetContainer extends admin_mainBaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * ディスパッチ処理(メインコンテナのみ実行)
	 *
     * HTTPリクエストの内容を見て処理をコンテナに振り分ける
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return bool 						このクラスの_setTemplate(), _assign()へ処理を継続するかどうかを返す。
	 *                                      true=処理を継続、false=処理を終了
	 */
	function _dispatch($request, &$param)
	{
		$cmd = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_COMMAND);

		// システム制御画面を表示するかどうか
		// ログインの場合はログイン処理へ
		if ($this->gPage->getSystemHandleMode() > 0
				&& ($cmd != M3_REQUEST_CMD_LOGIN ||	($cmd == M3_REQUEST_CMD_LOGIN && $request->isGetMethod()))){	// GETで来たログインコマンドはログインとしない
			if ($cmd == M3_REQUEST_CMD_PREVIEW || $cmd == M3_REQUEST_CMD_LOGIN){		// プレビュー画面への遷移のとき
				$param = 'userlogin';			// ユーザログイン画面表示
			} else {
				$this->SetMsg(0, "ただいまサイトのメンテナンス中です");
				$param = 'message';			// メッセージ画面表示
				
				// メンテナンスモードに設定
				$this->gEnv->setIsMaintenance(true);
			}
			return true;
		}

		// 直接実行の場合
		if($cmd == M3_REQUEST_CMD_DO_WIDGET){		// ウィジェット単体実行
			// 管理者権限がなければ実行できない
			if ($this->gEnv->isSystemAdmin() || $this->gAccess->isValidAdminKey($request)){
				// コンテナを起動
				$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
				switch ($task){
					case 'filebrowse':			// ファイルブラウズ
						$this->gLaunch->goSubWidget($task);
						return false;
				}
			}
		}
		
		// ログイン、ログアウト処理を行う
		// 処理を行った場合は現在の画面へリダイレクト
		// ログイン失敗時あるいは、ログインログアウト以外の場合返ってくる
		$retValue = $this->gPage->standardLoginLogoutRedirect($request, $success);
		if ($retValue == 0){
			if ($this->gEnv->isCurrentUserLogined()){	// ログインしている場合
				if ($this->gEnv->isSystemAdmin()){	// システム管理者の場合
					// 表示画面を決定
					$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
					$taskSrc = $task;
					if (empty($task)){	// デフォルト値
						$task = 'top';
					} else if ($task == 'master'){		// マスター管理
						$task = 'pageinfo';			// ページ情報をデフォルトにする
					} else if ($task == 'userlist_detail'){		// ユーザ詳細
						$task = 'userlist';
					} else if ($task == 'pagedef_detail' ||		// ページ定義詳細
								$task == 'pagedef_mobile'){		// 携帯用ページ定義詳細
						$task = 'pagedef';
					} else if ($task == 'edittable' ||		// テーブルデータ編集一覧
								$task == 'edittable_detail'){		// テーブルデータ編集詳細
						$task = 'edittable';
					} else if ($task == 'editmenu' ||		// 管理メニュー編集
								$task == 'editmenu_others'){		// 管理メニュー編集その他
						$task = 'editmenu';
					} else if ($task == 'pageinfo' ||				// ページ情報
								$task == 'pageinfo_detail'){		// ページ情報詳細
						$task = 'pageinfo';
					} else if ($task == 'pageid' ||				// ページID一覧
								$task == 'pageid_detail'){		// ページID詳細
						$task = 'pageid';
					} else if ($task == 'menuid' ||				// メニューID一覧
								$task == 'menuid_detail'){		// メニューID詳細
						$task = 'menuid';
					} else if ($task == 'opelog' ||				// 運用ログ一覧
								$task == 'opelog_detail'){		// 運用ログ詳細
						$task = 'opelog';
					} else if ($task == 'accesslog' ||				// アクセスログ一覧
								$task == 'accesslog_detail'){		// アクセスログ詳細
						$task = 'accesslog';
					} else if ($task == 'menudef' ||				// メニュー定義
								$task == 'menudef_detail'){		// メニュー定義詳細
						$task = 'menudef';
					} else if ($task == 'smenudef' ||				// 単一階層メニュー定義
								$task == 'smenudef_detail'){		// 単一階層メニュー定義詳細
						$task = 'smenudef';
					} else if ($task == 'pagehead' ||				// ページヘッダ情報
								$task == 'pagehead_detail'){		// ページヘッダ情報
						$task = 'pagehead';
					}
					
					// オプション表示
					if (strncmp($task, 'configwidget_', strlen('configwidget_')) == 0){// $taskが「configwidget_xxxx」タイプの場合の処理
						$task = 'configwidget';
					} else if (strncmp($task, 'showpage_', strlen('showpage_')) == 0){// $taskが「showpage_xxxx」タイプの場合の処理
						$task = 'showpage';
					}
		
					// コンテナを起動
					switch ($task){
						case 'test';			// テスト用画面
						case 'top';			// トップ画面
						case 'userlist':	// ユーザリスト
						case 'loginstatus':	// ログイン状況
						case 'widgetlist':	// ウィジェットリスト
						case 'templist':	// テンプレートリスト
						case 'pagedef':		// 画面定義
						case 'initsystem':	// システム初期化
						case 'configsys':	// システム設定
						case 'configwidget':	// ウィジェット定義
						case 'adjustwidget':	// ウィジェット位置調整
						case 'editsource':	// ソース編集
						case 'usercustom':	// ユーザ定義値管理
						case 'createtable':		// テーブル作成
						case 'edittable':		// テーブル編集
						case 'editmenu':		// メニュー編集
						case 'pageinfo':		// ページ情報
						case 'pageid':			// ページID
						case 'menuid':			// メニューID
						case 'opelog':			// 運用ログ
						case 'accesslog':			// アクセスログ
						case 'resbrowse':			// リソースブラウズ
						case 'filebrowse':			// ファイルブラウズ
						case 'menudef':			// メニュー定義
						case 'smenudef':			// 単一階層メニュー定義
						case 'configsite':			// サイト情報
						case 'pagehead':			// ページヘッダ情報
							$this->gLaunch->goSubWidget($task);
							return false;
						case 'logout':		// ログアウト処理
							$logoutPage = $this->gEnv->createCurrentPageUrl() . '&cmd=logout';
							$this->gPage->redirect($this->getUrl($logoutPage));
							break;
						case 'showpage':	// 管理画面別ページ表示
							list($taskName, $pageSubId) = explode('_', $taskSrc, 2);
							$otherPage = $this->gEnv->getDefaultAdminUrl() . '?sub=' . $pageSubId;
							$this->gPage->redirect($this->getUrl($otherPage));
							break;
						default:
							$this->SetMsg(0, "アクセスできません");
							$param = 'message';			// メッセージ画面表示
							break;
					}
				} else {		// システム管理者以外の場合
					$this->SetMsg(0, "ログインに失敗しました");
				}
			} else {		// ログインしていないとき
				// メッセージは何も表示しないでログイン画面へ
			}
		} else if ($retValue == 1 && $success == false){	// ログイン失敗の場合
			$this->SetMsg(0, "ログインに失敗しました");
		}
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		if ($param == 'message'){		// メッセージ表示のとき
			return 'message.tmpl.html';
		} else if ($param == 'userlogin'){		// ユーザログイン画面
			return 'userlogin.tmpl.html';
		} else {
			return 'index.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		// POST先URLを設定
		//$this->tmpl->addVar("_widget", "POST_URL", $this->gEnv->getRootUrl() . '/admin/index.php');
		
		// ディレクトリを設定
		//$this->tmpl->addVar("_widget", "script_url", $this->gEnv->getScriptsUrl());
	}
}
?>
