<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: _installInitdbWidgetContainer.php 2355 2009-09-25 05:34:08Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installInitdbWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	private $createTableScripts;			// テーブル作成スクリプト
	private $insertTableScripts;			// データインストールスクリプト
	const SERVER_ID = 'server_id';
	const INSTALL_DT = 'install_dt';		// システムインストール日時
	const WORK_DIR = 'work_dir';			// 一時ディレクトリ
	const UPDATE_DIR = 'update';			// 追加スクリプトディレクトリ名

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new _installDB();
		$this->sysDb = $this->gInstance->getSytemDbObject();
		
		// 実行SQLスクリプトファイルの定義
		$this->createTableScripts = array(	array(	'filename' 		=> 'create_base.sql',					// ファイル名
													'name'			=> 'システム基本テーブル作成',				// 表示名
													'description'	=> 'システムで最小限必要なテーブルの作成'),	// 説明
											array(	'filename' 		=> 'create_std.sql',					// ファイル名
													'name'			=> 'システム標準テーブル作成',				// 表示名
													'description'	=> 'システムを通常使用するのに必要なテーブルの作成'),	// 説明
											array(	'filename' 		=> 'create_ec.sql',					// ファイル名
													'name'			=> 'Eコマース用テーブル',				// 表示名
													'description'	=> 'Eコマース用テーブルの作成'));	// 説明

		$this->insertTableScripts = array(	array(	'filename' 		=> 'insert_base.sql',					// ファイル名
													'name'			=> 'システム基本データ登録',				// 表示名
													'description'	=> 'システムで最小限必要なデータの登録'),	// 説明
											array(	'filename' 		=> 'insert_std.sql',					// ファイル名
													'name'			=> 'システム標準データ登録',				// 表示名
													'description'	=> 'システムを通常使用するのに必要なデータの登録'));	// 説明
													
		// デバッグモードで起動している場合はテスト用スクリプト追加
		if (M3_SYSTEM_DEBUG){
			$this->createTableScripts[] = array(	'filename' 		=> 'create_test.sql',					// ファイル名
													'name'			=> 'テスト用テーブル作成',				// 表示名
													'description'	=> 'テスト用に必要なテーブルの作成');	// 説明
		}
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'initdb.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'initdb'){	// DB構築
			return $this->createInit($request);
		} else if ($task == 'updatedb'){			// DBバージョンアップ
			return $this->createUpdate($request);
		}
	}
	/**
	 * DB初期化画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @return								なし
	 */
	function createInit($request)
	{
		$now = date("Y/m/d H:i:s");	// 現在日時
		$task = $request->trimValueOf('task');
		$act = $request->trimValueOf('act');
		$type = $request->trimValueOf('install_type');
		$from = $request->trimValueOf('from');
		
		if ($act == 'done'){
			// ##### SQLスクリプトを実行 #####
			$filename = '';
			$ret = true;
			
			// タイムアウトを停止
			$this->gPage->setNoTimeout();
			
			// トランザクション開始
			//$this->gDb->startTransaction();		// PostgreSQLでは途中で落ちるのではずす
			
			// テーブル作成
			if ($ret){
				for ($i = 0; $i < count($this->createTableScripts); $i++){
					//$ret = $this->gDb->execInitScriptFile($this->createTableScripts[$i]['filename'], $errors);
					$ret = $this->gInstance->getDbManager()->execInitScriptFile($this->createTableScripts[$i]['filename'], $errors);
					if (!$ret){
						$filename = $this->createTableScripts[$i]['filename'];
						break;// 異常終了の場合
					}
				}
			}
			// 初期データインストール
			if ($ret){
				for ($i = 0; $i < count($this->insertTableScripts); $i++){
					//$ret = $this->gDb->execInitScriptFile($this->insertTableScripts[$i]['filename'], $errors);
					$ret = $this->gInstance->getDbManager()->execInitScriptFile($this->insertTableScripts[$i]['filename'], $errors);
					if (!$ret){
						$filename = $this->insertTableScripts[$i]['filename'];
						break;// 異常終了の場合
					}
				}
			}
			
			// ##### 初期データ登録 #####
			if ($ret){
				// デフォルト値設定
				
				// 初期値設定
				$serverId = md5($this->gEnv->getRootUrl() . time());		// サーバID
				if ($ret) $ret = $this->sysDb->updateSystemConfig(self::SERVER_ID, $serverId);
				if ($ret) $ret = $this->sysDb->updateSystemConfig(self::INSTALL_DT, $now);
				if ($ret) $ret = $this->sysDb->updateSystemConfig(M3_TB_FIELD_DB_UPDATE_DT, $now);
				if ($ret) $ret = $this->sysDb->updateSystemConfig(self::WORK_DIR, M3_SYSTEM_WORK_DIR_PATH);// 一時ディレクトリ
			}
			// ##### これ以降、DBへのログ出力可能 #####
			if ($ret){
				$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);
				$this->gOpeLog->writeInfo(__METHOD__, 'DBを作成しました。 DBバージョン: ' . $currentVer, 1001);
			}
			
			// テーブルのパッチを当てる
			if ($ret){
				$ret = $this->updateDb($filename, $updateErrors);
				// エラーメッセージ追加
				if (!$ret){
					if (!isset($errors)) $errors = array();
					array_splice($errors, count($errors), 0, $updateErrors);
				}
			}
			
			// トランザクション終了
			//$this->gDb->endTransaction();// PostgreSQLでは途中で落ちるのではずす
			
			if ($ret){// 正常終了の場合
				// ログ出力
				$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);
				$this->gOpeLog->writeInfo(__METHOD__, 'DB構築処理が正常に終了しました。現在のDBバージョン: ' . $currentVer, 1000);
				
				$type = 'all';
				$this->gPage->redirect('?task=initother&install_type=' . $type . '&from=initdb');
			} else {
				$msg = 'ＤＢ初期化に失敗しました';
				if (!empty($filename)) $msg .= '(スクリプト名=' . $filename . ')';
				$this->setMsg(self::MSG_APP_ERR, $msg);
				
				// ログ出力
				$this->gOpeLog->writeError(__METHOD__, $msg, 1100);
			}
			// エラーメッセージを画面に表示
			if (!empty($errors)){
				foreach ($errors as $error) {
					$this->setMsg(self::MSG_APP_ERR, $error);
				}
			}
		}
		if ($from == 'inputparam'){		// 接続情報の入力画面からの遷移のとき
			$msg = 'DBを構築します';
			$this->tmpl->addVar("_widget", "from", $from);		// 戻り画面を設定
		} else {		// DBのバージョンアップ方法の選択画面からの遷移のとき
			$msg = 'DBを構築します<br />既存のデータはすべて削除されます';
		}
		// 画面の設定
		$this->tmpl->addVar("_widget", "task", $task);		// 実行処理を設定
		$this->tmpl->addVar("_widget", "title", 'ＤＢ構築');		// ＤＢ構築
		$this->tmpl->addVar("_widget", "message", $msg);		// ＤＢ構築
	}
	/**
	 * DBバージョンアップ画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @return								なし
	 */
	function createUpdate($request)
	{
		$now = date("Y/m/d H:i:s");	// 現在日時
		$task = $request->trimValueOf('task');
		$act = $request->trimValueOf('act');
		$type = $request->trimValueOf('install_type');
		
		if ($act == 'done'){
			if ($this->getUpdateScriptCount() > 0){
				// タイムアウトを停止
				$this->gPage->setNoTimeout();
			
				// テーブルのパッチを当てる
				$ret = $this->updateDb($filename, $updateErrors);
			
				if ($ret){// 正常終了の場合
					// デフォルト値設定
					
					// 更新日時を設定
					$now = date("Y/m/d H:i:s");	// 現在日時
					$this->sysDb->updateSystemConfig(M3_TB_FIELD_DB_UPDATE_DT, $now);
				
					// システム初期化を不可に設定(インストール終了)
					$this->gSystem->disableInitSystem();
				
					// ログ出力
					$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);
					$this->gOpeLog->writeInfo(__METHOD__, 'DB更新処理が正常に終了しました。現在のDBバージョン: ' . $currentVer, 1000);
				
					$type = 'all';
					$this->gPage->redirect('?task=initother&install_type=' . $type . '&from=updatedb');
				} else {
					// エラーメッセージ追加
					if (!$ret){
						if (!isset($errors)) $errors = array();
						array_splice($errors, count($errors), 0, $updateErrors);
					}
					
					$msg = 'DB更新に失敗しました';
					if (!empty($filename)) $msg .= '(スクリプト名=' . $filename . ')';
					$this->setMsg(self::MSG_APP_ERR, $msg);
				
					// ログ出力
					$this->gOpeLog->writeError(__METHOD__, $msg, 1100);
				}
				// エラーメッセージを画面に表示
				if (!empty($errors)){
					foreach ($errors as $error) {
						$this->setMsg(self::MSG_APP_ERR, $error);
					}
				}
			} else {		// DB更新用スクリプトファイルがないとき
				// デフォルト値設定
				
				// システム初期化を不可に設定(インストール終了)
				$this->gSystem->disableInitSystem();
			
				// ログ出力
				$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);
				$this->gOpeLog->writeInfo(__METHOD__, 'DBを更新する必要はありません。DBバージョン: ' . $currentVer, 1000);
			
				$type = 'all';
				$this->gPage->redirect('?task=initother&install_type=' . $type . '&from=updatedb');
			}
		}
			
		// 画面の設定
		$this->tmpl->addVar("_widget", "task", $task);		// 実行処理を設定
		$this->tmpl->addVar("_widget", "title", 'ＤＢバージョンアップ');		// ＤＢバージョンアップ
		$this->tmpl->addVar("_widget", "message", '既存データを残して、DBをバージョンアップします');		// ＤＢバージョンアップ
	}
	/**
	 * DBをバージョンアップ
	 *
	 * @param string $filename		エラーがあったファイル名
	 * @param array $errors			エラーメッセージ
	 * @return bool					true=成功、false=失敗
	 */
	function updateDb(&$filename, &$errors)
	{
		$ret = true;
		
		// SQLスクリプトディレクトリのチェック
		$dir = $this->gEnv->getSqlPath() . '/' . self::UPDATE_DIR;
		$files = $this->getUpdateScriptFiles($dir);
		for ($i = 0; $i < count($files); $i++){
			// ファイル名のエラーチェック
			$fileCheck = true;
			list($foreVer, $to, $nextVer, $tmp) = explode('_', basename($files[$i], '.sql'));
			
			if (!is_numeric($foreVer)) $fileCheck = false;
			if (!is_numeric($nextVer)) $fileCheck = false;
			if ($fileCheck && intval($foreVer) >= intval($nextVer)) $fileCheck = false;

			// DBのバージョンをチェックして問題なければ実行
			if ($fileCheck){
				// 現在のバージョンを取得
				$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);
				if ($foreVer != $currentVer) continue;	// バージョンが異なるときは読みとばす
			
				//$ret = $this->gDb->execInitScriptFile(self::UPDATE_DIR . '/' . $files[$i], $errors);
				$ret = $this->gInstance->getDbManager()->execInitScriptFile(self::UPDATE_DIR . '/' . $files[$i], $errors);
				if ($ret){
					// 成功の場合はDBのバージョンを更新
					$this->sysDb->updateSystemConfig(M3_TB_FIELD_DB_VERSION, $nextVer);
					
					// 更新情報をログに残す
					$this->gOpeLog->writeInfo(__METHOD__, 'DBをバージョンアップしました。 DBバージョン: ' . $foreVer . 'から'. $nextVer, 1002);
				} else {
					$filename = $files[$i];
					break;// 異常終了の場合
				}
			} else {
				// ファイル名のエラーメッセージを出力
				$this->gOpeLog->writeWarn(__METHOD__, 'DBバージョンアップ用のスクリプトファイルに不正なファイルを検出しました。 ファイル名: ' . $files[$i], 1101);
			}
		}
		return $ret;
	}
	/**
	 * DBバージョンアップ用のスクリプトファイルの数を取得
	 *
	 * @return int			スクリプトファイル数
	 */
	function getUpdateScriptCount()
	{
		$count = 0;// ファイル数初期化
		$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);// 現在のバージョンを取得
		
		// SQLスクリプトディレクトリのチェック
		$dir = $this->gEnv->getSqlPath() . '/' . self::UPDATE_DIR;
		$files = $this->getUpdateScriptFiles($dir);
		for ($i = 0; $i < count($files); $i++){
			// ファイル名のエラーチェック
			$fileCheck = true;
			list($foreVer, $to, $nextVer, $tmp) = explode('_', basename($files[$i], '.sql'));
			
			if (!is_numeric($foreVer)) $fileCheck = false;
			if (!is_numeric($nextVer)) $fileCheck = false;
			if ($fileCheck && intval($foreVer) >= intval($nextVer)) $fileCheck = false;

			// バージョンをチェックして問題なければカウント
			if ($fileCheck){
				if (intval($foreVer) >= intval($currentVer)) $count++;
			}
		}
		return $count;
	}
	/**
	 * 追加用スクリプトファイルを取得
	 *
	 * @param string $path		読み込みパス
	 * @return array			スクリプトファイル名
	 */
	function getUpdateScriptFiles($path)
	{
		$files = array();
		if (is_dir($path)){
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . '/' . $file;
				$pathParts = pathinfo($file);
				$ext = $pathParts['extension'];		// 拡張子
					
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0 &&	// 「_」で始まる名前のファイルは読み込まない
					$ext == 'sql'){		// 拡張子が「.sql」のファイルだけを読み込む
					$files[] = $file;
				}
			}
			$dir->close();
		}
		// 取得したファイルは番号順にソートする
		sort($files);
		return $files;
	}
}
?>
