<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainPagedefWidgetContainer.php 2417 2009-10-15 09:17:53Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainPagedefWidgetContainer extends BaseAdminWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// システム情報取得用
	private $serialNo;	// シリアルNo
	private $pageId;	// ページID
	private $pageSubId;	// ページサブID
	private $position;	// 表示ポジション
	private $defaultPageSubId;		// デフォルトのページID
	private $widgetArray = array();
	private $templateId;		// テンプレートID
	const DEFAULT_IMAGE_SIZE = 32;// ウィジェット画像サイズ
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		$task = $request->trimValueOf('task');
		if ($task == 'pagedef_detail'){		// 詳細設定画面
			return 'pagedef_detail.tmpl.html';
		} else if ($task == 'pagedef_mobile'){		// 携帯用設定画面
			return 'pagedef_mobile.tmpl.html';
		} else {			// 画面定義画面
			return 'pagedef.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'pagedef_detail'){	// 詳細設定画面
			return $this->createDetail($request);
		} else {			// 画面作成画面
			return $this->createView($request);
		}
	}
	/**
	 * 画面定義画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createView($request)
	{
		// 環境値取得
		$userId = $this->gEnv->getCurrentUserId();
				
		// パラメータの取得
		$task = $request->trimValueOf('task');		// 処理区分
		$act = $request->trimValueOf('act');
		$this->pageId = $request->trimValueOf('pageid');		// ページID
		$this->pageSubId = $request->trimValueOf('pagesubid');// ページサブID
		if (empty($this->pageId)){
			if ($task == 'pagedef_mobile'){		// 携帯用設定画面のとき
				$this->pageId = $this->gEnv->getDefaultMobilePageId();				// 携帯用デフォルト値取得
			} else {			// PC用画面のとき
				$this->pageId = $this->gEnv->getDefaultPageId();				// デフォルト値取得
			}
		}
		if (empty($this->pageSubId)) $this->pageSubId = $this->gEnv->getDefaultPageSubIdByPageId($this->pageId);// デフォルト値取得
		
		if ($act == 'changetemplate'){		// テンプレート変更のとき
			$templateId = $request->trimValueOf('sel_template');		// テンプレートID
			if (!empty($templateId)){
				if ($task == 'pagedef_mobile'){		// 携帯用設定画面のとき
					$this->gSystem->changeDefaultMobileTemplate($templateId);
				} else {
					$this->gSystem->changeDefaultTemplate($templateId);
			
					// セッションのテンプレートIDを更新
					$request->setSessionValue(M3_SESSION_CURRENT_TEMPLATE, $templateId);
				}
				// キャッシュデータをクリア
				$this->gCache->clearAllCache();
			}
		}
		
		if ($task == 'pagedef_mobile'){		// 携帯用設定画面のとき
			// ページメインIDメニュー作成
			$this->db->getPageIdList(array($this, 'pageIdLoop'), 0/*ページID*/, 1/*携帯*/);
		
			// デフォルトのテンプレートを取得
			$this->templateId = $this->gSystem->defaultMobileTemplateId();
			$imagePath = $this->gEnv->getTemplatesUrl() . '/' . $this->templateId . '/template_thumbnail.png';
			$this->tmpl->addVar("_widget", "TMPL_IMAGE", $this->getUrl($imagePath));							// プレビュー画像
			
			// テンプレート選択メニュー作成
			$this->db->getAllTemplateList(1/* 携帯用 */, array($this, 'templateIdLoop'));
		
			// ウィジェットリストを取得
		//	$this->db->getAvailableMobileWidgetList(array($this, 'widgetListLoop'));
		} else {			// PC用設定画面のとき
			// ページメインIDメニュー作成
			$this->db->getPageIdList(array($this, 'pageIdLoop'), 0/*ページID*/, 0/*携帯以外*/);
			
			// デフォルトのテンプレートを取得
			$this->templateId = $this->gSystem->defaultTemplateId();
			$imagePath = $this->gEnv->getTemplatesUrl() . '/' . $this->templateId . '/template_thumbnail.png';
			$this->tmpl->addVar("_widget", "TMPL_IMAGE", $this->getUrl($imagePath));							// プレビュー画像
			
			// テンプレート選択メニュー作成
			$this->db->getAllTemplateList(0/* PC用 */, array($this, 'templateIdLoop'));
		
			// ウィジェットリストを取得
		//	$this->db->getAvailableWidgetList(array($this, 'widgetListLoop'));
		}

		// ページサブIDメニュー作成(ページメインIDを先に作成してから)
		$this->db->getPageIdList(array($this, 'pageSubIdLoop'), 1/*サブページID*/);

		// URLを設定
		$path = '';
		$pathArray = explode('_', $this->pageId);
		for ($i = 0; $i < count($pathArray); $i++){
			$path .= '/' . $pathArray[$i];
		}
		//$url = $this->gEnv->getRootUrl() . $path . '.php';
		$url = $this->gEnv->getRootUrlByPage($this->pageId, $this->pageSubId) . $path . '.php';
		if ($this->pageSubId == $this->defaultPageSubId){
			$urlWithSession = $url . '?' . $this->gAccess->getSessionIdUrlParam();		// セッションIDをURLに追加
		} else {
			$url .= '?sub=' . $this->pageSubId;
			$urlWithSession = $url . '&' . $this->gAccess->getSessionIdUrlParam();		// セッションIDをURLに追加
		}
		$this->tmpl->addVar("_widget", "url", $url);		// getUrl()は掛けない
		$this->tmpl->addVar("_widget", "url_with_session", $urlWithSession);		// セッションID付きURL(携帯のみ使用)。getUrl()は掛けない
		
		// 管理用URL設定
		$adminUrl = $this->gEnv->getDefaultAdminUrl() . '?page=' . $this->pageId . '&sub=' . $this->pageSubId;
		$this->tmpl->addVar("_widget", "admin_url", $this->getUrl($adminUrl));
		
		// ウィジェットIDのリスト
		$widgetList = '';
		if (!empty($this->widgetArray)) $widgetList = implode($this->widgetArray, ',');
		$this->tmpl->addVar("_widget", "widget_list", $widgetList);
		
		if ($this->db->canDetailConfig()){		// 詳細設定可のときは、ページID選択を可にする
			$this->tmpl->setAttribute('hide_page_id', 'visibility', 'visible');// ページID選択メニュー
			$this->tmpl->addVar('_widget', 'page_id_col', 'colspan="4"');		// カラム数を調整
		} else {
			$this->tmpl->addVar('_widget', 'page_id_col', 'colspan="2"');		// カラム数を調整
		}
	}
	/**
	 * 詳細設定画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		// 環境値取得
		$userId = $this->gEnv->getCurrentUserId();
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		$this->pageId = $request->trimValueOf('pageid');		// ページID
		$this->pageSubId = $request->trimValueOf('pagesubid');// ページサブID
		if (empty($this->pageId)) $this->pageId = $this->gEnv->getDefaultPageId();				// デフォルト値取得
		if (empty($this->pageSubId)) $this->pageSubId = $this->gEnv->getDefaultPageSubIdByPageId($this->pageId);// デフォルト値取得
		$this->position = $request->trimValueOf('position');	// 表示ポジション
		
		if ($act == 'updateline'){		// 更新のとき
			// 変更可能値
			$selectedItemNo = $request->trimValueOf('no');		// 処理対象の項目番号
			$updateIndex = $request->trimValueOf('item' . $selectedItemNo . '_index');			// 表示インデックス
			$instanceDefId = $request->trimValueOf('item' . $selectedItemNo . '_def_id');		// 定義ID
			if ($instanceDefId == '') $instanceDefId = 0;
			$updateVisible = ($request->trimValueOf('item' . $selectedItemNo . '_visible') == 'on') ? 1 : 0;		// 表示状態

			// 変更前値を取得
			if ($this->db->getPageDef($this->serialNo, $row)){
				//$updatePageSubId = $row['pd_sub_id'];
				$updatePos = $row['pd_position_id'];
				$updateWidgetId = $row['pd_widget_id'];
				
				// 「共通」項目に合わせて、ページサブIDの修正
				$updatePageSubId = '';// 共通使用
				if ($request->trimValueOf('item' . $selectedItemNo . '_shared') != 'on') $updatePageSubId = $this->pageSubId;
			
				// 入力チェック
				$this->checkNumeric($updateIndex, '表示順');
			
				// エラーなしの場合は、データを登録
				if ($this->getMsgCount() == 0){
					$ret = $this->db->updatePageDef($this->serialNo, $this->pageId, $updatePageSubId, $updatePos, $updateIndex, $updateWidgetId, $instanceDefId,
														'', '', $updateVisible, $userId);
					if ($ret){		// データ更新成功のとき
						$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					} else {
						$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
					}
				}
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
			}
			// キャッシュデータをクリア
			$this->gCache->clearAllCache();
		} else if ($act == 'deleteline'){		// 削除のとき
			$ret = $this->db->delPageDef($this->serialNo, $userId);
			if ($ret){		// データ削除成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'データを削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ削除に失敗しました');
			}
			// キャッシュデータをクリア
			$this->gCache->clearAllCache();
		} else if ($act == 'deleteall'){		// すべて削除のとき
			$withCommon = ($request->trimValueOf('with_common') == 'on') ? 1 : 0;		// 共通項目も削除するかどうか
			$ret = $this->db->delPageDefAll($this->pageId, $this->pageSubId, $this->position, $withCommon);
			if ($ret){		// データ削除成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'データを削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ削除に失敗しました');
			}
			// キャッシュデータをクリア
			$this->gCache->clearAllCache();
		}		

		// 定義詳細一覧表示
		$this->db->getPageDefList(array($this, 'pageListLoop'), $this->pageId, $this->pageSubId, $this->position);
			
		// ポジションメニュー作成
		$this->db->getPagePositionList(array($this, 'pagePositionLoop'));
		
		// 値を再設定
		$this->tmpl->addVar('_widget', 'pageid', $this->pageId);		// ページID
		$this->tmpl->addVar('_widget', 'pagesubid', $this->pageSubId);		// ページサブID
		
		// 実際に表示する画面のURLを設定
		$path = '';
		$pathArray = explode('_', $this->pageId);
		for ($i = 0; $i < count($pathArray); $i++){
			$path .= '/' . $pathArray[$i];
		}
		//$url = $this->gEnv->getRootUrl() . $path . '.php';
		$url = $this->gEnv->getRootUrlByPage($this->pageId, $this->pageSubId) . $path . '.php';
		if ($this->pageSubId != $this->defaultPageSubId){
			$url .= '?sub=' . $this->pageSubId;
		}
		$this->tmpl->addVar("_widget", "url", $url);// getUrl()は掛けない
	}
	/**
	 * ページ定義、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageListLoop($index, $fetchedRow, $param)
	{
		// サブIDが空のときは、共通項目とする
		$isSharedItem = '';
		if (empty($fetchedRow['pd_sub_id'])){
			$isSharedItem = 'checked';
		}
		// 編集不可項目のときは、ボタンを使用不可にする
		$buttonEnabled = '';
		if (!$fetchedRow['pd_editable']){
			$buttonEnabled = 'disabled';
		}
		// 項目を画面に表示するかどうか
		$itemVisible = '';
		if ($fetchedRow['pd_visible']) $itemVisible = 'checked';
		
		// 定義ID
		$defId = $fetchedRow['pd_config_id'];
		//if ($defId == '0') $defId = '';
		
		// インスタンス定義を使用するかどうか
		$hasInstanceDef = '';
		$detaiButton = '';
		if ($fetchedRow['wd_use_instance_def']){		// 定義ありの場合
			//if ($defId != '') $hasInstanceDef = 'style="background-color:yellow;"';
		} else {
			$detaiButton = 'disabled';
			$hasInstanceDef = 'readonly';
			$defId = '';		// 定義IDは空に設定
		}
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		$row = array(
			'line_color'	=> $lineColor,											// 行のカラー
			'no'			=> $index + 1,											// 行番号
			'serial' 		=> $this->convertToDispString($fetchedRow['pd_serial']),			// シリアルNo
//			'id' 			=> $this->convertToDispString($fetchedRow['wd_id']),			// ウィジェットID
			'name'			=> $this->convertToDispString($fetchedRow['wd_name']),		// 名前
			'position'		=> $this->convertToDispString($fetchedRow['pd_position_id']),	// 表示ポジション
			'index'			=> $this->convertToDispString($fetchedRow['pd_index']),				// 表示順
			'widget_id'		=> $this->convertToDispString($fetchedRow['pd_widget_id']),				// ウィジェットID
			'widget_name'		=> $this->convertToDispString($fetchedRow['wd_name']),				// ウィジェット名
			'def_id'		=> $this->convertToDispString($defId),			// 定義ID
			'suffix'		=> $this->convertToDispString($fetchedRow['pd_suffix']),			// サフィックス
			'shared'		=> $isSharedItem,												// 共通項目かどうか
			'visible'		=> $itemVisible,												// 画面に表示するかどうか
			'has_instance_def' => $hasInstanceDef,								// インスタンス定義が必要かどうか
			'detail_button' => $detaiButton,												// ボタン使用制御
			'update_button' => $buttonEnabled,												// ボタン使用制御
			'delete_button'	=> $buttonEnabled,												// ボタン使用制御
		);
		$this->tmpl->addVars('page_def_list', $row);
		$this->tmpl->parseTemplate('page_def_list', 'a');
		return true;
	}
	/**
	 * ページID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['pg_id'] == $this->pageId){
			$selected = 'selected';
			
			// デフォルトのページサブIDを取得
			$this->defaultPageSubId = $fetchedRow['pg_default_sub_id'];		// デフォルトのページID
		}
		$name = $this->convertToDispString($fetchedRow['pg_id']) . ' - ' . $this->convertToDispString($fetchedRow['pg_name']);			// ページ名
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $name,			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('main_id_list', $row);
		$this->tmpl->parseTemplate('main_id_list', 'a');
		return true;
	}
	/**
	 * ページサブID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageSubIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$pid = $fetchedRow['pg_id'];
		if ($pid == $this->pageSubId){
			$selected = 'selected';
		}
		$value = $this->convertToDispString($pid);
		
		// 表示ラベルを作成
		$private = '';			// 公開状態
		if (!$fetchedRow['pg_active']) $private = '[非公開]';
		$name = $value . $private . ' - ' . $this->convertToDispString($fetchedRow['pg_name']);
		// デフォルトのページサブIDのときは、説明を付加
		if ($pid == $this->defaultPageSubId){
			$name .= '[デフォルト値]';
		}
		$row = array(
			'value'    => $value,			// ページID
			'name'     => $name,			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sub_id_list', $row);
		$this->tmpl->parseTemplate('sub_id_list', 'a');
		return true;
	}
	/**
	 * テンプレート一覧を作成
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function templateIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['tm_id'] == $this->templateId){
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['tm_id']),			// テンプレートID
			'name'     => $this->convertToDispString($fetchedRow['tm_name']),			// テンプレート名名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sel_template_list', $row);
		$this->tmpl->parseTemplate('sel_template_list', 'a');
		return true;
	}
	/**
	 * ページポジション、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pagePositionLoop($index, $fetchedRow, $param)
	{
		// フィルタリング用
		$selected = '';
		if ($fetchedRow['tp_id'] == $this->position){
			$selected = 'selected';
		}
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['tp_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['tp_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('position_list', $row);
		$this->tmpl->parseTemplate('position_list', 'a');
		return true;
	}
	/**
	 * ウィジェットリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function widgetListLoop($index, $fetchedRow, $param)
	{
		$hasScript = '';
		if ($fetchedRow['wd_read_scripts']){
			$hasScript = 'checked';
		}
		$hasCss = '';
		if ($fetchedRow['wd_read_css']){
			$hasCss = 'checked';
		}
		$hasAdmin = '0';
		if ($fetchedRow['wd_has_admin']){
			$hasAdmin = '1';
		}
		// 編集不可項目のときは、ボタンを使用不可にする
		$buttonEnabled = '';
		if (!$fetchedRow['wd_editable']) $buttonEnabled = 'disabled';
		
		// 管理画面がないときは、詳細ボタンを使用不可にする
		$detailButtonEnabled = '';
		if (!$fetchedRow['wd_has_admin']) $detailButtonEnabled = 'disabled';
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		
		// 新規に追加されたウィジェットかチェック
		$id = $this->convertToDispString($fetchedRow['wd_id']);
		$idText = $id;
		for ($i = 0; $i < count($this->newWidget); $i++){
			if ($this->newWidget[$i] == $id){
				$idText = '<b><font color="green">' . $id . '</font></b>';
				break;
			}
		}
		
		// ウィジェット名
		$name = $this->convertToDispString($fetchedRow['wd_name']);
		
		// ウィジェットの画像を設定
		$image = $this->gDesign->getWidgetIconUrl($id, self::DEFAULT_IMAGE_SIZE);
		$imageTag = '<img class="widget_obj" src="' . $this->getUrl($image) . '" ';
		$imageTag .= 'width="' . self::DEFAULT_IMAGE_SIZE . '"';
		$imageTag .= ' height="' . self::DEFAULT_IMAGE_SIZE . '"';
		$imageTag .= ' />';
		
		$message = '<b>' . $name . '</b><br>' . $id;
		$imageTag = '<span class="tooltip_text" href="#" >' . $imageTag . '</span>';
		
		// ウィジェットの説明の作成
		//$tipText = $this->gInstance->getHelpManager()->createTipText($name, $this->convertToDispString($fetchedRow['wd_description']));

		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['wd_serial']),			// シリアル番号
			'id' => $id,			// ID
			'widget_id' => 'widget_' . $id,
			'widget_name'		=> $this->convertToDispString($fetchedRow['wd_name']),				// ウィジェット名
			'id_text' => $idText,
			'name' => $name,		// 名前
			'image_tag' => $imageTag,		// 画像
			'tip' => $tipText				// 説明文字列
		);
		$this->tmpl->addVars('widgetlist', $row);
		$this->tmpl->parseTemplate('widgetlist', 'a');
		
		$this->widgetArray[] = $id;
		return true;
	}
}
?>
