<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainMasterBaseWidgetContainer.php 2235 2009-08-19 02:00:26Z fishbone $
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');

class admin_mainMasterBaseWidgetContainer extends admin_mainBaseWidgetContainer
{
	const HELP_KEY_PAGEINFO = 'pageinfo';
	const HELP_KEY_PAGEID = 'pageid';
	const HELP_KEY_MENUID = 'menuid';
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		// 表示画面を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = 'top';
		
		// パンくずリストを作成
		switch ($task){
			case 'pageinfo':	// ページ情報一覧
			case 'pageinfo_detail':	// ページ情報詳細
				$linkList = ' &gt;&gt; ページ情報';
				break;
			case 'pageid':	// ページID一覧
			case 'pageid_detail':	// ページID詳細
				$linkList = ' &gt;&gt; ページID';
				break;
		}
				
		// ####### 上段メニューの作成 #######
		$menuText = '<div id="configmenu-upper">' . M3_NL;
		$menuText .= '<ul>' . M3_NL;
		
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId();
				
		// ### ページ情報 ###
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . 'task=pageinfo';
		if ($task == 'pageinfo'){
			$current = 'id="current"';
		}
		// ヘルプを作成
		$helpText = $this->gHelp->getHelpText(self::HELP_KEY_PAGEINFO);
		$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span ' . $helpText . '>ページ情報</span></a></li>' . M3_NL;
		
		// ### ページID ###
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . 'task=pageid';
		if ($task == 'pageid'){
			$current = 'id="current"';
		}
		// ヘルプを作成
		$helpText = $this->gHelp->getHelpText(self::HELP_KEY_PAGEID);
		$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span ' . $helpText . '>ページID</span></a></li>' . M3_NL;
		
		// ### メニューID ###
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . 'task=menuid';
		if ($task == 'menuid'){
			$current = 'id="current"';
		}
		// ヘルプを作成
		$helpText = $this->gHelp->getHelpText(self::HELP_KEY_MENUID);
		$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span ' . $helpText . '>メニューID</span></a></li>' . M3_NL;
		
		// 上段メニュー終了
		$menuText .= '</ul>' . M3_NL;
		$menuText .= '</div>' . M3_NL;
		
		// 作成データの埋め込み
		$linkList = '<div id="configmenu-top"><label>' . 'システムマスター管理' . $linkList . '</div>';
		$outputText .= '<table width="90%"><tr><td>' . $linkList . $menuText . '</td></tr></table>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $outputText);
	}
}
?>
