<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainConfigsiteWidgetContainer.php 2235 2009-08-19 02:00:26Z fishbone $
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainConfigsiteWidgetContainer extends admin_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $defaultLang;		// デフォルト言語
	
	const TEST_MAIL_FORM = 'test';		// テストメールフォーム
	const LICENSE_KEY		= 'license_key';		// ライセンスキー
	const LICENSE_EMAIL		= 'license_email';		// ライセンスメール
	const LICENSE_NAME = 'license_company_name';	// ライセンス会社名
	const LICENSE_ZIPCODE	= 'license_company_zipcode';	// ライセンス郵便番号
	const LICENSE_ADDRESS	= 'license_company_address';	// ライセンス住所
	const LICENSE_FAX		= 'license_company_fax';	// ライセンスFAX

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'configsite.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// ユーザ情報、表示言語
		$userInfo		= $this->gEnv->getCurrentUserInfo();
		$this->defaultLang		= $this->gEnv->getDefaultLanguage();
			
		$act = $request->trimValueOf('act');
		if ($act == 'update'){		// 設定更新のとき
			$licenseKey = $request->trimValueOf('license_key');		// ライセンスキー
			$licenseEmail = $request->trimValueOf('license_email');		// ライセンスメールアドレス
			$licenseName = $request->trimValueOf('license_name');		// ライセンス会社名
			$licenseZipcode = $request->trimValueOf('license_zipcode');		// ライセンス郵便番号
			$licenseAddress = $request->trimValueOf('license_address');		// ライセンス住所
			$licenseFax = $request->trimValueOf('license_fax');		// ライセンスFAX
			//$siteOwner	= $request->trimValueOf('siteowner');		// サイト所有者
			//$siteCopyRight	= $request->trimValueOf('sitecopyright');		// サイト著作権
			$siteName	= $request->trimValueOf('sitename');		// サイト名称
			$siteEmail	= trim($request->valueOf('siteemail'));		// サイトEメール
			
			$siteTitle = $request->trimValueOf('site_title');		// 画面タイトル
			if (empty($siteTitle)) $siteTitle = $siteName;			// タイトル名が設定されていないときはデフォルトでサイト名称を設定
			$siteDesc = $request->trimValueOf('site_description');		// サイト要約
			$siteKeyword = $request->trimValueOf('site_keyword');		// サイトキーワード
		
			$isErr = false;
			/*if (!$isErr && !empty($lang)){
				if (!$this->db->updateSystemConfig(self::DEFAULT_LANG, $lang)) $isErr = true;
			}*/
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, self::LICENSE_KEY, $licenseKey)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, self::LICENSE_EMAIL, $licenseEmail)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, self::LICENSE_NAME, $licenseName)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, self::LICENSE_ZIPCODE, $licenseZipcode)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, self::LICENSE_ADDRESS, $licenseAddress)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, self::LICENSE_FAX, $licenseFax)) $isErr = true;
			}			
			/*
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_OWNER, $siteOwner)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_COPYRIGHT, $siteCopyRight)) $isErr = true;
			}*/
			if (!$isErr){		// サイト名
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_NAME, $siteName)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_EMAIL, $siteEmail)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_TITLE, $siteTitle)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_DESCRIPTION, $siteDesc)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($this->defaultLang, M3_TB_FIELD_SITE_KEYWORDS, $siteKeyword)) $isErr = true;
			}
			if ($isErr){
				$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
			} else {
				$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
			}
			// システムパラメータを更新
			$this->gEnv->loadSystemParams();
			
			// 値を再取得
			$this->defaultLang		= $this->gEnv->getDefaultLanguage();
		} else if ($act == 'testmail'){		// テストメール送信のとき
			$mail = $this->gEnv->getSiteEmail(true);
			if (empty($mail)){
				$this->setAppErrorMsg('メールアドレスが設定されていません');
			} else {
				$mailParam = array();
				$mailParam['BODY']  = 'URL:      ' . $this->gEnv->getRootUrl() . M3_NL;
				$mailParam['BODY'] .= '送信日時: ' . date("Y年m月d日 H時i分s秒") . M3_NL;
				$mailParam['BODY'] .= '送信者  : ' . $this->gEnv->getCurrentUserName() . M3_NL;
				$ret = $this->gMail->sendFormMail(2/*手動送信*/, $this->gEnv->getCurrentWidgetId(), $mail, $mail, '', '', self::TEST_MAIL_FORM, $mailParam);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'メールを送信しました。メールアドレス: ' . $mail);
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'メール送信に失敗しました。メールアドレス: ' . $mail);
				}
			}
		}
		// 画面にデータを埋め込む
		$siteEmail = $this->gEnv->getSiteEmail(true);
		$this->tmpl->addVar("_widget", "license_key", $this->db->getSiteDef($this->defaultLang, self::LICENSE_KEY));
		$this->tmpl->addVar("_widget", "license_email", $this->db->getSiteDef($this->defaultLang, self::LICENSE_EMAIL));
		$this->tmpl->addVar("_widget", "license_name", $this->db->getSiteDef($this->defaultLang, self::LICENSE_NAME));
		$this->tmpl->addVar("_widget", "license_zipcode", $this->db->getSiteDef($this->defaultLang, self::LICENSE_ZIPCODE));
		$this->tmpl->addVar("_widget", "license_address", $this->db->getSiteDef($this->defaultLang, self::LICENSE_ADDRESS));
		$this->tmpl->addVar("_widget", "license_fax", $this->db->getSiteDef($this->defaultLang, self::LICENSE_FAX));
		/*
		$this->tmpl->addVar("_widget", "site_owner", $this->gEnv->getSiteOwner(true));
		$this->tmpl->addVar("_widget", "site_copyright", $this->gEnv->getSiteCopyRight(true));*/
		$this->tmpl->addVar("_widget", "site_name", $this->gEnv->getSiteName(true));		// サイト名
		$this->tmpl->addVar("_widget", "site_email", $siteEmail);
		// SEO
		$this->tmpl->addVar("_widget", "site_title", $this->db->getSiteDef($this->defaultLang, M3_TB_FIELD_SITE_TITLE));
		$this->tmpl->addVar("_widget", "site_desc", $this->db->getSiteDef($this->defaultLang, M3_TB_FIELD_SITE_DESCRIPTION));
		$this->tmpl->addVar("_widget", "site_keyword", $this->db->getSiteDef($this->defaultLang, M3_TB_FIELD_SITE_KEYWORDS));
		
		// メール送信ボタン
		if (empty($siteEmail)) $this->tmpl->addVar("_widget", "test_mail_disabled", 'disabled');
	}
}
?>
