<?php
/**
 * システム制御マネージャー
 *
 *  主にシステムの動作に関わる制御の仲介を行う
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: systemManager.php 1919 2009-05-22 13:48:07Z fishbone $
 * @link       http://www.magic3.org
 */
require_once(M3_SYSTEM_INCLUDE_PATH . '/common/core.php');		// Magic3コアクラス

class SystemManager extends Core
{
	private $sitePcInPublic;			// PC用サイトの公開状況
	private $siteMobileInPublic;		// 携帯用サイトの公開状況
	const CF_SITE_PC_IN_PUBLIC = 'site_pc_in_public';				// PC用サイトの公開状況
	const CF_SITE_MOBILE_IN_PUBLIC = 'site_mobile_in_public';		// 携帯用サイトの公開状況
			
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
			
		// システムDBオブジェクト取得
		$this->db = $this->gInstance->getSytemDbObject();
		
		// 初期値を取得、初期値が取得できないときはデフォルト値を取得
		if ($this->gEnv->canUseDb()){		// DBが使用可能なときはDBから初期値を取得
			$this->sitePcInPublic(true);
			$this->siteMobileInPublic(true);
		} else {
			$this->sitePcInPublic = '1';			// PC用サイトの公開状況
			$this->siteMobileInPublic = '1';		// 携帯用サイトの公開状況
		}
	}
	
	/**
	 * システム初期化可能どうかを返す
	 *
	 * @return bool		true=システム初期化モード、false=システム初期化しない
	 */
	public function canInitSystem()
	{
		$retValue = $this->db->getSystemConfig('permit_init_system');
		if ($retValue == '1'){
			return true;
		} else {
			return false;
		}
	}
	/**
	 * システム初期化可能にする
	 *
	 * @return 		なし
	 */
	public function enableInitSystem()
	{
		$this->db->updateSystemConfig('permit_init_system', 1);
	}
	/**
	 * システム初期化を不可にする
	 *
	 * @return 		なし
	 */
	public function disableInitSystem()
	{
		$this->db->updateSystemConfig('permit_init_system', 0);
	}
	/**
	 * セッションを毎回更新するかどうかを返す
	 *
	 * @return bool		true=毎回更新、false=更新しない
	 */
	public function regenerateSessionId()
	{
		$retValue = $this->db->getSystemConfig('regenerate_session_id');
		if ($retValue == '1'){
			return true;
		} else {
			return false;
		}
	}
	/**
	 * アップロード可能なファイルの最大サイズを返す
	 *
	 * @return string		バイトサイズ
	 */
	public function getMaxFileSizeForUpload()
	{	
		$limit = ini_get('upload_max_filesize') > ini_get('post_max_size') ? ini_get('post_max_size') : ini_get('upload_max_filesize');
		$limit = $limit > ini_get('memory_limit') ? ini_get('memory_limit') : $limit;
		return $limit;
	}
	/**
	 * PC用サイトを公開するかどうか
	 *
	 * @param bool $reload	再取得するかどうか
	 * @return bool			true=公開、false=非公開
	 */
	public function sitePcInPublic($reload = false)
	{
		if ($reload){
			$this->sitePcInPublic		= $this->db->getSystemConfig(self::CF_SITE_PC_IN_PUBLIC);			// PC用サイトの公開状況
			if ($this->sitePcInPublic == '') $this->sitePcInPublic = '1';		// デフォルトは公開
		}
		return $this->sitePcInPublic;			// PC用サイトの公開状況
	}
	/**
	 * 携帯用サイトを公開するかどうか
	 *
	 * @param bool $reload	再取得するかどうか
	 * @return bool			true=公開、false=非公開
	 */
	public function siteMobileInPublic($reload = false)
	{
		if ($reload){
			$this->siteMobileInPublic	= $this->db->getSystemConfig(self::CF_SITE_MOBILE_IN_PUBLIC);	// 携帯用サイトの公開状況
			if ($this->siteMobileInPublic == '') $this->siteMobileInPublic = '1';		// デフォルトは公開
		}
		return $this->siteMobileInPublic;			// 携帯用サイトの公開状況
	}
}
?>
