<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_mainLoginWidgetContainer.php 1583 2009-03-16 04:16:39Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainMemberDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_mainDb.php');

class ec_mainLoginWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $memberDb;
	private $orderDb;	// DB接続オブジェクト
	private $ecMailObj;	// メール連携オブジェクト
	const MAIL_OBJ_ID = 'ecmail';
	const EC_LIB_ID = "eclib";		// EC共通ライブラリオブジェクトID
	const CF_PERMIT_NON_MEMBER_ORDER = 'permit_non_member_order';			// 非会員の購入許可
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		//$this->db = new ec_mainOrderDb();
		$this->mainDb = new ec_mainDb();
		$this->memberDb = new ec_mainMemberDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
		$this->orderDb = new ec_mainOrderDb();
		
		// メール連携オブジェクト取得
		$this->ecMailObj = $this->gInstance->getObject(self::MAIL_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'login.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		$forward = $request->trimValueOf(M3_REQUEST_PARAM_FORWARD);		// 画面遷移用パラメータ

		// ログイン画面からデフォルトの遷移先は注文処理画面。変更する場合は、「forward」パラメータを設定する
		// ログイン状態を取得
		if ($this->gEnv->isCurrentUserLogined()){
			if (empty($forward)){
				// 既にログイン中のときは、注文開始画面へ
				$orderPage = $this->gEnv->createCurrentPageUrl() . '&task=order';
				$this->gPage->redirect($orderPage);
			} else {
				$forwardPage = $this->gEnv->createCurrentPageUrl() . '&' . $forward;
				$this->gPage->redirect($forwardPage);
			}
			return;
		}
		if ($act == 'ec_login'){			// 会員ログインのとき
			// アカウント、パスワード取得
			$account = $request->trimValueOf('ec_account');
			$password = $request->trimValueOf('password');

			// ユーザ認証
			if ($this->gAccess->userLoginByAccount($account, $password)){
				// 初回ログインのときは、仮会員を正会員にする
				$userId = $this->gEnv->getCurrentUserId();
				if ($userId != 0){
					$ret = $this->gInstance->getObject(self::EC_LIB_ID)->makeTmpMemberToProperMember($userId);
					if ($ret){
						$this->sysDb->makeNormalLoginUser($userId);// 一般ログインユーザに設定
					
						// ######## 会員登録のメールをイントラネット側に送信 ########
						$this->ecMailObj->sendMemberInfoToBackoffice(0/*新規登録*/, $userId);
					}
				}
				if (empty($forward)){
					// 注文開始画面へ
					$orderPage = $this->gEnv->createCurrentPageUrl() . '&task=order';
					$this->gPage->redirect($orderPage);
				} else {
					$forwardPage = $this->gEnv->createCurrentPageUrl() . '&' . $forward;
					$this->gPage->redirect($forwardPage);
				}
				return;
			} else {
				// ログイン状態を削除
				$this->gAccess->userLogout();
				
				$this->tmpl->addVar("_widget", "message", 'ログインに失敗しました');
			}
		} else if ($act == 'ec_maillogin'){			// メールからの会員ログインのとき
			// メールからのアクセスの場合は、ログイン後最初にパスワードを変更する
			$account = $request->trimValueOf('account');
			$pwd = $request->trimValueOf('pwd');
			$forward = 'task=changepwd';		// パスワードを変更
			
			$this->tmpl->addVar("_widget", "ec_account", $account);
			$this->tmpl->addVar("_widget", "ec_password", $pwd);
			$this->tmpl->addVar("_widget", "savepwd", $pwd);
			$this->tmpl->setAttribute('field_regmember', 'visibility', 'hidden');// 会員登録への遷移を削除
		}
		if ($act != 'ec_maillogin'){
			// 非会員の購入を許可している場合は、遷移可能にする
			$value = $this->mainDb->getConfig(self::CF_PERMIT_NON_MEMBER_ORDER);
			if (!empty($value)){
				$this->tmpl->setAttribute('field_nonmember', 'visibility', 'visible');
			}
		}
		
		// パラメータを画面に埋め込む
		$this->tmpl->addVar("field_regmember", "url_regmember", $this->gEnv->createCurrentPageUrl() . '&task=regmember');		// 会員登録画面遷移用
		$this->tmpl->addVar("field_nonmember", "url_order", $this->gEnv->createCurrentPageUrl() . '&task=order');				// 購入画面遷移用
		$this->tmpl->addVar("_widget", "forward", $forward);		// 遷移先を維持
	}
}
?>
