<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainAdjustwidgetWidgetContainer.php 1554 2009-03-05 05:05:27Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainAdjustwidgetWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $paramObj;		// パラメータ保存用オブジェクト
	private $itemAlignArray;	// 表示位置
	private $align;		// 表示位置
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new admin_mainDb();
		
		// 表示位置
		$this->itemAlignArray = array(	array(	'name' => '指定なし',	'value' => ''),
										array(	'name' => '左寄せ',	'value' => 'left'),
										array(	'name' => '中央',	'value' => 'center'),
										array(	'name' => '右寄せ',	'value' => 'right'));
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'adjustwidget.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// ページ定義IDとページ定義のレコードシリアル番号を取得
		$this->startPageDefParam($defSerial, $defConfigId, $this->paramObj);
		
		$lang	= $this->gEnv->getDefaultLanguage();

		$this->align	= $request->trimValueOf('item_align');	// 表示位置
		$marginTop = $request->trimValueOf('item_top');			// 上マージン
		$marginBottom = $request->trimValueOf('item_bottom');			// 下マージン
		$marginLeft = $request->trimValueOf('item_left');			// 左マージン
		$marginRight = $request->trimValueOf('item_right');			// 右マージン
		$act = $request->trimValueOf('act');
		
		$replaceNew = false;		// データを再取得するかどうか
		if ($act == 'update'){		// 行更新のとき
			// 入力チェック
			$this->checkNumeric($marginTop, 'マージン(上)', true);
			$this->checkNumeric($marginBottom, 'マージン(下)', true);
			$this->checkNumeric($marginLeft, 'マージン(左)', true);
			$this->checkNumeric($marginRight, 'マージン(右)', true);
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				// CSSを作成
				$style = '';
				if (!empty($this->align)) $style .= 'text-align:' . $this->align . ';';
				if (!empty($marginTop)) $style .= 'padding-top:' . $marginTop . 'px;';
				if (!empty($marginBottom)) $style .= 'padding-bottom:' . $marginBottom . 'px;';
				if (!empty($marginLeft)) $style .= 'padding-left:' . $marginLeft . 'px;';
				if (!empty($marginRight)) $style .= 'padding-right:' . $marginRight . 'px;';
				
				$ret = $this->db->updatePageDefStyle($defSerial, $style);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$replaceNew = true;			// データを再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else {		// 初期状態
			// 初期値設定
			$this->align = '';
			$marginTop = '';			// 上マージン
			$marginBottom = '';			// 下マージン
			$marginLeft = '';			// 左マージン
			$marginRight = '';			// 右マージン
			$replaceNew = true;
		}
		// 表示データ再取得
		if ($replaceNew){
			$ret = $this->db->getPageDef($defSerial, $row);
			if ($ret){
				$style = $row['pd_style'];
				if (!empty($style)){
					$lines = explode(';', $style);
					for ($i = 0; $i < count($lines); $i++){
						$keyValue = explode(':', $lines[$i]);
						$key = strtolower(trim($keyValue[0]));
						$value = strtolower(trim($keyValue[1]));
						switch ($key){
							case 'text-align':
								$this->align = $value;
								break;
							case 'padding-top':
								$marginTop = str_replace('px', '', $value);
								break;
							case 'padding-bottom':
								$marginBottom = str_replace('px', '', $value);
								break;
							case 'padding-left':
								$marginLeft = str_replace('px', '', $value);
								break;
							case 'padding-right':
								$marginRight = str_replace('px', '', $value);
								break;
						}
					}
				}
			}
		}
		
		// 表示位置選択メニュー作成
		$this->createItemAlignMenu();
		
		$this->tmpl->addVar("_widget", "top", $marginTop);				// 上マージン
		$this->tmpl->addVar("_widget", "bottom", $marginBottom);		// 下マージン
		$this->tmpl->addVar("_widget", "left", $marginLeft);			// 左マージン
		$this->tmpl->addVar("_widget", "right", $marginRight);			// 右マージン
		
		// ページ定義IDとページ定義のレコードシリアル番号を更新
		$this->endPageDefParam($defSerial, $defConfigId, $this->paramObj);
	}
	/**
	 * 表示位置選択メニュー作成
	 *
	 * @return なし
	 */
	function createItemAlignMenu()
	{
		for ($i = 0; $i < count($this->itemAlignArray); $i++){
			$value = $this->itemAlignArray[$i]['value'];
			$name = $this->itemAlignArray[$i]['name'];
			
			$selected = '';
			if ($value == $this->align) $selected = 'selected';
			
			$row = array(
				'value'    => $value,			// 値
				'name'     => $name,			// 名前
				'selected' => $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('item_align_list', $row);
			$this->tmpl->parseTemplate('item_align_list', 'a');
		}
	}
}
?>
