<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_mainShopinfoWidgetContainer.php 171 2008-01-21 11:03:22Z naoki $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainDb.php');

class admin_ec_mainShopinfoWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $defaultCurrency;		// デフォルト通貨
	const SHOP_NAME	= 'shop_name';		// ショップ名
	const SHOP_OWNER	= 'shop_owner';		// ショップオーナー名
	const SHOP_ADDRESS	= 'shop_address';		// ショップ住所
	const SHOP_PHONE	= 'shop_phone';		// ショップ電話番号
	const SHOP_EMAIL	= 'shop_email';		// ショップEmailアドレス
	
	const USE_EMAIL		= 'use_email';		// EMAIL機能が使用可能かどうか
	const AUTO_EMAIL_SENDER	= 'auto_email_sender';		// 自動送信メール用送信者アドレス
	const DEFAULT_CURRENCY	= 'default_currency';				// デフォルト通貨
			
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_shopinfo.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$shopName = $request->trimValueOf('shop_name');						// ショップ名
		$shopOwner = $request->trimValueOf('shop_owner');						// ショップオーナー名
		$shopAddress = $request->trimValueOf('shop_address');						// ショップ住所
		$shopPhone = $request->trimValueOf('shop_phone');						// ショップ電話番号
		$useEmail = ($request->trimValueOf('use_email') == 'on') ? 1 : 0;		// EMAIL機能が使用可能かどうか
		$shopEmail = $request->trimValueOf('email');						// ショップEmailアドレス
		$autoEmailSender = $request->trimValueOf('auto_email');						// 自動送信メールの送信元アドレス
		$this->defaultCurrency = $request->trimValueOf('currency');
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkMailAddress($shopEmail, 'ショップ宛てEメール');
			$this->checkMailAddress($autoEmailSender, '自動送信メールの送信元メールアドレス');
			$this->checkInput($this->defaultCurrency, 'デフォルト通貨');
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;
				if (!$isErr){
					if (!$this->db->updateConfig(self::SHOP_NAME, $shopName)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::SHOP_OWNER, $shopOwner)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::SHOP_ADDRESS, $shopAddress)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::SHOP_PHONE, $shopPhone)) $isErr = true;
				}												
				if (!$isErr){
					if (!$this->db->updateConfig(self::USE_EMAIL, $useEmail)) $isErr = true;
				}	
				if (!$isErr){
					if (!$this->db->updateConfig(self::SHOP_EMAIL, $shopEmail)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::AUTO_EMAIL_SENDER, $autoEmailSender)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::DEFAULT_CURRENCY, $this->defaultCurrency)) $isErr = true;
				}
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
			
				// 値を再取得
				$shopName = $this->db->getConfig(self::SHOP_NAME);						// ショップ名
				$shopOwner = $this->db->getConfig(self::SHOP_OWNER);						// ショップオーナー名
				$shopAddress = $this->db->getConfig(self::SHOP_ADDRESS);						// ショップ住所
				$shopPhone = $this->db->getConfig(self::SHOP_PHONE);						// ショップ電話番号
		
				$useEmail	= $this->db->getConfig(self::USE_EMAIL);
				$shopEmail	= $this->db->getConfig(self::SHOP_EMAIL);
				$autoEmailSender	= $this->db->getConfig(self::AUTO_EMAIL_SENDER);
				$this->defaultCurrency = $this->db->getConfig(self::DEFAULT_CURRENCY);		// デフォルト通貨
			}
		} else {		// 初期表示の場合
			$shopName = $this->db->getConfig(self::SHOP_NAME);						// ショップ名
			$shopOwner = $this->db->getConfig(self::SHOP_OWNER);						// ショップオーナー名
			$shopAddress = $this->db->getConfig(self::SHOP_ADDRESS);						// ショップ住所
			$shopPhone = $this->db->getConfig(self::SHOP_PHONE);						// ショップ電話番号
				
			$useEmail	= $this->db->getConfig(self::USE_EMAIL);
			$shopEmail	= $this->db->getConfig(self::SHOP_EMAIL);
			$autoEmailSender	= $this->db->getConfig(self::AUTO_EMAIL_SENDER);
			$this->defaultCurrency = $this->db->getConfig(self::DEFAULT_CURRENCY);		// デフォルト通貨
		}
		// 画面に書き戻す
		$this->tmpl->addVar("_widget", "shop_name", $shopName);		// ショップ名
		$this->tmpl->addVar("_widget", "shop_owner", $shopOwner);		// ショップオーナー名
		$this->tmpl->addVar("_widget", "shop_address", $shopAddress);		// ショップ住所
		$this->tmpl->addVar("_widget", "shop_phone", $shopPhone);		// ショップ電話番号
		
		$checked = '';
		if ($useEmail) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_email", $checked);
		$this->tmpl->addVar("_widget", "email", $shopEmail);
		$this->tmpl->addVar("_widget", "auto_email", $autoEmailSender);
		
		// 通貨タイプ選択メニュー作成
		$this->db->getCurrency($defaultLang, array($this, 'currencyLoop'));
	}
	/**
	 * 取得した通貨種別をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function currencyLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		$selected = '';
		if ($fetchedRow['cu_id'] == $this->defaultCurrency){
			$selected = 'selected';
		}
		$name = $this->convertToDispString($fetchedRow['cu_name']);

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['cu_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('currency_list', $row);
		$this->tmpl->parseTemplate('currency_list', 'a');
		return true;
	}
}
?>
