<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: _installInitdbWidgetContainer.php 1054 2008-10-02 09:51:56Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installInitdbWidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	private $createTableScripts = array();
	const SERVER_ID = 'server_id';
	const INSTALL_DT = 'install_dt';		// システムインストール日時
	const WORK_DIR = 'work_dir';			// 一時ディレクトリ

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
				
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new _installDB();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
		
		// 実行SQLスクリプトファイルの定義
		$this->createTableScripts = array(	array(	'filename' 		=> 'mysql_create_base.sql',					// ファイル名
													'name'			=> 'システム基本テーブル作成',				// 表示名
													'description'	=> 'システムで最小限必要なテーブルの作成'),	// 説明
											array(	'filename' 		=> 'mysql_insert_base.sql',					// ファイル名
													'name'			=> 'システム基本データ登録',				// 表示名
													'description'	=> 'システムで最小限必要なデータの登録'),	// 説明
											array(	'filename' 		=> 'mysql_create_standard.sql',					// ファイル名
													'name'			=> 'システム標準テーブル作成',				// 表示名
													'description'	=> 'システムを通常使用するのに必要なテーブルの作成'),	// 説明
											array(	'filename' 		=> 'mysql_insert_standard.sql',					// ファイル名
													'name'			=> 'システム標準データ登録',				// 表示名
													'description'	=> 'システムを通常使用するのに必要なデータの登録'),	// 説明
											array(	'filename' 		=> 'mysql_create_ec.sql',					// ファイル名
													'name'			=> 'Eコマース用テーブル',				// 表示名
													'description'	=> 'Eコマース用テーブルの作成'));	// 説明
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'initdb.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gPageManager;
		global $gEnvManager;
		global $gDbManager;		// DBマネージャー
		
		$act = $request->trimValueOf('act');
		$type = $request->trimValueOf('install_type');
		if ($act == ''){
		} else if ($act == 'done'){
			// ##### SQLスクリプトを実行 #####
			for ($i = 0; $i < count($this->createTableScripts); $i++){
				$ret = $gDbManager->execInitScriptFile($this->createTableScripts[$i]['filename'], $errors);
				if (!$ret) break;// 異常終了の場合
			}
			
			// ##### 初期データ登録 #####
			$serverId = md5($gEnvManager->getRootUrl() . time());		// サーバID
			$now = date("Y/m/d H:i:s");	// 現在日時
			if ($ret) $ret = $this->sysDb->updateSystemConfig(self::SERVER_ID, $serverId);
			if ($ret) $ret = $this->sysDb->updateSystemConfig(self::INSTALL_DT, $now);
			if ($ret) $ret = $this->sysDb->updateSystemConfig(self::WORK_DIR, M3_SYSTEM_WORK_DIR_PATH);// 一時ディレクトリ
			
			if ($ret){// 正常終了の場合
				$gPageManager->redirect('?task=initother&install_type=' . $type);
			} else {
				$this->setMsg(self::MSG_APP_ERR, "ＤＢ初期化に失敗しました");
			}
			if (!empty($errors)){
				foreach ($errors as $error) {
					$this->setMsg(self::MSG_APP_ERR, $error);
				}
			}
		} 
	}
}
?>
