<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: custom_headerWidgetContainer.php 264 2008-01-30 03:43:09Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class custom_headerWidgetContainer extends BaseWidgetContainer
{
	const IMAGE_DIR = 'image';				// 画像ディレクトリ名
	const DEFAULT_IMAGE = 'header9.png';		// デフォルトのヘッダ画像
	const DEFAULT_BG_COLOR = '#FFCC00';			// バックグランドデフォルトカラー
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;
		
		$title = 'title';	// ヘッダタイトル
		$desc = 'description';	// ヘッダ説明
		$url = 'http://www.sample.com';	// ヘッダURL
		$title_mtop = 10;			// ヘッダタイトルマージンtop
		$title_mleft = 20;			// ヘッダタイトルマージンleft
		$desc_mtop = 10;			// ヘッダ説明マージンtop
		$desc_mleft = 30;			// ヘッダ説明マージンleft
		$url_mtop = 10;			// ヘッダURLマージンtop
		$url_mright = 20;			// ヘッダURLマージンright
		$titleColor = '#FFFFFF';		// ヘッダタイトルカラー
		$descColor = '#FFFFFF';		// ヘッダ説明カラー
		$urlColor = '#FFFFFF';		// ヘッダURLカラー
		//$bgcolor = self::DEFAULT_BG_COLOR;					// ヘッダバックグランドカラー
		$bgcolor = '';
		$width	= 100;		// ヘッダの幅
		$height	= 100;		// ヘッダの高さ
		$widthType = 0;		// ヘッダの幅単位
		$heightType = 0;		// ヘッダの高さ単位
		$titleFontsize	= 30;// タイトルのフォントサイズ
		$descFontsize	= 14;// 説明のフォントサイズ
		$urlFontsize	= 18;	// URLのフォントサイズ
		$imageUrl = $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR . '/' . self::DEFAULT_IMAGE;// 画像へのパス
				
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$title	= $paramObj->title;			// ヘッダタイトル
			$desc	= $paramObj->desc;	// ヘッダ説明
			$url	= $paramObj->url;	// ヘッダURL
			$title_mtop = $paramObj->title_mtop;			// ヘッダタイトルマージンtop
			$title_mleft = $paramObj->title_mleft;			// ヘッダタイトルマージンleft
			$desc_mtop = $paramObj->desc_mtop;			// ヘッダ説明マージンtop
			$desc_mleft = $paramObj->desc_mleft;			// ヘッダ説明マージンleft
			$url_mtop = $paramObj->url_mtop;			// ヘッダURLマージンtop
			$url_mright = $paramObj->url_mright;			// ヘッダURLマージンright
			$titleColor = $paramObj->titleColor;		// ヘッダタイトルカラー
			$descColor = $paramObj->descColor;		// ヘッダ説明カラー
			$urlColor = $paramObj->urlColor;		// ヘッダURLカラー
			$bgcolor = $paramObj->bgcolor;		// ヘッダバックグランドカラー
			$width	= $paramObj->width;		// ヘッダの幅
			$height	= $paramObj->height;		// ヘッダの高さ
			$widthType = $paramObj->widthType;		// ヘッダの幅単位
			$heightType = $paramObj->heightType;		// ヘッダの高さ単位
			$titleFontsize	= $paramObj->titleFontsize;// タイトルのフォントサイズ
			$descFontsize	= $paramObj->descFontsize;// 説明のフォントサイズ
			$urlFontsize	= $paramObj->urlFontsize;	// URLのフォントサイズ
			$imageUrl	= $paramObj->imageUrl;							// 画像へのパス
		}

		// 表示データ埋め込み
		// 高さ、幅の単位
		if (empty($widthType)){		// ヘッダの幅単位
			$width .= '%';
		} else {
			$width .= 'px';
		}
		if (empty($heightType)){		// ヘッダの高さ単位
			$height .= '%';
		} else {
			$height .= 'px';
		}
		if (empty($imageUrl)){		// 画像を設定しないとき
			$width = 'width: ' . $width . ';';
			$height = 'height: ' . $height . ';';			
		} else {
			$image = '<img src="' . $imageUrl . '" width="' . $width . '" height="' . $height . '" style="z-index:0" />';
			$this->tmpl->addVar("_widget", "image", $image);		// 画像
			
			// CSSの高さ、幅をクリア
			$width = '';
			$height = '';
		}
		// フォントカラー
		if (!empty($titleColor)) $titleColor = "color: $titleColor;";		// ヘッダタイトルカラー
		if (!empty($descColor)) $descColor = "color: $descColor;";			// ヘッダ説明カラー
		if (!empty($urlColor)) $urlColor = "color: $urlColor;";				// ヘッダURLカラー
		
		// 背景色
		if (!empty($bgcolor)) $bgcolor = "background: $bgcolor;";
		
		// 表示文字列の位置
		if (!empty($title_mtop)) $title_mtop = 'margin-top: ' . $title_mtop . 'px;';
		if (!empty($title_mleft)) $title_mleft = 'margin-left: ' . $title_mleft . 'px;';
		if (!empty($desc_mtop)) $desc_mtop = 'margin-top: ' . $desc_mtop . 'px;';
		if (!empty($desc_mleft)) $desc_mleft = 'margin-left: ' . $desc_mleft . 'px;';
		if (!empty($url_mtop)) $url_mtop = 'margin-top: ' . $url_mtop . 'px;';
		if (!empty($url_mright)) $url_mright = 'margin-right: ' . $url_mright . 'px;';

		$this->tmpl->addVar("_widget", "title",	$title);
		$this->tmpl->addVar("_widget", "desc",	$desc);
		$this->tmpl->addVar("_widget", "url",	$url);
		$this->tmpl->addVar("_widget", "title_mtop",	$title_mtop);
		$this->tmpl->addVar("_widget", "title_mleft",	$title_mleft);
		$this->tmpl->addVar("_widget", "desc_mtop",	$desc_mtop);
		$this->tmpl->addVar("_widget", "desc_mleft",	$desc_mleft);
		$this->tmpl->addVar("_widget", "url_mtop",	$url_mtop);
		$this->tmpl->addVar("_widget", "url_mright",	$url_mright);
		$this->tmpl->addVar("_widget", "title_color", $titleColor);
		$this->tmpl->addVar("_widget", "desc_color", $descColor);
		$this->tmpl->addVar("_widget", "url_color", $urlColor);
		$this->tmpl->addVar("_widget", "bgcolor", $bgcolor);
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "title_fontsize",	$titleFontsize);
		$this->tmpl->addVar("_widget", "desc_fontsize",	$descFontsize);
		$this->tmpl->addVar("_widget", "url_fontsize",	$urlFontsize);
	}
}
?>
