<?php
/**
 * メールマネージャー
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: mailManager.php 20 2007-11-16 05:13:27Z fishbone $
 * @link       http://www.magic3.org
 */
class MailManager
{
	private $db;						// DBオブジェクト
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// システムDBオブジェクト取得
		$this->db = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * メールを送信
	 *
	 * mbstringが使用可能なときは、mb_send_mail()を使用してメールを送信。
	 * 使用不可の場合は、mail()で送信する。
	 * メールアドレスの指定は、「名前<name@sample.com>」形式のアドレスも可能とする。
	 * メールの内容は、メールフォームテーブルから取得し、パラメータを変換して作成。
	 * 送信したメールの内容はログテーブルに残す
	 *
	 * @param int $type				メール送信タイプ(0=未設定、1=自動送信、2=手動送信)
	 * @param string $widgetId		送信を行ったウィジェットID
	 * @param string $toAddress		送信先メールアドレス
	 * @param string $fromAddress	送信元メールアドレス
	 * @param string $replytoAddress	返信先メールアドレス(空の場合は$fromAddressを使用)
	 * @param string $subject		件名(空のときは、メールフォームテーブルから取得)
	 * @param string $formId		メールフォームID
	 * @param array  $params		本文置き換え文字列、連想配列で設定
	 * @return bool					true=成功、false=失敗
	 */
	public function sendFormMail($type, $widgetId, $toAddress, $fromAddress, $replytoAddress, $subject, $formId, $params)
	{
		global $gErrorManager;
		
		// 送信元、送信先のチェック
		if (empty($toAddress) || empty($fromAddress)){
			$gErrorManager->writeError(__METHOD__, 'メールアドレスが設定されていません(送信先=' . $toAddress . ', 送信元=' . $fromAddress . ')');
			return false;
		}
						
		// メール件名、本文を取得
		if (!$this->db->getMailForm($formId, $row)){
			$gErrorManager->writeError(__METHOD__, 'メールフォームが見つかりません(id=' . $formId . ')');
			return false;
		}
		
		if (empty($replytoAddress)) $replytoAddress = $fromAddress;
		$destSubject = empty($subject) ? $row['mf_subject'] : $subject;
		$destContent = $row['mf_content'];
		$destHeader = '';
		$errAddress = $fromAddress;		// エラーメールの送信先
		if (function_exists('mb_send_mail')){		// mbが使用可能なとき
			// 送信元のメールアドレスを設定
			if (separateMailAddress($fromAddress, $mail, $name)){		// メールアドレス、名前を取り出す
				$destHeader .= 'From: ' . mb_encode_mimeheader($name) . '<' . $mail . ">\n";
				$errAddress = $mail;	// エラーメールの送信先
			} else {		// 取得失敗のとき
				$destHeader .= empty($fromAddress) ? '' : 'From: ' . $fromAddress . "\n";
			}
			// 返信先のメールアドレスを設定
			if (separateMailAddress($replytoAddress, $mail, $name)){		// メールアドレス、名前を取り出す
				$destHeader .= 'Reply-To: ' . mb_encode_mimeheader($name) . '<' . $mail . ">\n";
			} else {
				$destHeader .= empty($replytoAddress) ? '' : 'Reply-To: ' . $replytoAddress . "\n";
			}
		} else {
			$destHeader .= empty($fromAddress) ? '' : 'From: ' . $fromAddress . "\n";
			$destHeader .= empty($replytoAddress) ? '' : 'Reply-To: ' . $replytoAddress . "\n";
		}
		
		// 本文を置き換え
		while (list($key, $val) = each($params)){
			$destContent = preg_replace("/\[#" . $key . "#\]/", $val, $destContent);
		}
		$option = '-f' . $errAddress;		// エラーメールを返すアドレスを設定
		//if (extension_loaded('mbstring')){	// mbstring使用可能
		if (function_exists('mb_send_mail')){		// mbが使用可能なとき
			if (separateMailAddress($toAddress, $mail, $name)){		// メールアドレス、名前を取り出す
				$toAddress = mb_encode_mimeheader($name) . '<' . $mail . '>';
				$ret = mb_send_mail($toAddress, $destSubject, $destContent, $destHeader, $option);
			} else {
				$ret = mb_send_mail($toAddress, $destSubject, $destContent, $destHeader, $option);
			}
		} else {
			$ret = mail($toAddress, $destSubject, $destContent, $destHeader, $option);
		}
		
		// 送信成功したときは、ログに残す
		if ($ret){
			$this->db->addMailLog($type, $widgetId, $toAddress, $fromAddress, $destSubject, $destContent);
		}
		return $ret;
	}
}
?>
