<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_customerDb.php');

class admin_ec_mainCustomerWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $langId;		// 表示言語
	private $serialNo;			// シリアル番号
	private $serialArray = array();		// 表示されている項目シリアル番号
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_customerDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		global $gEnvManager;
		
		$task = $request->trimValueOf('task');
		if ($task == 'customer_detail'){		// 詳細画面
			return 'admin_customer_detail.tmpl.html';
		} else {			// 一覧画面
			return 'admin_customer.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'customer_detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		global $gEnvManager;
		
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		
		if ($act == 'delete'){		// 項目削除の場合
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
				$ret = $this->db->delCustomerBySerial($delItems);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		}
		// #### 取引先一覧を作成 ####
		$this->db->getAllCustomer(array($this, 'customerListLoop'));
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		global $gEnvManager;
		
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$userId = $gEnvManager->getCurrentUserId();
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		if (empty($this->serialNo)) $this->serialNo = 0;

		$name	= $request->trimValueOf('item_name');		// 取引先名称
		$index	= $request->trimValueOf('item_index');		// 表示順
		$isCustmer  = ($request->trimValueOf('item_is_custmer') == 'on') ? 1 : 0;			// 得意先かどうか
		$isSupplier  = ($request->trimValueOf('item_is_supplier') == 'on') ? 1 : 0;			// 仕入先かどうか
		$isDelivery  = ($request->trimValueOf('item_is_delivery') == 'on') ? 1 : 0;			// 出荷先かどうか
		$isPayment  = ($request->trimValueOf('item_is_payment') == 'on') ? 1 : 0;			// 支払先かどうか
		$isBilling  = ($request->trimValueOf('item_is_billing') == 'on') ? 1 : 0;			// 請求先かどうか
		
		$replaceNew = false;		// データを再取得するかどうか
		if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkNumeric($index, '表示順');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addCustomer(0, $name, $index, $isCustmer, $isSupplier, $isDelivery, $isPayment, $isBilling, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					// シリアル番号更新
					$this->serialNo = $newSerial;
					$replaceNew = true;			// データを再取得
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkNumeric($index, '表示順');		
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateCustomer($this->serialNo, $name, $index, $isCustmer, $isSupplier, $isDelivery, $isPayment, $isBilling, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					// 登録済みのカテゴリーを取得
					$this->serialNo = $newSerial;
					$replaceNew = true;			// データを再取得
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			$ret = $this->db->delCustomerBySerial(array($this->serialNo));
			if ($ret){		// データ削除成功のとき
				$this->setGuidanceMsg('データを削除しました');
			} else {
				$this->setAppErrorMsg('データ削除に失敗しました');
			}
		} else {	// 初期表示
			// 入力値初期化
			if (empty($this->serialNo)){		// シリアル番号
				$name = '';		// 名前
				$index = $this->db->getMaxIndex() + 1;	// 表示順
			} else {
				$replaceNew = true;			// データを再取得
			}
		}
		// データを再取得のとき
		if ($replaceNew){
			$ret = $this->db->getCustomerBySerial($this->serialNo, $row);
			if ($ret){
				// 取得値を設定
				$id = $row['cc_id'];		// ID
				$name = $row['cc_name'];		// 名前
				$index = $row['cc_sort_order'];	// 表示順
				$isCustmer  = $row['cc_is_custmer'];			// 得意先かどうか
				$isSupplier  = $row['cc_is_supplier'];			// 仕入先かどうか
				$isDelivery  = $row['cc_is_delivery'];			// 出荷先かどうか
				$isPayment  = $row['cc_is_payment'];			// 支払先かどうか
				$isBilling  = $row['cc_is_billing'];			// 請求先かどうか
				$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
				$updateDt = $this->convertToDispDateTime($row['cc_create_dt']);	// 更新日時
			}
		}
		// #### 更新、新規登録部をを作成 ####
		if (empty($this->serialNo)){		// シリアル番号のときは新規とする
			$this->tmpl->addVar("_widget", "id", '新規');
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->addVar("_widget", "id", $id);
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
		}
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "index", $index);		// 表示順
		
		$visibleStr = '';
		if ($visible){	// 項目の表示
			$visibleStr = 'checked';
		}
		$isChecked = '';
		if ($isCustmer) $isChecked = 'checked';			// 得意先かどうか
		$this->tmpl->addVar("_widget", "is_customer", $isChecked);
		$isChecked = '';
		if ($isSupplier) $isChecked = 'checked';			// 仕入先かどうか
		$this->tmpl->addVar("_widget", "is_supplier", $isChecked);
		$isChecked = '';
		if ($isDelivery) $isChecked = 'checked';			// 出荷先かどうか
		$this->tmpl->addVar("_widget", "is_delivery", $isChecked);
		$isChecked = '';
		if ($isPayment) $isChecked = 'checked';			// 支払先かどうか
		$this->tmpl->addVar("_widget", "is_payment", $isChecked);
		$isChecked = '';
		if ($isBilling) $isChecked = 'checked';			// 請求先かどうか
		$this->tmpl->addVar("_widget", "is_billing", $isChecked);
		
		if (!empty($updateUser)) $this->tmpl->addVar("_widget", "update_user", $updateUser);	// 更新者
		if (!empty($updateDt)) $this->tmpl->addVar("_widget", "update_dt", $updateDt);	// 更新日時
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function customerListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		$serial = $fetchedRow['cc_serial'];
		$id = $this->convertToDispString($fetchedRow['cc_id']);

		$row = array(
			'index' => $index,													// 行番号
			'serial' => $serial,	// シリアル番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['cc_name']),		// 名前
			'view_index' => $this->convertToDispString($fetchedRow['cc_sort_order']),		// 表示順
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['cc_create_dt'])	// 更新日時
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');

		// 表示中項目のシリアル番号を保存
		$this->serialArray[] = $serial;
		return true;
	}
}
?>
