<?php
/**
 * グローバル定義ファイル
 *
 * 機能：ユーザが編集不可のグローバル定義。共通クラスの取り込み用。
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    Release 1.3.x SVN: $Id$
 * @link       http://www.magic3.org
 */
if (defined("M3_SYSTEM_DEFINE_INCLUDED")) return;
define("M3_SYSTEM_DEFINE_INCLUDED", true);

// ######### PHPバージョンチェック #########
if (phpversion() < '5.1.0') die("PHP version error: ver=" . phpversion() . ". Magic3 can move above version 5.1.0.");

// ######### システム起動状況 #########
define('M3_SYSTEM', true);
define('M3_SYSTEM_DEMO', false);		// システム起動モード、デモモードフラグ
define('M3_SYSTEM_DEBUG', false);	// システム起動モード、デバッグモードフラグ

// ######### 別名定義 #########
define('M3_NL',	"\n");				// 改行
define('M3_TB',	"\t");				// タブ
define('M3_ENCODING',	'UTF-8');		// 内部エンコーディング

// ######### 出力の制御 #########
ini_set('display_errors', '1');		// コメントをはずすと画面にエラー出力する(以下はエラーレベルの設定)
error_reporting(E_ALL ^ E_NOTICE);		// E_NOTICE 以外の全てのエラーを表示する(初期設定値)
//error_reporting(E_ALL);
//error_reporting(E_ALL | E_STRICT);// 構文ミスエラーを表示
define('M3_SYSTEM_DEBUG_OUT', true);// デバッグ文出力を行うかどうか

// ########## システム関係 ##########
// システム基本情報
define('M3_SYSTEM_NAME',			'Magic3');		// システム名称
define('M3_SYSTEM_VERSION',			'1.3.5');		// システムのバージョン
define('M3_SYSTEM_RELEASE_DATE',	'2008/4/17');	// システムのリリース日付
define('M3_SYSTEM_ID',				'M3');			// コンポーネント識別用ID
define('M3_SYSTEM_DESCRIPTION',		'Magic3 is open source cms & web communication platform.');		// システムの説明

// ディレクトリ定義
define('M3_SYSTEM_INCLUDE_PATH',	dirname(__FILE__));						// global.phpファイルのあるディレクトリ(基準ディレクトリ)
define('M3_SYSTEM_ROOT_PATH',		dirname(M3_SYSTEM_INCLUDE_PATH));		// システムのルートディレクトリ
define('M3_SYSTEM_LIB_PATH',		M3_SYSTEM_INCLUDE_PATH . '/lib');		// ライブラリパス
define('M3_SYSTEM_CONF_PATH',		M3_SYSTEM_INCLUDE_PATH . '/conf');		// 設定ファイル用パス
define('M3_SYSTEM_CORE_PATH',		M3_SYSTEM_INCLUDE_PATH . '/core');		// システムディレクトリパス
define('M3_SYSTEM_COMMON_PATH',		M3_SYSTEM_INCLUDE_PATH . '/common');	// システム共通ディレクトリパス
// ディレクトリ名
define('M3_SYSTEM_ROOT_DIR_NAME',	basename(M3_SYSTEM_ROOT_PATH));			// ルートディレクトリ名
define('M3_SYSTEM_ADMIN_DIR_NAME',	'admin');								// システム管理ディレクトリ名
define('M3_DIR_NAME_SCRIPTS',		'scripts');								// スクリプト格納ディレクトリ名
define('M3_DIR_NAME_CSS',			'css');									// CSS格納ディレクトリ名
define('M3_DIR_NAME_ADMIN',			'admin');								// 管理用ディレクトリ名
define('M3_DIR_NAME_MOBILE',		'm');									// 携帯用ディレクトリ名
// Magic3専用タグ
define('M3_TAG_START',				'[#');									// Magic3専用タグの開始
define('M3_TAG_END',				'#]');									// Magic3専用タグの終了
define('M3_TAG_MACRO_ROOT_URL',		'M3_ROOT_URL');							// アプリケーションのルートURLを示すマクロ
define('M3_TAG_MACRO_IMG_URL',		'M3_IMG_URL');							// 画像URLを示すマクロ
define('M3_TAG_MACRO_LINK_URL',		'M3_LINK_URL');							// リンク先URLを示すマクロ
// 名前作成用
define('M3_WIDGET_ID_SEPARATOR',	',');									// ウィジェットIDと付加情報を連結

// ファイル拡張子
define('M3_TEMPLATE_FILE_EXTENSION', '.tmpl.html');		// テンプレートファイルの拡張子(suffix)

// システムに関係するHTMLタグ名
define('M3_SYSTEM_TAG_CHANGE_TEMPLATE',	'_sel_template');		// テンプレート選択用メニュー

// クッキー保存値
define('M3_COOKIE_CLIENT_ID',	'CID');				// クライアントID
define('M3_COOKIE_CART_ID',		'CARTID');			// EコマースカートID

// 作業用
define('M3_SYSTEM_WORK_DIR_PATH', 				'/tmp');			// 作業用ディレクトリ
define('M3_SYSTEM_WORK_UPLOAD_FILENAME_HEAD',	'm3_upload_');			// アップロードファイル一時退避用ファイル名ヘッダ
define('M3_SYSTEM_WORK_DOWNLOAD_FILENAME_HEAD',	'm3_download_');			// ダウンロードファイル一時退避用ファイル名ヘッダ

// ライブラリ等の追加状況
define('M3_USE_BUBBLE_TOOLTIP',	'm3_use_bubble_tooltip');			// バルーンヘルプ使用判断用

// ######### DB定義 ###########
define('M3_DB_PGSQL_PREFIX',	'pgsql_');				// DB区別用プレフィクス
define('M3_DB_MYSQL_PREFIX',	'mysql_');				// DB区別用プレフィクス
define('M3_DB_TYPE_PGSQL',		'pgsql');				// DB種別(PostgreSQL)
define('M3_DB_TYPE_MYSQL',		'mysql');				// DB種別(MySQL)
define('M3_TIMESTAMP_INIT_VALUE_MYSQL',		'0000-00-00 00:00:00');	// Timestamp型データの初期化値
define('M3_TIMESTAMP_INIT_VALUE_PGSQL',		'0001-01-01 00:00:00');	// Timestamp型データの初期化値
define('M3_DATE_INIT_VALUE_MYSQL',			'0000-00-00');			// Date型データの初期化値
define('M3_DATE_INIT_VALUE_PGSQL',			'0001-01-01');			// Date型データの初期化値

// DBフィールド定義
define('M3_TB_FIELD_SYSTEM_NAME',		'system_name');				// システム名称
define('M3_TB_FIELD_SYSTEM_VERSION',	'system_version');			// システムバージョン
// HTMLヘッダに出力する項目
define('M3_TB_FIELD_SITE_TITLE',		'head_title');				// サイトのタイトル
define('M3_TB_FIELD_SITE_DESCRIPTION',	'head_description');		// サイトの説明
define('M3_TB_FIELD_SITE_KEYWORDS',		'head_keywords');			// 検索エンジン用キーワード
define('M3_TB_FIELD_SITE_ROBOTS',		'head_robots');				// 検索ロボットへの指示
// サイト定義
define('M3_TB_FIELD_SITE_NAME',			'site_name');				// サイト名称
define('M3_TB_FIELD_SITE_OWNER',		'site_owner');				// サイト所有者
define('M3_TB_FIELD_SITE_COPYRIGHT', 	'site_copyright');			// サイトコピーライト
define('M3_TB_FIELD_SITE_EMAIL',		'site_email');				// サイトEメール

// ######### HTTPリクエストパラメータ ###########
// キー
define('M3_REQUEST_PARAM_PAGE_ID',      			'page');			// ページID
define('M3_REQUEST_PARAM_PAGE_SUB_ID',      		'sub');				// ページサブID
define('M3_REQUEST_PARAM_WIDGET_ID',				'widget');			// ウィジェットID
define('M3_REQUEST_PARAM_TEMPLATE_ID',				'template');		// テンプレートID
define('M3_REQUEST_PARAM_URL',						'url');				// リンク先等のURL
define('M3_REQUEST_PARAM_STAMP',					'stamp');			// 公開発行ID
//define('M3_REQUEST_PARAM_CONTAINER',				'cont');			// コンテナ
define('M3_REQUEST_PARAM_OPTION',					'opt');				// 通信オプション
define('M3_REQUEST_PARAM_OPERATION_COMMAND',		'cmd');				// 実行処理
define('M3_REQUEST_PARAM_OPERATION_TASK',			'task');			// ウィジェット間共通処理
define('M3_REQUEST_PARAM_OPERATION_ACT',			'act');				// クライアントからの実行処理
define('M3_REQUEST_PARAM_OPERATION_LANG',			'lang');			// 言語指定表示
define('M3_REQUEST_PARAM_OPERATION_TODO',      		'todo');			// 指定ウィジェットに実行させる処理
define('M3_REQUEST_PARAM_FROM',						'from');			// メッセージの送信元ウィジェットID
define('M3_REQUEST_PARAM_VIEW_STYLE',				'style');			// 表示スタイル
define('M3_REQUEST_PARAM_FORWARD',					'forward');			// 画面遷移用パラメータ
define('M3_REQUEST_PARAM_ADMIN_KEY',				'adminkey');		// 管理者一時キー
define('M3_REQUEST_PARAM_OPEN_BY',					'openby');			// ウィンドウの開き方
define('M3_REQUEST_PARAM_PAGE_DEF_SERIAL',			'_defserial');		// ページ定義のレコードシリアル番号(設定画面起動時)
define('M3_REQUEST_PARAM_PAGE_DEF_CONFIG_ID',		'_defconfig');		// ページ定義のウィジェット定義ID(設定画面起動時)

// 値
// 実行オペレーション
define('M3_REQUEST_CMD_INIT_DB',      				'initdb');				// DB初期作成
define('M3_REQUEST_CMD_SHOW_POSITION',      		'showposition');		// ウィジェット組み込み位置を表示
define('M3_REQUEST_CMD_SHOW_NO_POSITION',      		'shownoposition');		// ウィジェット組み込み位置なしで表示
define('M3_REQUEST_CMD_SHOW_POSITION_WITH_WIDGET',  'showpositionwithwidget');		// ウィジェット組み込み位置を表示(ウィジェット込み)
define('M3_REQUEST_CMD_SHOW_PHPINFO',      			'showphpinfo');			// phpinfo()を表示
define('M3_REQUEST_CMD_FIND_WIDGET',				'findwidget');			// ウィジェットを検索し、前面表示
define('M3_REQUEST_CMD_SHOW_WIDGET',      			'showwidget');			// ウィジェット単体表示
define('M3_REQUEST_CMD_DO_WIDGET',      			'dowidget');			// ウィジェット単体オペレーション
define('M3_REQUEST_CMD_CONFIG_WIDGET',      		'configwidget');		// ウィジェットの設定
define('M3_REQUEST_CMD_LOGIN',      				'login');				// ログイン
define('M3_REQUEST_CMD_LOGOUT',      				'logout');				// ログアウト
define('M3_REQUEST_CMD_CHANGE_TEMPLATE',			'changetemplate');		// テンプレートの変更
//define('M3_REQUEST_CMD_ACCESS_DENY',				'accessdeny');			// アクセス拒否

// ######### セッション保存パラメータ ###########
define('M3_SESSION_CURRENT_TEMPLATE',		'_current_template');			// 現在表示中のテンプレート
define('M3_SESSION_USER_INFO',      		'_user_info');					// 現在ログイン中のユーザ情報

// ######### システムの定義 ###########
define('M3_HTML_CHARSET',	'utf-8');				// キャラクターセット
define('M3_TIMEZONE',		'Asia/Tokyo');			// タイムゾーン

// ######### 基本関数の読み込み ###########
//require_once(dirname(__FILE__) . '/common/m3Basic.php');

// ######### サイト定義の読み込み ###########
require_once(dirname(__FILE__) . '/siteDef.php');

// ######### 時刻設定 ###########
//define('M3_MTIME', getmicrotime());					// 現在のマイクロ秒タイムスタンプ
define('M3_MTIME', microtime(true));					// 現在のマイクロ秒タイムスタンプ

// ######### PHPの設定 ###########
set_magic_quotes_runtime(0);
date_default_timezone_set(M3_TIMEZONE);	// デフォルトタイムゾーンの設定

// ######### グローバル変数の作成 ###########
$HELP = array();			// ヘルプ文字列
$TABLE_FIELDS = array();	// テーブルフィールド名

// ######### グローバルオブジェクト(各マネージャー)の作成 ###########
require_once(dirname(__FILE__) . '/manager/logManager.php');
require_once(dirname(__FILE__) . '/manager/instanceManager.php');
require_once(dirname(__FILE__) . '/manager/envManager.php');
require_once(dirname(__FILE__) . '/manager/systemManager.php');
require_once(dirname(__FILE__) . '/manager/launchManager.php');
require_once(dirname(__FILE__) . '/manager/accessManager.php');
require_once(dirname(__FILE__) . '/manager/configManager.php');
require_once(dirname(__FILE__) . '/manager/errorManager.php');
require_once(dirname(__FILE__) . '/manager/pageManager.php');
require_once(dirname(__FILE__) . '/manager/dbManager.php');
require_once(dirname(__FILE__) . '/manager/requestManager.php');
require_once(dirname(__FILE__) . '/manager/ajaxManager.php');
require_once(dirname(__FILE__) . '/manager/fileManager.php');
require_once(dirname(__FILE__) . '/manager/designManager.php');
require_once(dirname(__FILE__) . '/manager/mailManager.php');
require_once(dirname(__FILE__) . '/manager/analyzeManager.php');
require_once(dirname(__FILE__) . '/manager/messageManager.php');
require_once(dirname(__FILE__) . '/manager/initialManager.php');
require_once(dirname(__FILE__) . '/manager/cmdParamManager.php');
require_once(dirname(__FILE__) . '/manager/textConvManager.php');
require_once(dirname(__FILE__) . '/manager/helpManager.php');

// マネージャーの作成、初期化
$gLogManager 		= new LogManager();		// これよりロギング可能
$gInstanceManager 	= new InstanceManager();
$gEnvManager 		= new EnvManager();		// システムの動作環境管理
$gSystemManager 	= new SystemManager();
$gLaunchManager 	= new LaunchManager();
$gAccessManager 	= new AccessManager();
$gConfigManager 	= new ConfigManager();
$gErrorManager 		= new ErrorManager();
$gPageManager 		= new PageManager();
$gDbManager 		= new DbManager();
$gRequestManager 	= new RequestManager();
$gAjaxManager 		= new AjaxManager();
$gFileManager 		= new FileManager();
$gDesignManager 	= new DesignManager();
$gMailManager	 	= new MailManager();
$gAnalyzeManager	= new AnalyzeManager();
$gMessageManager	= new MessageManager();
$gInitialManager	= new InitialManager();
$gCmdParamManager	= new CmdParamManager();
$gTextConvManager	= new TextConvManager();
$gHelpManager		= new HelpManager();

// 追加クラスの読み込み
$gInstanceManager->loadAddonClass();

// 共通グローバル関数
require_once(dirname(__FILE__) . '/common/m3Func.php');

// Joomla定義読み込み
require_once($gEnvManager->getJoomlaRootPath() . '/mosDef.php');

// ######### ライブラリ用設定 ###########
define('CALENDAR_ROOT', $gEnvManager->getLibPath() . '/Calendar-0.5.3/');		// カレンダーライブラリ
?>
