<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_groupDb.php');

class admin_bbs_mainGroupWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $serialNo;			// シリアル番号
	private $groupId;		// ユーザグループID
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new bbs_groupDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_group.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userInfo		= $gEnvManager->getCurrentUserInfo();
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		if (empty($this->serialNo)) $this->serialNo = 0;

		$name	= $request->trimValueOf('item_name');		// グループ名称
		$index	= $request->trimValueOf('item_index');		// 表示順
		$this->groupId = $request->trimValueOf('groupid');	// グループID
		if (empty($this->groupId)) $this->groupId = 0;

		$this->langId = $request->trimValueOf('item_lang');				// 現在メニューで選択中の言語
		if (empty($this->langId)) $this->langId = $defaultLang;			// 言語が選択されていないときは、デフォルト言語を設定
		
		$dataEditable = true;		// 編集可能データかどうか
		if ($act == 'select'){		// 項目選択の場合
			if ($this->serialNo == 0){		// シリアル番号が0のときは、新規追加モードにする
				// 入力値初期化
				$this->serialNo = 0;		// シリアル番号
				$this->groupId = 0;		// ID
				$this->langId = $defaultLang;
				$name = '';		// 名前
				$index = '';	// 表示順
			} else {
				// 登録済みグループを取得
				$ret = $this->db->getGroupBySerial($this->serialNo, $row);
				if ($ret){
					// 取得値を設定
					$this->groupId = $row['sg_id'];		// ID
					$this->langId = $row['sg_language_id'];		// 言語ID
					$name = $row['sg_name'];		// 名前
					$index = $row['sg_sort_order'];	// 表示順
					$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
					$updateDt = $this->convertToDispDateTime($row['sg_create_dt']);	// 更新日時
					$dataEditable = $row['sg_editable'];		// 編集可能データかどうか
				}
			}
		} else if ($act == 'selectlang'){		// 言語選択の場合
			// 登録済みグループを取得
			$ret = $this->db->getCategoryByGroupId($this->groupId, $this->langId, $row);
			if ($ret){
				// 取得値を設定
				$this->serialNo = $row['sg_serial'];		// シリアル番号
				$this->groupId = $row['sg_id'];		// ID
				$this->langId = $row['sg_language_id'];		// 言語ID
				$name = $row['sg_name'];		// 名前
				$index = $row['sg_sort_order'];	// 表示順
				$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
				$updateDt = $this->convertToDispDateTime($row['sg_create_dt']);	// 更新日時
				$dataEditable = $row['sg_editable'];		// 編集可能データかどうか
			} else {	// 指定した言語のデータがないとき
				// デフォルト値を設定
				$this->serialNo = 0;
				$name = '';		// 名前
//				$index = '';	// 表示順
			}
		} else if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkNumeric($index, '表示順');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				if ($this->serialNo == 0 && $this->groupId == 0){		// シリアル番号が0、カテゴリIDが0のときは、新規追加モードにする
					$ret = $this->db->addGroup(0, $this->langId, $name, $index, $userInfo->userId, $newSerial);
				} else {
					$ret = $this->db->addGroup($this->groupId, $this->langId, $name, $index, $userInfo->userId, $newSerial);
				}
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					// シリアル番号更新
					$this->serialNo = $newSerial;
					
					// データ再取得
					$ret = $this->db->getGroupBySerial($this->serialNo, $row);
					if ($ret){
						// 取得値を設定
						$this->groupId = $row['sg_id'];		// ID
						$this->langId = $row['sg_language_id'];		// 言語ID
						$name = $row['sg_name'];		// 名前
						$index = $row['sg_sort_order'];	// 表示順
						$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
						$updateDt = $this->convertToDispDateTime($row['sg_create_dt']);	// 更新日時
					}
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkNumeric($index, '表示順');			
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateGroup($this->serialNo, $name, $index, $userInfo->userId, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					// 登録済みのグループを取得
					$this->serialNo = $newSerial;
					$ret = $this->db->getGroupBySerial($this->serialNo, $row);
					if ($ret){
						// 取得値を設定
						$this->groupId = $row['sg_id'];		// ID
						$this->langId = $row['sg_language_id'];		// 言語ID
						$name = $row['sg_name'];		// 名前
						$index = $row['sg_sort_order'];	// 表示順
						$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
						$updateDt = $this->convertToDispDateTime($row['sg_create_dt']);	// 更新日時
					}
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->db->delGroup($this->serialNo, $userInfo->userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else if ($act == 'deleteid'){		// ID項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->db->delGroupById($this->serialNo, $userInfo->userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else {	// 初期表示
			// 入力値初期化
			$this->serialNo = 0;		// シリアル番号
			$this->groupId = 0;		// ID
			$this->langId = $defaultLang;
			$name = '';		// 名前
			$index = '';	// 表示順
		}
		
		// #### ユーザグループリストを作成 ####
		$this->db->getAllGroup(array($this, 'groupListLoop'), $defaultLang);

		// #### 更新、新規登録部をを作成 ####
		// 選択中のグループIDを設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		if ($this->serialNo == 0 && $this->groupId == 0){		// シリアル番号、カテゴリIDが0のときは新規とする
			$this->tmpl->addVar("_widget", "id", '新規');
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// 新規追加をチェック状態にする
			
			// デフォルト言語を最初に登録
			$this->tmpl->addVar("default_lang", "default_lang", $defaultLangName);
			$this->tmpl->setAttribute('default_lang', 'visibility', 'visible');
		} else {
			$this->tmpl->addVar("_widget", "id", $this->groupId);
			
			// 言語選択メニューを作成
			$this->db->getAllLang(array($this, 'langLoop'));
			$this->tmpl->setAttribute('select_lang', 'visibility', 'visible');
		}
		$this->tmpl->addVar("_widget", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "index", $index);		// 表示順
		
		if (!empty($updateUser)) $this->tmpl->addVar("_widget", "update_user", $updateUser);	// 更新者
		if (!empty($updateDt)) $this->tmpl->addVar("_widget", "update_dt", $updateDt);	// 更新日時

		// ボタンの設定
		if ($this->serialNo == 0){		// 新規追加項目を選択しているとき
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			if ($dataEditable){		// 編集可能データかどうか
				// データ更新、削除ボタン表示
				if ($this->langId == $defaultLang){		// デフォルト言語のときは「ID削除」ボタン
					$this->tmpl->setAttribute('delete_id_button', 'visibility', 'visible');// ID削除ボタン
				} else {
					$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// 削除ボタン
				}
				$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
			}
		}
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "group_id", $this->groupId);
		
		// パスの設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function groupListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['sg_id']);
		$selected = '';
		if ($id == $this->groupId){
			$selected = 'checked';
		}
		
		// 対応言語を取得
		$lang = '';
		$ret = $this->db->getLangByGroupId($fetchedRow['sg_id'], $rows);
		if ($ret){
			$count = count($rows);
			for ($i = 0; $i < $count; $i++){
				if ($gEnvManager->getCurrentLanguage() == 'ja'){	// 日本語の場合
					$lang .= $rows[$i]['ln_name'];
					if ($i != $count -1) $lang .= ',';
				} else {
					$lang .= $rows[$i]['ln_name_en'];
					if ($i != $count -1) $lang .= ',';
				}
			}
		}		
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['sg_serial']),	// シリアル番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['sg_name']),		// 名前
			'view_index' => $this->convertToDispString($fetchedRow['sg_sort_order']),		// 表示順
			'lang' => $lang,													// 対応言語
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['sg_create_dt']),	// 更新日時
			'default' => $default,											// デフォルト項目
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->dispContIdArray[] = $fetchedRow['sg_id'];
		return true;
	}
	/**
	 * 取得した言語をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function langLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['ln_id'] == $this->langId){
			$selected = 'selected';
		}
		if ($gEnvManager->getCurrentLanguage() == 'ja'){		// 日本語表示の場合
			$name = $this->convertToDispString($fetchedRow['ln_name']);
		} else {
			$name = $this->convertToDispString($fetchedRow['ln_name_en']);
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['ln_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('lang_list', $row);
		$this->tmpl->parseTemplate('lang_list', 'a');
		return true;
	}
}
?>
