<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/blog_calendar_boxDb.php');
require_once($gEnvManager->getLibPath()			. '/Calendar-0.5.3/Month/Weekdays.php');

class blog_calendar_boxWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $entryDays = array();		// 投稿のあった日にち
	const TARGET_WIDGET = 'blog_main';		// 呼び出しウィジェットID
	const THIS_WIDGET_ID = 'blog_calendar_box';		// ウィジェットID
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new blog_calendar_boxDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		global $gDesignManager;

		$year = $request->trimValueOf('year');		// 年指定
		if (!(is_numeric($year) && 1 <= $year)){			// エラー値のとき
			$year = date('Y');
		}
		$month = $request->trimValueOf('month');	// 月指定
		if (!(is_numeric($month) && 1 <= $month && $month <= 12)){			// エラー値のとき
			$month = date('n');
		}
		$day = $request->trimValueOf('day');		// 日指定
		
		// メニューテーブルのパラメータ
		$this->tmpl->addVar("_widget", "default_menu_param", $gDesignManager->getDefaultWidgetTableParam());
		
		// 画像URL
		$this->tmpl->addVar("_widget", "IMG_URL", $gEnvManager->getCurrentWidgetRootUrl() . '/images');
		
		// カレンダーを作成
		$calendar = new Calendar_Month_Weekdays($year, $month, 0);		// 日曜日を先頭にする
		$calendar->build();
		$prevMonth = $calendar->prevMonth();
		$nextMonth = $calendar->nextMonth();
		if ($prevMonth == 12){
			$prevYear = $year -1;
		} else {
			$prevYear = $year;
		}
		if ($nextMonth == 1){
			$nextYear = $year +1;
		} else {
			$nextYear = $year;
		}
		// データの存在する日を取得
		$startDt = $this->convertToProperDate($year . '/' . $month . '/1');
		$endDt = $this->convertToProperDate($nextYear . '/' . $nextMonth . '/1');
		$this->db->getEntryItems($startDt, $endDt, $gEnvManager->getCurrentLanguage(), array($this, 'itemLoop'));
		
		$prevUrl = $gPageManager->createWidgetCmdUrl('', self::TARGET_WIDGET, self::THIS_WIDGET_ID, 'act=view&year=' . $prevYear . '&month=' . $prevMonth);
		$nextUrl = $gPageManager->createWidgetCmdUrl('', self::TARGET_WIDGET, self::THIS_WIDGET_ID, 'act=view&year=' . $nextYear . '&month=' . $nextMonth);
		$calendarData = '';
		$calendarData .= '<table class="blog_calendar">' . M3_NL;
//		$calendarData .= '<caption>' . M3_NL;
		$calendarData .= '<div align="center">' . M3_NL;
		$calendarData .= '<a href="' . $prevUrl . '">' . $prevMonth. '</a>' . M3_NL;
		$calendarData .= ' | ' . $year . '/' . $month . ' | ' . M3_NL;
		$calendarData .= '<a href="' . $nextUrl . '">' . $nextMonth . '</a>' . M3_NL;
//		$calendarData .= '</caption>' . M3_NL;
		$calendarData .= '</div>' . M3_NL;
		$calendarData .= '<tr>' . M3_NL;
		$calendarData .= '<th class="sun">日</th>' . M3_NL;
		$calendarData .= '<th class="*">月</th>' . M3_NL;
		$calendarData .= '<th>火</th>' . M3_NL;
		$calendarData .= '<th>水</th>' . M3_NL;
		$calendarData .= '<th>木</th>' . M3_NL;
		$calendarData .= '<th>金</th>' . M3_NL;
		$calendarData .= '<th class="sat">土</th>' . M3_NL;
		$calendarData .= '</tr>' . M3_NL;
		while ($Day = $calendar->fetch()) {
		    if ($Day->isFirst()) {
		        $calendarData .= "<tr>\n";
		    }

		    if ($Day->isEmpty()) {
		        $calendarData .= "<td>&nbsp;</td>\n";
		    } else {
				if (in_array($Day->thisDay(), $this->entryDays)){			// 投稿記事あり
					$dayUrl = $gPageManager->createWidgetCmdUrl('', self::TARGET_WIDGET, self::THIS_WIDGET_ID, 'act=view&year=' . $year . '&month=' . $month . '&day=' . $Day->thisDay());
					$dayLink = '<a href="' . $dayUrl . '">' . $Day->thisDay(). '</a>';
					$calendarData .= '<td>'. $dayLink ."</td>\n";
				} else {
		        	$calendarData .= '<td>'.$Day->thisDay()."</td>\n";
				}
		    }

		    if ($Day->isLast()) {
		        $calendarData .= "</tr>\n";
		    }
		}
		$calendarData .= "</table></div>\n";
		$this->tmpl->addVar("_widget", "calendar", $calendarData);
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 日を取得
		$this->timestampToYearMonthDay($fetchedRow['be_regist_dt'], $year, $month, $day);
		
		if (!in_array($day, $this->entryDays)) $this->entryDays[] = $day;
		return true;
	}
}
?>
