<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_imageWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	private $configId;		// 定義ID
	private $serial;		// 定義IDのレコードのシリアル番号
	private $selConfigId;	// 編集中の定義ID
	private $paramObj;		// パラメータ保存用オブジェクト
	private $configMode;	// 定義IDが設定可能なモード
	const IMAGE_DIR = 'default_image';				// 画像ディレクトリ名
	const IMAGE_WIDTH = 40;		// 一覧上の画像幅
	const IMAGE_HEIGHT = 40;		// 一覧上の画像高さ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;

		// ユーザ情報、表示言語
		$userInfo		= $gEnvManager->getCurrentUserInfo();
		$this->langId	= $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得

		// デフォルト値設定
		$this->configId = 0;				// デフォルト定義ID
		$this->serial = 0;
		$this->selConfigId = -1;			// 現在の設定中の定義ID
		
		$name		= '-- 未設定 --';			// 定義名
		$imageUrl 	= '';							// 画像へのパス
		$linkUrl	= '';			// リンク先
		$align		= '';			// 表示位置
		$bgcolor 	= '';		// 画像バックグランドカラー
		$width		= 0;		// 画像の幅
		$height		= 0;		// 画像の高さ
		$margin		= 0;		// 画像マージン
		$widthType	= 0;		// 画像の幅単位
		$heightType	= 0;		// 画像の高さ単位
		$posx		= 0;		// x座標
		$posy		= 0;		// y座標
		$posxType	= 0;		// x座標単位
		$posyType	= 0;		// y座標単位
		$posType	= 'relative';		// 座標指定方法(相対座標)
		$imageType	= '';		// 画像のタイプ(0=メニューから選択、1=直接指定)
		$usePos		= 0;			// 座標指定を可能とするかどうか
		$useLink	= 0;			// 画像にリンクを付けるかどうか
			
		// 呼び出し元からの設定値
		$act = $request->trimValueOf('act');
		
		// 実行モードの取得
		$value = $request->trimValueOf('configmode');
		if ($value == ''){
			if ($request->trimValueOf('configid') != '' && $request->trimValueOf('serial') != ''){		// 定義ID可変モードのとき
				$this->configMode = 1;		// 可変
			} else {
				$this->configMode = 0;		// デフォルト固定
			}
		} else {
			$this->configMode = $value;
		}
		
		$value = $request->trimValueOf('configid');
		if ($value != '') $this->configId = $value;		// 値がないときは新規追加状態にする
		$this->configId = intval($this->configId);
		if ($this->configId < 0) $this->configId = 0;
		
		$value = $request->trimValueOf('serial');		// ページ定義のレコードシリアル番号
		if ($value != '') $this->serial = $value;
		$this->serial = intval($this->serial);
		
		$value = $request->trimValueOf('selconfig');// 選択中の定義ID
		if ($value != '') $this->selConfigId = $value;
		
		// 保存値を取得
		$this->paramObj = $this->getWidgetParamObj();
		if (empty($this->paramObj)){		// 保存値がないとき
			// 初期オブジェクトを作成
			$this->paramObj = array();
			$this->paramObj[] = new stdClass;
			$this->paramObj[0]->name	= $name;// 定義名
			$this->paramObj[0]->imageUrl 	= $imageUrl;							// 画像へのパス
			$this->paramObj[0]->linkUrl	= $linkUrl;			// リンク先
			$this->paramObj[0]->align	= $align;			// 表示位置
			$this->paramObj[0]->bgcolor 	= $bgcolor;		// 画像バックグランドカラー
			$this->paramObj[0]->width		= $width;		// 画像の幅
			$this->paramObj[0]->height		= $height;		// 画像の高さ
			$this->paramObj[0]->margin		= $margin;		// 画像マージン
			$this->paramObj[0]->widthType	= $widthType;		// 画像の幅単位
			$this->paramObj[0]->heightType	= $heightType;		// 画像の高さ単位
			$this->paramObj[0]->posx		= $posx;		// x座標
			$this->paramObj[0]->posy		= $posy;		// y座標
			$this->paramObj[0]->posxType	= $posxType;		// x座標単位
			$this->paramObj[0]->posyType	= $posyType;		// y座標単位
			$this->paramObj[0]->posType	= $posType;		// 座標指定方法(相対座標)
			$this->paramObj[0]->imageType	= $imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
			$this->paramObj[0]->usePos		= $usePos;			// 座標指定を可能とするかどうか
			$this->paramObj[0]->useLink	= $useLink;			// 画像にリンクを付けるかどうか
		}
		// 格納領域が小さいときは拡大
		for ($i = 0; $i < $this->configId - count($this->paramObj) + 1; $i++){
			$newObj = new stdClass;
			$newObj->name	= $name;// 定義名
			$newObj->imageUrl 	= $imageUrl;							// 画像へのパス
			$newObj->linkUrl	= $linkUrl;			// リンク先
			$newObj->align		= $align;			// 表示位置
			$newObj->bgcolor 	= $bgcolor;		// 画像バックグランドカラー
			$newObj->width		= $width;		// 画像の幅
			$newObj->height		= $height;		// 画像の高さ
			$newObj->margin		= $margin;		// 画像マージン
			$newObj->widthType	= $widthType;		// 画像の幅単位
			$newObj->heightType	= $heightType;		// 画像の高さ単位
			$newObj->posx		= $posx;		// x座標
			$newObj->posy		= $posy;		// y座標
			$newObj->posxType	= $posxType;		// x座標単位
			$newObj->posyType	= $posyType;		// y座標単位
			$newObj->posType	= $posType;		// 座標指定方法(相対座標)
			$newObj->imageType	= $imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
			$newObj->usePos		= $usePos;			// 座標指定を可能とするかどうか
			$newObj->useLink	= $useLink;			// 画像にリンクを付けるかどうか
			$this->paramObj[] = $newObj;
		}

		if ($act == 'add'){		// 新規追加の場合
			// 入力値を取得
			$name	= $request->trimValueOf('item_name');			// 定義名
			$imageUrl 	= $request->trimValueOf('item_image_url');							// 画像へのパス
			$linkUrl	= $request->trimValueOf('item_link_url');			// リンク先
			$align		= $request->trimValueOf('item_align');			// 表示位置
			$bgcolor = $request->trimValueOf('item_bgcolor');		// 画像バックグランドカラー
			$width	= $request->trimValueOf('item_width');		// 画像の幅
			$height	= $request->trimValueOf('item_height');		// 画像の高さ
			$margin = $request->trimValueOf('item_margin');		// 画像マージン
			$widthType	= $request->trimValueOf('item_widthtype');		// 画像の幅単位
			$heightType	= $request->trimValueOf('item_heighttype');		// 画像の高さ単位
			$posx	= $request->trimValueOf('item_posx');		// x座標
			$posy	= $request->trimValueOf('item_posy');		// y座標
			$posxType	= $request->trimValueOf('item_posxtype');		// x座標単位
			$posyType	= $request->trimValueOf('item_posytype');		// y座標単位
			$posType	= $request->trimValueOf('item_postype');		// 座標指定方法
			$imageType	= $request->trimValueOf('item_sel_image');		// 画像のタイプ
			$usePos	= ($request->trimValueOf('item_use_pos') == 'on') ? 1 : 0;			// 座標指定を可能とするかどうか
			$useLink	= ($request->trimValueOf('item_use_link') == 'on') ? 1 : 0;			// 画像にリンクを付けるかどうか
				
			// 画像の種類を取得
			$imageUrl = '';
			if ($imageType == 'menu'){		// メニューから画像を選択の場合
				$filename = $request->trimValueOf('item_image');		// 画像ファイル名
				$imageUrl = $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR . '/' . $filename;
			} else if ($imageType == 'url'){
				$imageUrl = $request->trimValueOf('item_image_url');
				if (!empty($imageUrl)){
					if (strncmp($imageUrl, '/', 1) == 0){		// 相対パス表記のとき
						$imageUrl = $gEnvManager->getRootUrl() . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl);
					}
				}
			}
			// 入力値のエラーチェック
			$this->checkInput($imageType, '画像の種別');
			$this->checkNumeric($width, '画像の幅', true);
			$this->checkNumeric($height, '画像の高さ', true);
//			$this->checkNumeric($posx, '画像のx座標', true);
//			$this->checkNumeric($posy, '画像のy座標', true);
			$this->checkNumeric($margin, '画像マージン', true);
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// オブジェクトを追加
				$newObj = new stdClass;
				$newObj->name	= $name;// 定義名
				$newObj->imageUrl 	= $imageUrl;							// 画像へのパス
				$newObj->linkUrl	= $linkUrl;			// リンク先
				$newObj->align		= $align;			// 表示位置
				$newObj->bgcolor 	= $bgcolor;		// 画像バックグランドカラー
				$newObj->width		= $width;		// 画像の幅
				$newObj->height		= $height;		// 画像の高さ
				$newObj->margin		= $margin;		// 画像マージン
				$newObj->widthType	= $widthType;		// 画像の幅単位
				$newObj->heightType	= $heightType;		// 画像の高さ単位
				$newObj->posx		= $posx;		// x座標
				$newObj->posy		= $posy;		// y座標
				$newObj->posxType	= $posxType;		// x座標単位
				$newObj->posyType	= $posyType;		// y座標単位
				$newObj->posType	= $posType;		// 座標指定方法(相対座標)
				$newObj->imageType	= $imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
				$newObj->usePos		= $usePos;			// 座標指定を可能とするかどうか
				$newObj->useLink	= $useLink;			// 画像にリンクを付けるかどうか
				$this->paramObj[] = $newObj;
				
				// オブジェクトを保存
				$ret = $this->updateWidgetParamObj($this->paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, '新規項目を追加しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, '新規項目の追加に失敗しました');
				}
			}
		} else if ($act == 'delete'){	// 項目削除のとき
			// 項目を削除
			array_splice($this->paramObj, $this->selConfigId, 1);
			
			// オブジェクトを保存
			$ret = $this->updateWidgetParamObj($this->paramObj);
			if ($ret){
				$this->setMsg(self::MSG_GUIDANCE, '定義項目を削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, '定義項目削除に失敗しました');
			}
		} else if ($act == 'update'){		// 設定更新のとき
			if ($this->selConfigId > -1){
				// 入力値を取得
				$name	= $request->trimValueOf('item_name');			// 定義名
				$imageUrl 	= $request->trimValueOf('item_image_url');							// 画像へのパス
				$linkUrl	= $request->trimValueOf('item_link_url');			// リンク先
				$align		= $request->trimValueOf('item_align');			// 表示位置
				$bgcolor = $request->trimValueOf('item_bgcolor');		// 画像バックグランドカラー
				$width	= $request->trimValueOf('item_width');		// 画像の幅
				$height	= $request->trimValueOf('item_height');		// 画像の高さ
				$margin	= $request->trimValueOf('item_margin');		// 画像マージン
				$widthType	= $request->trimValueOf('item_widthtype');		// 画像の幅単位
				$heightType	= $request->trimValueOf('item_heighttype');		// 画像の高さ単位
				$posx	= $request->trimValueOf('item_posx');		// x座標
				$posy	= $request->trimValueOf('item_posy');		// y座標
				$posxType	= $request->trimValueOf('item_posxtype');		// x座標単位
				$posyType	= $request->trimValueOf('item_posytype');		// y座標単位
				$posType	= $request->trimValueOf('item_postype');		// 座標指定方法
				$imageType	= $request->trimValueOf('item_sel_image');		// 画像のタイプ
				$usePos	= ($request->trimValueOf('item_use_pos') == 'on') ? 1 : 0;			// 座標指定を可能とするかどうか
				$useLink	= ($request->trimValueOf('item_use_link') == 'on') ? 1 : 0;			// 画像にリンクを付けるかどうか
			
				// 画像の種類を取得
				$imageUrl = '';
				if ($imageType == 'menu'){		// メニューから画像を選択の場合
					$filename = $request->trimValueOf('item_image');		// 画像ファイル名
					$imageUrl = $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR . '/' . $filename;
				} else if ($imageType == 'url'){
					$imageUrl = $request->trimValueOf('item_image_url');
					if (!empty($imageUrl)){
						if (strncmp($imageUrl, '/', 1) == 0){		// 相対パス表記のとき
							$imageUrl = $gEnvManager->getRootUrl() . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl);
						}
					}
				}
				// 入力値のエラーチェック
				$this->checkInput($imageType, '画像の種別');
				$this->checkNumeric($width, '画像の幅', true);
				$this->checkNumeric($height, '画像の高さ', true);
//				$this->checkNumeric($posx, '画像のx座標', true);
//				$this->checkNumeric($posy, '画像のy座標', true);
				$this->checkNumeric($margin, '画像マージン', true);
				if ($this->getMsgCount() == 0){			// エラーのないとき
					$paramObj = $this->paramObj[$this->selConfigId];
					$paramObj->name	= $name;// 定義名
					$paramObj->imageUrl = $imageUrl;							// 画像へのパス
					$paramObj->linkUrl = $linkUrl;			// リンク先
					$paramObj->align	= $align;			// 表示位置
					$paramObj->bgcolor = $bgcolor;		// 画像バックグランドカラー
					$paramObj->width = $width;		// 画像の幅
					$paramObj->height = $height;		// 画像の高さ
					$paramObj->margin	= $margin;		// 画像マージン
					$paramObj->widthType = $widthType;		// 画像の幅単位
					$paramObj->heightType = $heightType;		// 画像の高さ単位
					$paramObj->posx = $posx;		// x座標
					$paramObj->posy = $posy;		// y座標
					$paramObj->posxType = $posxType;		// x座標単位
					$paramObj->posyType = $posyType;		// y座標単位
					$paramObj->posType = $posType;		// 座標指定方法(相対座標)
					$paramObj->imageType = $imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
					$paramObj->usePos = $usePos;			// 座標指定を可能とするかどうか
					$paramObj->useLink = $useLink;			// 画像にリンクを付けるかどうか
					$ret = $this->updateWidgetParamObj($this->paramObj);
					if ($ret){
						$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					} else {
						$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
					}				
				}
			} else {
				$this->setMsg(self::MSG_APP_ERR, '更新する項目が選択されていません');
			}
		} else if ($act == 'select'){		// 定義項目を選択
			if ($this->selConfigId > -1){
				$paramObj = $this->paramObj[$this->selConfigId];
				$name = $paramObj->name;// 定義名
				$imageUrl = $paramObj->imageUrl;							// 画像へのパス
				$linkUrl = $paramObj->linkUrl;			// リンク先
				$align = $paramObj->align;			// 表示位置
				$bgcolor = $paramObj->bgcolor;		// 画像バックグランドカラー
				$width = $paramObj->width;		// 画像の幅
				$height = $paramObj->height;		// 画像の高さ
				$margin	= $paramObj->margin;		// 画像マージン
				$widthType = $paramObj->widthType;		// 画像の幅単位
				$heightType = $paramObj->heightType;		// 画像の高さ単位
				$posx = $paramObj->posx;		// x座標
				$posy = $paramObj->posy;		// y座標
				$posxType = $paramObj->posxType;		// x座標単位
				$posyType = $paramObj->posyType;		// y座標単位
				$posType = $paramObj->posType;		// 座標指定方法(相対座標)
				$imageType = $paramObj->imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
				$usePos = $paramObj->usePos;			// 座標指定を可能とするかどうか
				$useLink = $paramObj->useLink;			// 画像にリンクを付けるかどうか
			}
		} else if ($act == 'updateconfig'){	// 定義IDを変更
			$newConfigId = $request->trimValueOf('updateconfigid');// 新規定義ID
			if ($newConfigId != ''){
				$paramObj = $this->paramObj[$newConfigId];
				$name = $paramObj->name;// 定義名
			
				// 定義IDを更新
				$ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $this->serial, $newConfigId, $name);
				if ($ret){
					$message = '設定を「' . $name . '」に変更しました';
					$this->setMsg(self::MSG_GUIDANCE, $message);
					
					$this->configId = $newConfigId;
				} else {
					$message = '設定「' . $name . '」の変更に失敗しました';
					$this->setMsg(self::MSG_APP_ERR, $message);
				}
				$gPageManager->updateParentWindow();// 親ウィンドウを更新
			}
		} else {		// 初期表示の場合
			// 入力値初期化
		}
		// 定義名リストを作成
		$this->createDefList();
		
		// 画像選択メニューを作成
		$selectFile = '';
		if ($imageType == 'menu') $selectFile = basename($imageUrl);
		$imgPath = $gEnvManager->getCurrentWidgetRootPath() . '/' . self::IMAGE_DIR;
		$this->createImageSelectMenu($imgPath, $selectFile, 'image_file_list');
		
		// 画像定義一覧を作成
		$this->createImageDefList();
		
		// カレントの定義ID設定部
		if ($this->configMode == 0){		// デフォルト固定
			$this->tmpl->addVar("_widget", "sel_config_title", 'デフォルト値');			// 定義ID変更部ラベル
			$this->tmpl->addVar("_widget", "sel_config_disabled", 'disabled');
			$this->tmpl->addVar("_widget", "update_config_disabled", 'disabled');
		} else {
			$this->tmpl->addVar("_widget", "sel_config_title", '現在の選択値');			// 定義ID変更部ラベル
		}
		if ($this->selConfigId == -1){		// IDが-1のときは新規とする
			$this->tmpl->addVar("_widget", "id_label", '新規');			// 選択項目のIDラベル
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// ユーザIDが0のときは新規追加をチェック状態にする
			
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 新規登録ボタン表示
		} else {
			$this->tmpl->addVar("_widget", "id_label", $this->id);			// 選択項目のIDラベル
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 更新ボタン表示
		}
		$this->tmpl->addVar("_widget", "id", $this->id);			// ID
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "config_mode", $this->configMode);	// 起動モード
		$this->tmpl->addVar("_widget", "config_id", $this->configId);	// 定義ID
		$this->tmpl->addVar("_widget", "def_serial", $this->serial);	// ページ定義のレコードシリアル番号
		$this->tmpl->addVar("_widget", "sel_config", $this->selConfigId);			// 現在の設定中の定義ID
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "name",	$name);
		$this->tmpl->addVar("_widget", "link_url",	$linkUrl);// リンク先
		$this->tmpl->addVar("_widget", "bgcolor", $bgcolor);
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "margin",	$margin);
		$this->tmpl->addVar("_widget", "posx",	$posx);// x座標
		$this->tmpl->addVar("_widget", "posy",	$posy);// y座標
		
		// 高さ、幅の単位
		if (empty($widthType)){		// ヘッダの幅単位
			$this->tmpl->addVar("_widget", "width0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "width1_selected",	'selected');
		}
		if (empty($heightType)){		// ヘッダの高さ単位
			$this->tmpl->addVar("_widget", "height0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "height1_selected",	'selected');
		}
		if (empty($posxType)){		// x座標単位
			$this->tmpl->addVar("_widget", "posx0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "posx1_selected",	'selected');
		}
		if (empty($posyType)){		// y座標単位
			$this->tmpl->addVar("_widget", "posy0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "posy1_selected",	'selected');
		}
		if ($posType == 'relative'){		// 座標の指定方法
			$this->tmpl->addVar("_widget", "postype0_selected",	'selected');
		} else if ($posType == 'absolute'){
			$this->tmpl->addVar("_widget", "postype1_selected",	'selected');
		}
		if ($align == ''){		// 表示位置
			$this->tmpl->addVar("_widget", "align0_selected",	'selected');
		} else if ($align == 'left'){
			$this->tmpl->addVar("_widget", "align1_selected",	'selected');
		} else if ($align == 'center'){
			$this->tmpl->addVar("_widget", "align2_selected",	'selected');
		} else if ($align == 'right'){
			$this->tmpl->addVar("_widget", "align3_selected",	'selected');
		}
												
		// ヘッダ画像の種類の選択状況
		if ($imageType == 'menu'){		// メニューから選択
			$this->tmpl->addVar("_widget", "menu_img_checked",	'checked');
			$filename = basename($imageUrl);
		} else if ($imageType == 'url'){		// オリジナル画像
			$this->tmpl->addVar("_widget", "original_img_checked",	'checked');
			$this->tmpl->addVar("_widget", "image_url",	$imageUrl);
		}
		if ($usePos) $this->tmpl->addVar('_widget', 'USE_POS',	'checked');	// 座標指定を可能とするかどうか
		if ($useLink) $this->tmpl->addVar('_widget', 'USE_LINK',	'checked');			// 画像にリンクを付けるかどうか
		
		// パスの設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "image_dir", $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR);	// デフォルト画像ディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
	/**
	 * 定義名リストを作成
	 *
	 * @return なし						
	 */
	function createDefList()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$targetObj = $this->paramObj[$i];
			$name = $targetObj->name;// 定義名
			$value = $i;
			$selected = '';
			if ($i == $this->configId) $selected = 'selected';
			$row = array(
				'name' => $name,		// 名前
				'value' => $value,		// 値
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('config_list', $row);
			$this->tmpl->parseTemplate('config_list', 'a');
		}
	}
	/**
	 * 画像定義リストを作成
	 *
	 * @return なし						
	 */
	function createImageDefList()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			// 行カラーの設定
			$lineColor = '';
			if ($i % 2 != 0){
				$lineColor = 'class="even"';		// 偶数行
			}
			$targetObj = $this->paramObj[$i];
			$name = $targetObj->name;// 定義名
			$value = $i;
			$selected = '';
			if ($i == $this->selConfigId) $selected = 'checked';
		
			// 画像
			$destImg = '<img src="' . $targetObj->imageUrl . '" ';
			$destImg .= 'width="' . self::IMAGE_WIDTH . '"';
			$destImg .= ' height="' . self::IMAGE_HEIGHT . '" ';
			$destImg .= 'style="border:0" />';
			$row = array(
				'index' => $i,
				'line_color' => $lineColor,											// 行のカラー
				'name' => $name,		// 名前
				'value' => $value,		// 値
				'image' => $destImg,	// 画像
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('image_list', $row);
			$this->tmpl->parseTemplate('image_list', 'a');
		}
	}
	/**
	 * メニュー画像メニューを作成
	 *
	 * @param string	$path			読み込みパス
	 * @param string	$selectedFile	選択中のファイル
	 * @param string  	$destTagName	書き込み先タグ名
	 * @return なし
	 */
	function createImageSelectMenu($path, $selectedFile, $destTagName)
	{
		// 画像ディレクトリチェック
		//$path = $gEnvManager->getCurrentWidgetRootPath() . '/' . self::IMAGE_DIR;
		if (is_dir($path)){
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){		// 「_」で始まる名前のファイルは読み込まない
					
					$selected = '';
					if ($file == $selectedFile){
						$selected = 'selected';
					}
					$row = array(
						'value'    => $file,			// ファイル名
						'name'     => $file,			// ファイル名
						'selected' => $selected														// 選択中かどうか
					);
					$this->tmpl->addVars($destTagName, $row);
					$this->tmpl->parseTemplate($destTagName, 'a');
				}
			}
			$dir->close();
		}
	}
}
?>
