<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_menuDb.php');

class admin_ec_menuWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $lang;
	private $categoryListData;		// 商品カテゴリー
	private $categoryArray;			// カテゴリー設定値
	CONST EC_MENU_ID = 'ec_menu';
	const CONTENT_WIDGET_ID = 'default_content';			// コンテンツ編集ウィジェット
	const CATEGORY_COUNT = 2;				// 商品カテゴリーの選択可能数
	const PARAM_CONTENT_ID = 'pcontent';	// コンテンツIDキー
	const PARAM_CATEGORY_ID = 'category';	// カテゴリーIDキー
	const CONTENT_TYPE = 'ec_menu';			// コンテンツタイプ
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_menuDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin_menu.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$userId = $gEnvManager->getCurrentUserId();
		$this->lang = $gEnvManager->getCurrentLanguage();
		
		$act = $request->trimValueOf('act');
		$selectedItemNo = $request->trimValueOf('no');		// 処理対象の項目番号
		$this->serialNo = $request->trimValueOf('item_selected');		// 選択項目のシリアル番号
		$id = $request->trimValueOf('id');
		$name = $request->trimValueOf('item_name');
		$html = $request->valueOf('item_html');		// ヘッダコンテンツ
		$linkType = $request->trimValueOf('link_type_list');
		$url = $request->trimValueOf('item_url');		// URL
		$visible = ($request->trimValueOf('item_visible') == 'on') ? 1 : 0;		// チェックボックス
		$enable = ($request->trimValueOf('item_enable') == 'on') ? 1 : 0;		// チェックボックス
		$homepage = ($request->trimValueOf('item_homepage') == 'on') ? 1 : 0;		// チェックボックス
		$pageType = $request->trimValueOf('pagetype');		// ページタイプ
			
		// カテゴリーを取得
		$this->categoryArray = array();
		for ($i = 0; $i < self::CATEGORY_COUNT; $i++){
			$itemName = 'item_category' . $i;
			$itemValue = $request->trimValueOf($itemName);
			if (!empty($itemValue)){		// 0以外の値を取得
				$this->categoryArray[] = $itemValue;
			}
		}
		
		if ($act == 'select'){		// 項目選択の場合
			if (empty($this->serialNo)){		// 新規項目追加のとき
				$id = 0;			// ID
				$name = '';		// 名前
				$linkType = 0;	// リンクタイプ
				$visible = 1;
				$enable = 1;
				$url = '';	// リンク先
				$this->categoryArray = array();// カテゴリー
				$html = '';
			} else {
				$ret = $this->db->getMenuBySerial($this->serialNo, $row);
				if ($ret){
					// 取得値を設定
					$id = $row['mi_id'];			// ID
					$name = $row['mi_name'];		// 名前
					$linkType = $row['mi_link_type'];	// リンクタイプ
					$visible = $row['mi_visible'];
					$enable = $row['mi_enable'];
					$this->serialNo = $row['mi_serial'];
					$url = $row['mi_link_url'];	// リンク先
					
					// カテゴリーIDとヘッダコンテンツIDを取得
					$param = $row['mi_param'];
					$parsedParam = parseUrlParam($param);
					$contentId = $parsedParam[self::PARAM_CONTENT_ID];
					$this->categoryArray = explode(',', $parsedParam[self::PARAM_CATEGORY_ID]);
					
					// コンテンツを取得
					$ret = $this->db->getContentByContentId(self::CONTENT_TYPE, $contentId, $this->lang, $row);
					if ($ret){
						$html = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $row['cn_html']);// アプリケーションルートを変換
					}
				}
			}
		} else if ($act == 'deleteall'){		// メニュー項目すべて削除のとき
			$ret = $this->db->delMenuAllItem(self::CONTENT_TYPE, $userId);
			if ($ret){
				$this->setGuidanceMsg('データを削除しました');
			} else {
				$this->setAppErrorMsg('データ削除に失敗しました');
			}
		} else if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, '名前');

			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// トランザクションスタート
				$this->db->startTransaction();
				
				// コンテンツ登録
				$contentId = 0;// コンテンツID初期化
				$default = 0;
				$key = '';
				$ret = $this->db->updateContentItem(self::CONTENT_TYPE, $contentId, $this->lang, $name, $html, 1/*コンテンツ表示*/, $default, $key, $userId, $newContentId, $newSerial);
				if ($ret) $contentId = $newContentId;// コンテンツID更新
				
				// IDを生成
				if ($ret){
					// パラメータ作成
					$param = self::PARAM_CATEGORY_ID . '=' . implode(',', $this->categoryArray) . '&' . self::PARAM_CONTENT_ID . '=' . $contentId;
				
					$id = $this->db->getNewMenuId();
					$ret = $this->db->addMenuItem(self::EC_MENU_ID, $id, $this->lang, $name, 0, $linkType, $url, $param, $visible, $enable, $userId, $newSerial);
				}
				// トランザクション終了
				$ret = $this->db->endTransaction();
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					$this->serialNo = $newSerial;		// シリアル番号を更新
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			//$this->checkSingleByte($id, 'ID');
			$this->checkInput($name, '名前');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				// トランザクションスタート
				$this->db->startTransaction();
				
				$ret = $this->db->getMenuBySerial($this->serialNo, $row);
				if ($ret){
					// ヘッダコンテンツIDを取得
					$param = $row['mi_param'];
					$parsedParam = parseUrlParam($param);
					$contentId = $parsedParam[self::PARAM_CONTENT_ID];
					if ($contentId == '') $contentId = 0;		// コンテンツID初期化
				}
										
				// コンテンツを更新
				if ($ret){
					$default = 0;
					$key = '';
					$ret = $this->db->updateContentItem(self::CONTENT_TYPE, $contentId, $this->lang, $name, $html, 1/*コンテンツ表示*/, $default, $key, $userId, $newContentId, $newSerial);
					if ($ret) $contentId = $newContentId;// コンテンツID更新
				}
				
				if ($ret){
					// パラメータ作成
					$param = self::PARAM_CATEGORY_ID . '=' . implode(',', $this->categoryArray) . '&' . self::PARAM_CONTENT_ID . '=' . $contentId;
					// メニューを更新
					$ret = $this->db->updateMenuItem(self::EC_MENU_ID, $id, $this->lang, $name, 0/*表示順は変更しない*/, $linkType, $url, $param, $visible, $enable, $userId);
				}
				
				// トランザクション終了
				$ret = $this->db->endTransaction();
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}				
		} else if ($act == 'delete'){		// 項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				// トランザクションスタート
				$this->db->startTransaction();
				
				$ret = $this->db->getMenuBySerial($this->serialNo, $row);
				if ($ret){
					// ヘッダコンテンツIDを取得
					$param = $row['mi_param'];
					$parsedParam = parseUrlParam($param);
					$contentId = $parsedParam[self::PARAM_CONTENT_ID];
					if ($contentId == '') $contentId = 0;		// コンテンツID初期化
				}
				if ($ret) $ret = $this->db->delMenuItem($this->serialNo);
				if ($ret) $ret = $this->db->delContentItem(self::CONTENT_TYPE, $contentId, $this->lang, $userId);		// コンテンツを削除
				
				// トランザクション終了
				$ret = $this->db->endTransaction();
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else if ($act == 'updatemenu'){		// メニュー項目順の更新のとき
			$menuitems = $request->trimValueOf('menuitems');
			if (!empty($menuitems)){
				$menuItemNoArray = explode(',', $menuitems);
			
				// メニューの並び順を変更
				$this->db->orderMenuItems(self::EC_MENU_ID, $this->lang, $menuItemNoArray);
			}			
		} else {			// 初期表示
			$id = 0;			// ID
			$name = '';		// 名前
			$linkType = 0;	// リンクタイプ
			$visible = 1;
			$enable = 1;
			$url = '';	// リンク先
			$this->categoryArray = array();// カテゴリー
			$html = '';
		}
		
		// ### 入力値を再設定 ###
		$this->tmpl->addVar("_widget", "sel_item_name", $name);		// 名前
		$this->tmpl->addVar("_widget", "sel_item_url", $url);		// URL
		$this->tmpl->addVar("_widget", "sel_item_html", $html);		// ヘッダコンテンツ
		$this->tmpl->addVar("_widget", "home_macro", M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END);		// ホーム位置マクロ
		
		// リンクタイプ
		switch ($linkType){
			case 0:			// 同ウィンドウで開くリンク
				$this->tmpl->addVar("_widget", "link_type_0", 'selected');
				break;
			case 1:			// 別ウィンドウで開くリンク
				$this->tmpl->addVar("_widget", "link_type_1", 'selected');
				break;
		}
		// 項目表示、項目利用可否チェックボックス
		$visibleStr = '';
		if ($visible){
			$visibleStr = 'checked';
		}
		$enableStr = '';
		if ($enable){
			$enableStr = 'checked';
		}
		$this->tmpl->addVar("_widget", "sel_item_visible", $visibleStr);
		$this->tmpl->addVar("_widget", "sel_item_enable", $enableStr);
		$checked = '';
		if ($homepage){
			$checked = 'checked';
		}
		$this->tmpl->addVar("_widget", "sel_item_homepage", $checked);
		
		// 選択中のシリアル番号、IDを設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "id", $id);
		
		// メニュー項目を取得
		$this->db->getAllMenuItems(array($this, 'itemListLoop'), self::EC_MENU_ID, $this->lang);
		
		// カテゴリーメニューを作成
		$this->db->getAllCategory($this->lang, $this->categoryListData);
		$this->createCategoryMenu();
		
		// ウィジェットメインIDメニュー作成
		//$this->db->getPageIdList(array($this, 'pageIdLoop'), 0);
		
		// ウィジェットサブIDメニュー作成
		//$this->db->getPageIdList(array($this, 'pageSubIdLoop'), 1);
			
		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// 新規追加をチェック状態にする
			
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->setAttribute('del_button', 'visibility', 'visible');// 「削除」ボタン
		}
		// コンテンツ表示ウィジェット
		$this->tmpl->addVar('_widget', 'content_widget_id', self::CONTENT_WIDGET_ID);
		// 管理者URL
		$this->tmpl->addVar('_widget', 'admin_url', $gEnvManager->getDefaultAdminUrl());
		// FCKEditor用パス
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "widget_sc_url", $gEnvManager->getCurrentWidgetScriptsUrl());
		$this->tmpl->addVar("_widget", "image_path", $gEnvManager->getRootUrl() . '/resource/');		// 画像の格納場所
		
		// 共通スクリプトディレクトリを設定
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemListLoop($index, $fetchedRow, $param)
	{
		static $rowno = 0;
		
		$visible = '';
		if ($fetchedRow['mi_visible']){
			$visible = 'checked';
		}
		$enable = '';
		if ($fetchedRow['mi_enable']){
			$enable = 'checked';
		}
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// リンクタイプ
		$linkString = '';
		switch ($fetchedRow['mi_link_type']){
			case 0:			// 同ウィンドウで開くリンク
				$linkString = '同ウィンドウ';
				break;
			case 1:			// 別ウィンドウで開くリンク
				$linkString = '別ウィンドウ';
				break;
		}
		// 項目選択のラジオボタンの状態
		$serial = $this->convertToDispString($fetchedRow['mi_serial']);
		$selected = '';
		if ($serial == $this->serialNo){
			$selected = 'checked';
		}
		
		// カテゴリー名を種痘
		$param = $fetchedRow['mi_param'];
		$parsedParam = parseUrlParam($param);
		$categoryParam = $parsedParam[self::PARAM_CATEGORY_ID];
		$category = '';
		if (!empty($categoryParam)){
			$ret = $this->db->getCategory($this->lang, $categoryParam, $rows);
			if ($ret){
				$count = count($rows);
				for ($i = 0; $i < $count; $i++){
					$category .= $rows[$i]['pc_name'];
					if ($i != $count -1) $category .= ',';
				}
			}
		}
					
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'rowno' => $rowno,													// 行番号
			'serial' => $serial,			// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['mi_id']),			// ID
			'name' => $this->convertToDispString($fetchedRow['mi_name']),		// 名前
			'index' => $this->convertToDispString($fetchedRow['mi_index']),		// インデックス
			'link_type' => $linkString,											// リンクタイプ
			'category' => $category,											// カテゴリー
			'update_dt' => $this->convertToDispDateTime($fetchedRow['mi_create_dt']),	// 更新日時
			'visible' => $visible,											// メニュー項目表示制御
			'enable' => $enable,												// メニュー項目利用制御
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// メニューのプレビュー
		if ($fetchedRow['mi_visible']){		// 表示項目のみ追加
			$this->tmpl->addVars('menuitemlist', $row);
			$this->tmpl->parseTemplate('menuitemlist', 'a');
			$rowno++;
		}
		return true;
	}
	/**
	 * ページID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	/*function pageIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['pg_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('main_id_list', $row);
		$this->tmpl->parseTemplate('main_id_list', 'a');
		return true;
	}*/
	/**
	 * ページサブID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	/*function pageSubIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['pg_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sub_id_list', $row);
		$this->tmpl->parseTemplate('sub_id_list', 'a');
		return true;
	}*/
	/**
	 * 商品カテゴリーメニューを作成
	 *
	 * @return なし						
	 */
	function createCategoryMenu()
	{
		for ($j = 0; $j < self::CATEGORY_COUNT; $j++){
			// selectメニューの作成
			$this->tmpl->clearTemplate('category_list');
			for ($i = 0; $i < count($this->categoryListData); $i++){
				$categoryId = $this->categoryListData[$i]['pc_id'];
				$selected = '';
				if ($j < count($this->categoryArray) && $this->categoryArray[$j] == $categoryId){
					$selected = 'selected';
				}
				$menurow = array(
					'value'		=> $categoryId,			// カテゴリーID
					'name'		=> $this->categoryListData[$i]['pc_name'],			// カテゴリー名
					'selected'	=> $selected														// 選択中かどうか
				);
				$this->tmpl->addVars('category_list', $menurow);
				$this->tmpl->parseTemplate('category_list', 'a');
			}
			$itemRow = array(		
					'index'		=> $j			// 項目番号											
			);
			$this->tmpl->addVars('category', $itemRow);
			$this->tmpl->parseTemplate('category', 'a');
		}
	}
}
?>
