<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainDb.php');

class ec_mainAgreememberWidgetContainer extends BaseWidgetContainer
{
	private $mainDb;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	const SES_KEY_AGREE_MEMBER = 'agree_member';		// 会員規約に同意したかどうかのセッションキー
	const AGREE_MEMBER_TEXT_KEY = 'agreement';				// 会員規約のコンテンツデータキー
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->mainDb = new ec_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'agreemember.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		global $gTextConvManager;
		
		$langId = $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		
		$act = $request->trimValueOf('act');
		if ($act == 'agree'){			// 会員規約に同意のとき
			// セッションの会員規約同意状態を更新
			$this->setWidgetSession(self::SES_KEY_AGREE_MEMBER, 1);
			
			// 会員登録画面へ遷移
			$regmemberPage = $gEnvManager->createCurrentPageUrl() . '&task=regmember';
			$gPageManager->redirect($regmemberPage);
			return;
		}
		// 会員規約を取得
		$content = '';
		if ($this->mainDb->getContentByKey(self::AGREE_MEMBER_TEXT_KEY, $langId, $row)){
			$content = $row['cn_html'];
		}
		
		// 登録したキーワードを変換
		$gTextConvManager->convByKeyValue($contentText, $contentText, true/*改行コーをbrタグに変換*/);
		
		$this->tmpl->addVar("_widget", "content", $content);		// 会員規約
		$this->tmpl->addVar("_widget", "cancel_url", $gEnvManager->createCurrentPageUrl());		// キャンセル用URL
	}
}
?>
