<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainPagedefWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// システム情報取得用
	private $pageId;	// ページID
	private $pageSubId;	// ページサブID
	private $position;	// 表示ポジション
	private $isRegisted;// 登録したかどうか
	private $addPos;	// 追加表示ポジション
	private $addWidgetId; // 追加ウィジェットID
	private $defaultPageSubId;		// デフォルトのページID
	private $defaultImageSize = 32;		// ウィジェット画像サイズ
	private $widgetArray = array();
	private $templateId;		// テンプレートID
	private $delAllButtonEnabled = true;		// すべて削除ボタンの状態
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
				
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'pagedef.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		// パラメータの取得
		// メニューからの選択項目
		$this->pageId = $request->trimValueOf('pageid');		// ページID
		$this->pageSubId = $request->trimValueOf('pagesubid');// ページサブID
		$this->position = $request->trimValueOf('position');	// 表示ポジション
		if (empty($this->pageId)) $this->pageId = 'index';				// デフォルト値
		if (empty($this->pageSubId)) $this->pageSubId = $gEnvManager->getDefaultPageSubIdByPageId($this->pageId);
		$selectedItemNo = $request->trimValueOf('no');		// 処理対象の項目番号
		$showLayout = $request->trimValueOf('showlayout');		// レイアウトの表示制御
		if (empty($showLayout)) $showLayout = 1;		// 初期時はレイアウトを表示
				
		$userId = $gEnvManager->getCurrentUserId();
		$this->isRegisted = false;	// 登録したかどうか
		$act = $request->trimValueOf('act');
		if ($act == 'addline'){		// 新規追加のとき
			$this->addPos   = $request->trimValueOf('add_pos');		// 表示ポジション
			$addIndex = $request->trimValueOf('add_index');			// 表示インデックス
			$this->addWidgetId = $request->trimValueOf('add_widget');		// ウィジェットID
			$addSuffix = $request->trimValueOf('add_suffix');		// サフィックス
			//$addVisible = ($request->trimValueOf('add_visible') == 'on') ? 't' : 'f';		// 表示状態 // bug MySQLで動かない2007/3/9
			$addVisible = ($request->trimValueOf('add_visible') == 'on') ? 1 : 0;		// 表示状態

			// ページサブIDを設定
			$addPageSubId = '';// 共通使用
			if ($request->trimValueOf('add_shared') != 'on') $addPageSubId = $this->pageSubId;

			// 入力チェック
			if (empty($this->addPos)) $this->setMsg(self::MSG_USER_ERR, '表示ポジションが選択されていません');
			if (empty($this->addWidgetId)) $this->setMsg(self::MSG_USER_ERR, 'ウィジェットIDが選択されていません');

			$this->checkNumeric($addIndex, '表示順');
			if (!empty($addSuffix)) $this->checkSingleByte($addSuffix, 'サフィックス');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updatePageDef(0, $this->pageId, $addPageSubId, $this->addPos, $addIndex, $this->addWidgetId, 0, $addSuffix, '', $addVisible, $userId);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを追加しました');
					$this->isRegisted = true;// 登録完了
				}
			}
			// 登録完了しなかった場合は、入力値を再設定
			if (!$this->isRegisted ){
				$this->tmpl->addVar("_widget", "index", $addIndex);
				$this->tmpl->addVar("_widget", "suffix", $addSuffix);
			}
		} else if ($act == 'updateline'){		// 更新のとき
			$updateSerial = $request->trimValueOf('serial');		// シリアルNo
			// 変更可能値
			$updateIndex = $request->trimValueOf('item' . $selectedItemNo . '_index');			// 表示インデックス
			$instanceDefId = $request->trimValueOf('item' . $selectedItemNo . '_def_id');		// 定義ID
			if ($instanceDefId == '') $instanceDefId = 0;
			$updateSuffix = $request->trimValueOf('item' . $selectedItemNo . '_suffix');		// サフィックス
			//$updateVisible = ($request->trimValueOf('item' . $selectedItemNo . '_visible') == 'on') ? 't' : 'f';		// 表示状態// bug MySQLで動かない2007/3/9
			$updateVisible = ($request->trimValueOf('item' . $selectedItemNo . '_visible') == 'on') ? 1 : 0;		// 表示状態

			// 変更前値を取得
			if ($this->db->getPageDef($updateSerial, $row)){
				//$updatePageSubId = $row['pd_sub_id'];
				$updatePos = $row['pd_position_id'];
				$updateWidgetId = $row['pd_widget_id'];
				
				// 「共通」項目に合わせて、ページサブIDの修正
				$updatePageSubId = '';// 共通使用
				if ($request->trimValueOf('item' . $selectedItemNo . '_shared') != 'on') $updatePageSubId = $this->pageSubId;
			
				// 入力チェック
				$this->checkNumeric($updateIndex, '表示順');
				if (!empty($updateSuffix)) $this->checkSingleByte($updateSuffix, 'サフィックス');
			
				// エラーなしの場合は、データを登録
				if ($this->getMsgCount() == 0){
					$ret = $this->db->updatePageDef($updateSerial, $this->pageId, $updatePageSubId, $updatePos, $updateIndex, $updateWidgetId, $instanceDefId,
														$updateSuffix, '', $updateVisible, $userId);
					if ($ret){		// データ更新成功のとき
						$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					} else {
						$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
					}
				}
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
			}
		} else if ($act == 'deleteline'){		// 削除のとき
			$delSerial = $request->trimValueOf('serial');		// シリアルNo
			$ret = $this->db->delPageDef($delSerial, $userId);
			if ($ret){		// データ削除成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'データを削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ削除に失敗しました');
			}
		} else if ($act == 'deleteall'){		// すべて削除のとき
			$withCommon = ($request->trimValueOf('with_common') == 'on') ? 1 : 0;		// 共通項目も削除するかどうか
			$ret = $this->db->delPageDefAll($this->pageId, $this->pageSubId, $this->position, $withCommon);
			if ($ret){		// データ削除成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'データを削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ削除に失敗しました');
			}		
		} else if ($act == 'showpagedefdetail'){		// 画面詳細定義を表示のとき
			// 詳細表示をセッションに保存
			$request->setSessionValue(M3_SESSION_PAGE_DEF_DETAIL, 1);
		} else if ($act == 'hidepagedefdetail'){		// 画面詳細定義を非表示のとき
			// 詳細表示をセッションに保存
			$request->setSessionValue(M3_SESSION_PAGE_DEF_DETAIL, 0);
		} else if ($act == 'changetemplate'){		// テンプレート変更のとき
			$templateId = $request->trimValueOf('sel_template');		// テンプレートID
			if (!empty($templateId)){
				$this->db->changeDefaultTemplate($templateId, $userId);
			
				// セッションのテンプレートIDを更新
				$request->setSessionValue(M3_SESSION_CURRENT_TEMPLATE, $templateId);
			}
		}
		// 詳細定義画面
		$showDetail = $request->getSessionValue(M3_SESSION_PAGE_DEF_DETAIL);
		
		// ウィジェットメインIDメニュー作成
		$this->db->getPageIdList(array($this, 'pageIdLoop'), 0);
		
		// ウィジェットサブIDメニュー作成
		$this->db->getPageIdList(array($this, 'pageSubIdLoop'), 1);
		
		// デフォルトのテンプレートを取得
		$this->templateId = $this->sysDb->getDefaultTemplateId();
		$imagePath = $gEnvManager->getTemplatesUrl() . '/' . $this->templateId . '/template_thumbnail.png';
		$this->tmpl->addVar("_widget", "TMPL_IMAGE", $imagePath);							// プレビュー画像
			
		// テンプレート選択メニュー作成
		$this->db->getAllTemplateList(array($this, 'templateIdLoop'));
		
		// ページ定義リスト作成
		if (!empty($showDetail)){		// 詳細定義領域表示の場合のみリスト取得
			$this->db->getPageDefList(array($this, 'pageListLoop'), $this->pageId, $this->pageSubId, $this->position);
			
			// ポジションメニュー作成
			$this->db->getPagePositionList(array($this, 'pagePositionLoop'));
		
			// 項目追加用ウィジェットリストを取得
			$this->db->getAvailableWidgetList(array($this, 'widgetListMenuLoop'));
		}
		// ウィジェットリストを取得
		$this->db->getAvailableWidgetList(array($this, 'widgetListLoop'));
			
		// URLを設定
		$pathArray = explode('_', $this->pageId);
		for ($i = 0; $i < count($pathArray); $i++){
			$path .= '/' . $pathArray[$i];
		}
		$url = $gEnvManager->getRootUrl() . $path . '.php';
		if ($this->pageSubId != $this->defaultPageSubId){
			$url .= '?sub=' . $this->pageSubId;
		}
		$this->tmpl->addVar("_widget", "url", $url);
		
		// ウィジェットIDのリスト
		$widgetList = '';
		if (!empty($this->widgetArray)) $widgetList = implode($this->widgetArray, ',');
		$this->tmpl->addVar("_widget", "widget_list", $widgetList);
		
		if ($this->db->canDetailConfig()){		// 詳細設定可のときは、ページID選択を可にする
			$this->tmpl->setAttribute('hide_page_id', 'visibility', 'visible');// ページID選択メニュー
			$this->tmpl->addVar('_widget', 'page_id_col', 'colspan="3"');		// カラム数を調整
		}
		// 詳細定義領域の表示制御
		if (empty($showDetail)){
			$this->tmpl->addVar('_widget', 'page_def_act', 'showpagedefdetail');		// ボタンを押したときの動作
			$this->tmpl->addVar('_widget', 'button_page_def_detail', '詳細定義を表示');		// ボタンラベル
		} else {
			$this->tmpl->setAttribute('page_def_detail', 'visibility', 'visible');// 詳細定義
			if (!$this->delAllButtonEnabled) $this->tmpl->addVar("page_def_detail", "del_all_button", 'disabled');	// すべて削除ボタンの状態
			
			$this->tmpl->addVar('_widget', 'page_def_act', 'hidepagedefdetail');		// ボタンを押したときの動作
			$this->tmpl->addVar('_widget', 'button_page_def_detail', '詳細定義を隠す');		// ボタンラベル
		}
		$this->tmpl->addVar('_widget', 'SHOW_LAYOUT', $showLayout);		// レイアウト表示
		$this->tmpl->addVar("_widget", "SYSTEM_ROOT", $gEnvManager->getRootUrl());		// システムのルートURL
	}
	/**
	 * ページ定義、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageListLoop($index, $fetchedRow, $param)
	{
		// サブIDが空のときは、共通項目とする
		$isSharedItem = '';
		if (empty($fetchedRow['pd_sub_id'])){
			$isSharedItem = 'checked';
		}
		// 編集不可項目のときは、ボタンを使用不可にする
		$buttonEnabled = '';
		if (!$fetchedRow['pd_editable']){
			$buttonEnabled = 'disabled';
			$this->delAllButtonEnabled = false;			// すべて削除ボタンを使用不可にする
		}
		// 項目を画面に表示するかどうか
		$itemVisible = '';
		if ($fetchedRow['pd_visible']) $itemVisible = 'checked';
		
		// 定義ID
		$defId = $fetchedRow['pd_config_id'];
		if ($defId == '0') $defId = '';
		
		// インスタンス定義を使用するかどうか
		$hasInstanceDef = '';
		$detaiButton = '';
		if ($fetchedRow['wd_use_instance_def']){		// 定義ありの場合
			if (empty($defId)) $hasInstanceDef = 'style="background-color:yellow;"';
		} else {
			$detaiButton = 'disabled';
			$hasInstanceDef = 'readonly';
		}
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		$row = array(
			'line_color'	=> $lineColor,											// 行のカラー
			'no'			=> $index + 1,											// 行番号
			'serial' 		=> $this->convertToDispString($fetchedRow['pd_serial']),			// シリアルNo
//			'id' 			=> $this->convertToDispString($fetchedRow['wd_id']),			// ウィジェットID
			'name'			=> $this->convertToDispString($fetchedRow['wd_name']),		// 名前
			'position'		=> $this->convertToDispString($fetchedRow['pd_position_id']),	// 表示ポジション
			'index'			=> $this->convertToDispString($fetchedRow['pd_index']),				// 表示順
			'widget_id'		=> $this->convertToDispString($fetchedRow['pd_widget_id']),				// ウィジェットID
			'widget_name'		=> $this->convertToDispString($fetchedRow['wd_name']),				// ウィジェット名
			'def_id'		=> $this->convertToDispString($defId),			// 定義ID
			'suffix'		=> $this->convertToDispString($fetchedRow['pd_suffix']),			// サフィックス
			'shared'		=> $isSharedItem,												// 共通項目かどうか
			'visible'		=> $itemVisible,												// 画面に表示するかどうか
			'has_instance_def' => $hasInstanceDef,								// インスタンス定義が必要かどうか
			'detail_button' => $detaiButton,												// ボタン使用制御
			'update_button' => $buttonEnabled,												// ボタン使用制御
			'delete_button'	=> $buttonEnabled,												// ボタン使用制御
		);
		$this->tmpl->addVars('page_def_list', $row);
		$this->tmpl->parseTemplate('page_def_list', 'a');
		return true;
	}
	/**
	 * ページID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['pg_id'] == $this->pageId){
			$selected = 'selected';
			
			// デフォルトのページサブIDを取得
			$this->defaultPageSubId = $fetchedRow['pg_default_sub_id'];		// デフォルトのページID
		}
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['pg_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('main_id_list', $row);
		$this->tmpl->parseTemplate('main_id_list', 'a');
		return true;
	}
	/**
	 * ページサブID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageSubIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$pid = $fetchedRow['pg_id'];
		if ($pid == $this->pageSubId){
			$selected = 'selected';
		}
		$value = $this->convertToDispString($pid);
		
		// 表示ラベルを作成
		$private = '';			// 公開状態
		if (!$fetchedRow['pg_is_public']) $private = '[非公開]';
		$name = $value . $private . ' - ' . $this->convertToDispString($fetchedRow['pg_name']);
		// デフォルトのページサブIDのときは、説明を付加
		if ($pid == $this->defaultPageSubId){
			$name .= ' (デフォルト値)';
		}
		$row = array(
			'value'    => $value,			// ページID
			'name'     => $name,			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sub_id_list', $row);
		$this->tmpl->parseTemplate('sub_id_list', 'a');
		return true;
	}
	/**
	 * テンプレート一覧を作成
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function templateIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['tm_id'] == $this->templateId){
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['tm_id']),			// テンプレートID
			'name'     => $this->convertToDispString($fetchedRow['tm_name']),			// テンプレート名名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sel_template_list', $row);
		$this->tmpl->parseTemplate('sel_template_list', 'a');
		return true;
	}
	/**
	 * ページポジション、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pagePositionLoop($index, $fetchedRow, $param)
	{
		// フィルタリング用
		$selected = '';
		if ($fetchedRow['tp_id'] == $this->position){
			$selected = 'selected';
		}
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['tp_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['tp_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('position_list', $row);
		$this->tmpl->parseTemplate('position_list', 'a');
		
		// 項目追加用
		// 入力エラーの場合は、設定値をもどす
		$selected = '';
		if (!$this->isRegisted && $this->addPos == $fetchedRow['tp_id']){
			$selected = 'selected';
		}
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['tp_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['tp_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sel_position_list', $row);
		$this->tmpl->parseTemplate('sel_position_list', 'a');
		return true;
	}
	
	/**
	 * ウィジェットリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function widgetListMenuLoop($index, $fetchedRow, $param)
	{
		// 入力エラーの場合は、設定値をもどす
		$selected = '';
		if (!$this->isRegisted && $this->addWidgetId == $fetchedRow['wd_id']){
			$selected = 'selected';
		}
		
		$dispWidgetId = $this->convertToDispString($fetchedRow['wd_id']);
		$row = array(
			'value'    => $dispWidgetId,				// ウィジェットID
			'name'     => $dispWidgetId . '/' . $this->convertToDispString($fetchedRow['wd_name']),			// ウィジェット名
			'selected' => $selected														// 選択中かどうか
		);
		// 項目追加用
		$this->tmpl->addVars('sel_widget_list', $row);
		$this->tmpl->parseTemplate('sel_widget_list', 'a');
		return true;
	}
	/**
	 * ウィジェットリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function widgetListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		global $gDesignManager;
		
		$hasScript = '';
		if ($fetchedRow['wd_read_scripts']){
			$hasScript = 'checked';
		}
		$hasCss = '';
		if ($fetchedRow['wd_read_css']){
			$hasCss = 'checked';
		}
		$hasAdmin = '0';
		if ($fetchedRow['wd_has_admin']){
			$hasAdmin = '1';
		}
		// 編集不可項目のときは、ボタンを使用不可にする
		$buttonEnabled = '';
		if (!$fetchedRow['wd_editable']) $buttonEnabled = 'disabled';
		
		// 管理画面がないときは、詳細ボタンを使用不可にする
		$detailButtonEnabled = '';
		if (!$fetchedRow['wd_has_admin']) $detailButtonEnabled = 'disabled';
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		
		// 新規に追加されたウィジェットかチェック
		$id = $this->convertToDispString($fetchedRow['wd_id']);
		$idText = $id;
		for ($i = 0; $i < count($this->newWidget); $i++){
			if ($this->newWidget[$i] == $id){
				$idText = '<b><font color="green">' . $id . '</font></b>';
				break;
			}
		}
		
		// ウィジェット名
		$name = $this->convertToDispString($fetchedRow['wd_name']);
		
		// ウィジェットの画像を設定
		$image = $gDesignManager->getWidgetIconUrl($id, $this->defaultImageSize);
		$imageTag = '<img class="widget_obj" src="' . $image . '" ';
		$imageTag .= 'width="' . $this->defaultImageSize . '"';
		$imageTag .= ' height="' . $this->defaultImageSize . '"';
		$imageTag .= ' />';
		
		$message = '<b>' . $name . '</b><br>' . $id;
		$imageTag = '<span class="tooltip_text" href="#" onmousemove="showToolTip(event,\'' . $message . '\');return false" onmouseout="hideToolTip();">' . $imageTag . '</span>';
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['wd_serial']),			// シリアル番号
			'id' => $id,			// ID
			'widget_id' => 'widget_' . $id,
			'id_text' => $idText,
			'name' => $name,		// 名前
			'image_tag' => $imageTag		// 画像
		);
		$this->tmpl->addVars('widgetlist', $row);
		$this->tmpl->parseTemplate('widgetlist', 'a');
		
		$this->widgetArray[] = $id;
		return true;
	}
}
?>
