<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_youtubeWidgetContainer extends BaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		$filename = $request->trimValueOf('item_image');		// 画像ファイル名
		$defSerial = $request->trimValueOf('serial');		// ウィジェットのシリアル番号
		$act = $request->trimValueOf('act');
		if ($act == 'update'){		// 設定更新のとき
			// 入力値を取得
			$title	= $request->trimValueOf('item_title');			// ヘッダタイトル
			$width	= $request->trimValueOf('item_width');		// ヘッダの幅
			$height	= $request->trimValueOf('item_height');		// ヘッダの高さ
			$movieId = $request->trimValueOf('item_movie_id');		// YouTubeの動画ID
			
			// 入力値のエラーチェック
			$this->checkNumeric($width, '幅');
			$this->checkNumeric($height, '高さ');
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$paramObj->title	= $title;			// ヘッダタイトル
				$paramObj->width	= $width;		// ヘッダの幅
				$paramObj->height	= $height;		// ヘッダの高さ
				$paramObj->movieId	= $movieId;		// YouTubeの動画ID
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}				
			}
		} else {		// 初期表示の場合
			// デフォルト値設定
			$title = '';	// ヘッダタイトル
			$width	= 130;		// 幅
			$height	= 130;		// 高さ
			//$movieId = 'h_Z3ntLcUBE';		// YouTubeの動画ID
			$movieId = 'J_W0_VrUSBU';		// YouTubeの動画ID
					
			$paramObj = $this->getWidgetParamObj();
			if (!empty($paramObj)){
				$title	= $paramObj->title;			// ヘッダタイトル
				$width	= $paramObj->width;		// ヘッダの幅
				$height	= $paramObj->height;		// ヘッダの高さ
				$movieId = $paramObj->movieId;		// YouTubeの動画ID
			}
		}
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "def_serial",	$defSerial);		// ページ定義のシリアル番号
		$this->tmpl->addVar("_widget", "title",	$title);
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "movie_id",	$movieId);
		
		// パスの設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
}
?>
