<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainCartDb.php');

class ec_mainConfirmWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $cartDb;		// カートアクセス用ＤＢオブジェクト
	private $deliveryMethod;		// 配送方法
	private $payMethod;			// 支払い方法
	private $orderId;			// 受注ID
	private $userId;
	private $now;				// 現在日時
	private $currency;			// 通貨
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const THIS_WIDGET_ID = 'ec_main';
	const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const STANDARD_PRICE = 'selling';		// 通常価格
	const ORDER_STATUS_REGIST = 200;			// 登録時のステータス(受注受付)
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new ec_mainOrderDb();
		$this->cartDb = new ec_mainCartDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'confirm.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		
		$this->now = date("Y/m/d H:i:s");	// 現在日時
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$this->userId = $gEnvManager->getCurrentUserId();
		$this->currency = $this->ecObj->getDefaultCurrency();		// 通貨
		
		// クッキー読み込み、カートIDを取得
		$cartId = $request->getCookieValue(M3_COOKIE_CART_ID);
		
		$act = $request->trimValueOf('act');
		if ($act == 'order'){			// 購入完了
			// 受注処理
			$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
			if ($ret){			
				// トランザクションスタート
				$this->db->startTransaction();
			
				// 受注No作成
				$orderNo = $this->createOrderNo();

				// 受注ヘッダ作成
				$orderStatus = self::ORDER_STATUS_REGIST;
				$estimateDt = $gEnvManager->getInitValueOfTimestamp();
				$registDt = $this->now;
				$orderDt = $gEnvManager->getInitValueOfTimestamp();
				$delivDt = $gEnvManager->getInitValueOfTimestamp();
				$closeDt = $gEnvManager->getInitValueOfTimestamp();
				$ret = $this->db->updateOrder(0, $this->userId, $this->langId, $orderNo,
					$row['oe_custm_id'], $row['oe_custm_name'], $row['oe_custm_name_kana'], $row['oe_custm_person'], $row['oe_custm_person_kana'],
					$row['oe_custm_zipcode'], $row['oe_custm_state_id'], $row['oe_custm_address1'], $row['oe_custm_phone'], $row['oe_custm_fax'], $row['oe_custm_country_id'], 
					$row['oe_deliv_id'], $row['oe_deliv_name'], $row['oe_deliv_name_kana'], $row['oe_deliv_person'], $row['oe_deliv_person_kana'],
					$row['oe_deliv_zipcode'], $row['oe_deliv_state_id'], $row['oe_deliv_address1'], $row['oe_deliv_phone'], $row['oe_deliv_fax'], $row['oe_deliv_country_id'],
					$row['oe_bill_id'], $row['oe_bill_name'], $row['oe_bill_name_kana'], $row['oe_bill_person'], $row['oe_bill_person_kana'], 
					$row['oe_bill_zipcode'], $row['oe_bill_state_id'], $row['oe_bill_address1'], $row['oe_bill_phone'], $row['oe_bill_fax'], $row['oe_bill_country_id'],
					$row['oe_deliv_method_id'], $row['oe_pay_method_id'], $row['oe_card_type'], $row['oe_card_owner'], $row['oe_card_number'], $row['oe_card_expires'],
					$row['oe_demand_dt'], $row['oe_appoint_dt'], $row['oe_currency_id'], $row['oe_subtotal'], $row['oe_discount'], $row['oe_deliv_fee'], $row['oe_charge'], $row['oe_total'],
					$orderStatus, $estimateDt, $registDt, $orderDt, $delivDt, $closeDt,
					$this->userId, $this->now, $this->orderId, $newSerial);
					
				// 受注詳細作成
				// カートの商品を受注明細にコピー
				if (!empty($cartId)){	// カートIDが設定されているとき
					$this->cartDb->getCartItemList($cartId, $this->langId, array($this, 'cartToOrderLoop'));
				}
				
				// トランザクション終了
				$ret = $this->db->endTransaction();
			}
			if ($ret){
				// データ再取得
				$ret = $this->db->getOrder($this->orderId, $row);
				if ($ret){
					$name = $row['or_deliv_name'];
					$nameKana = $row['or_deliv_name_kana'];
					$zipcode = $row['or_deliv_zipcode'];
					$address = $row['or_deliv_address1'];
					$phone = $row['or_deliv_phone'];
					$this->state = $row['or_deliv_state_id'];
					$this->deliveryMethod = $row['or_deliv_method_id'];		// 配送方法
					$this->payMethod = $row['or_pay_method_id'];		// 支払い方法
					
					$deliveryFee = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $row['or_deliv_fee']);
					$total = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $row['or_total']);
				}
				$this->tmpl->addVar("_widget", "message_bottom", '以上の内容でご注文承りました。');		// メッセージ
				
				// カートの商品を取得し、表示が終わった後、カートの内容をすべて削除
				$this->total = 0;					// 合計価格
				if (!empty($cartId)){	// カートIDが設定されているとき
					$this->cartDb->getCartItemList($cartId, $this->langId, array($this, 'cartLoop'));
					
					// カートの内容をすべて削除
					$ret = $this->cartDb->getCartHead($cartId, $this->langId, $row);
					if ($ret) $this->cartDb->deleteProductInCart($row['sh_serial'], 0);
				}
				
				// 受注シートを削除
				$this->db->delOrderSheet($this->userId, $this->langId);
			} else {
				$this->setAppErrorMsg('登録処理に失敗しました。');
				
				// カートの商品を取得
				$this->total = 0;					// 合計価格
				if (!empty($cartId)){	// カートIDが設定されているとき
					$this->cartDb->getCartItemList($cartId, $this->langId, array($this, 'cartLoop'));
				}
			}
		} else {
			$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
			if ($ret){
				$name = $row['oe_deliv_name'];
				$nameKana = $row['oe_deliv_name_kana'];
				$zipcode = $row['oe_deliv_zipcode'];
				$address = $row['oe_deliv_address1'];
				$phone = $row['oe_deliv_phone'];
				$this->state = $row['oe_deliv_state_id'];
				$this->deliveryMethod = $row['oe_deliv_method_id'];		// 配送方法
				$this->payMethod = $row['oe_pay_method_id'];		// 支払い方法
				
				// 配送料、合計の作成
				$deliveryFee = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $row['oe_deliv_fee']);
				$total = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $row['oe_total']);
			}
			$this->tmpl->addVar("_widget", "message_top", '注文を確定してください。');		// メッセージ
			
			// 確認ボタンを表示
			$this->tmpl->setAttribute('show_confirm', 'visibility', 'visible');
			
			// カートの商品を取得
			$this->total = 0;					// 合計価格
			if (!empty($cartId)){	// カートIDが設定されているとき
				$this->cartDb->getCartItemList($cartId, $this->langId, array($this, 'cartLoop'));
			}
		}
		
		// 入力値を戻す
		$this->tmpl->addVar("_widget", "name", $name);
		$this->tmpl->addVar("_widget", "name_kana", $nameKana);
		$this->tmpl->addVar("_widget", "zipcode", $zipcode);
		$this->tmpl->addVar("_widget", "address", $address);
		$this->tmpl->addVar("_widget", "phone", $phone);
		$this->tmpl->addVar("_widget", "delivery_fee", $deliveryFee);
		$this->tmpl->addVar("_widget", "total", $total);
				
		// 都道府県を設定
		$this->db->getAllState('JPN', $this->langId, array($this, 'stateLoop'));
		
		// 配送方法メニューを作成
		$this->db->getAllDeliveryMethod($this->langId, array($this, 'deliveryMethodLoop'));
		
		// 支払い方法メニューを作成
		$this->db->getAllPaymentMethod($this->langId, array($this, 'paymentMethodLoop'));
		
		// 遷移先を設定
		$this->tmpl->addVar("_widget", "confirm_url", $gEnvManager->createCurrentPageUrl() . '&task=confirm');		// 確認画面
		$this->tmpl->addVar("_widget", "payment_url", $gEnvManager->createCurrentPageUrl() . '&task=payment');		// 支払い方法画面
	}
	/**
	 * 取得した都道府県をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function stateLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['gz_id'] == $this->state){		// 選択中の都道府県
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['gz_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['gz_name']),			// 表示名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('state_list', $row);
		$this->tmpl->parseTemplate('state_list', 'a');
		return true;
	}
	/**
	 * 取得した配送方法をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function deliveryMethodLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['dm_id'] == $this->deliveryMethod){		// 選択中の配送方法
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['dm_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['dm_name']),			// 表示名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('delivery_method_list', $row);
		$this->tmpl->parseTemplate('delivery_method_list', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function cartLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$priceStatus = 1;	// 価格が有効であるかどうか
		$id = $fetchedRow['si_product_id'];	// 商品ID
		
		// 商品を取得
		$ret = $this->cartDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
			$code = $this->convertToDispString($row['pt_code']);		// 商品コード
			
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 商品が表示不可のときは価格を無効とする
			if (!$row['pt_visible']) $priceStatus = 0;
		} else {
			// 商品情報が取得できないときは価格無効
			$priceStatus = 0;
		}
		
		// 価格が変更のときは、価格を無効にする
		$quantity = $fetchedRow['si_quantity'];
		$subtotal = $fetchedRow['si_subtotal'];
		$oldCurrency = $fetchedRow['si_currency_id'];
		if ($unitPrice * $quantity != $subtotal) $priceStatus = 0;
		if ($oldCurrency != $currency) $priceStatus = 0;
		
		// 通貨情報を取得
		$ret = $this->cartDb->getCurrency($oldCurrency, $this->langId, $row);
		if ($ret){
			$prePrice = $this->convertToDispString($row['cu_symbol']);
			$postPrice = $this->convertToDispString($row['cu_post_symbol']);
		}
		
		// 価格作成
		$this->ecObj->setCurrencyType($oldCurrency, $this->langId);		// 通貨設定
		$this->ecObj->getPriceWithoutTax($subtotal, $dispPrice);		// 小計の表示文字列作成
					
		// 価格の有効判断
		if (!$fetchedRow['si_available']) $priceStatus = 0;
		
		// 小計価格
		$available = '';
		if ($priceStatus == 0) $available = '(無効)';
		$price = $prePrice . $dispPrice . $available;
		
		$this->total += $subtotal;					// 合計価格
		
		// 商品詳細へのリンク
		$url  = '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_FIND_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . self::TARGET_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_FROM . '=' . self::THIS_WIDGET_ID;		// 送信元
		$url .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode('product=' . $fetchedRow['si_product_id']);
			
		$nameLink = '<a href="' . $url . '">' . $name . '</a>';
		$row = array(
			'name' => $nameLink,
			'code' => $code,
			'unit_price' => $dispUnitPrice,			// 税込み単価
			'id' => $id,					// 商品ID
			'price' => $price,
			'quantity' => $quantity,
			'price_status' => $priceStatus		// 商品価格が有効かどうか
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		$this->productExists = true;			// カートに商品があるかどうか
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function cartToOrderLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$id = $fetchedRow['si_product_id'];	// 商品ID
		$quantity = $fetchedRow['si_quantity'];
		$subtotal = $fetchedRow['si_subtotal'];
		
		// 商品を取得
		$ret = $this->cartDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
			$code = $this->convertToDispString($row['pt_code']);		// 商品コード
			
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 受注明細を登録
			$tax = $subtotal - $price * $quantity;
			$this->db->addOrderDetail($this->orderId, $index, $id, $name, $price, $quantity, $tax, $subtotal, $this->userId, $this->now);
		}
		return true;
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 取得した配送方法をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function paymentMethodLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['pm_id'] == $this->payMethod){		// 選択中の支払い方法
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pm_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['pm_name']),			// 表示名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('payment_method_list', $row);
		$this->tmpl->parseTemplate('payment_method_list', 'a');
		return true;
	}
	/**
	 * 受注番号を作成(フォーマット: yyyymmdd-0000)
	 *
	 * @return string					受注番号
	 */
	function createOrderNo()
	{
		$no = '';
		$ret = $this->db->getLatestOrder($latestRow);		// 最新の受注No取得
		if ($ret){
			if (!empty($latestRow['or_order_no'])){
				list($date, $foreNo) = explode('-', $latestRow['or_order_no']);
				$today = date("Ymd");
				if ($date == $today){
					$no = $date . '-' . sprintf("%04d", (intval($foreNo) + 1));
				}
			}
		}

		// 新規作成の場合
		if (empty($no)) $no = date("Ymd-" . '0001');	// 現在日
		return $no;
	}
}
?>
