<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/default_contentDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class admin_default_contentWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $contentId;
	private $mode;			// 画面モード
	private $langId;		// 現在の選択言語
	private $dispContIdArray = array();		// 表示されているコンテンツID
	private $_menuId = 'main_menu';				// メインメニューID
	const INC_INDEX = 1;		// メニュー項目表示順の増加分
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new default_contentDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);		// 処理分岐
		if ($task == 'createmenuitem'){
			return 'admin_main_menuitem.tmpl.html';
		} else {
			return 'admin_main.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);		// 処理分岐
		if ($task == 'createmenuitem'){
			return $this->createMenuItem($request, $param);
		} else {
			return $this->createContentList($request, $param);
		}
	}
	/**
	 * コンテンツ一覧画面作成
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function createContentList($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;

		// ユーザ情報、表示言語
		$userInfo = $gEnvManager->getCurrentUserInfo();
		$defaultLang = $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		$act = $request->trimValueOf('act');
		$this->contentId = $request->trimValueOf('contentid');		// コンテンツID
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		$this->langId = $request->trimValueOf('item_lang');				// 現在メニューで選択中の言語
		if (empty($this->langId)) $this->langId = $defaultLang;			// 言語が選択されていないときは、デフォルト言語を設定
		
		$name = $request->trimValueOf('item_name');
		$html = $request->valueOf('item_html');		// HTMLタグを可能とする
		$key = $request->valueOf('item_key');		// 外部参照用キー
		$visible = ($request->trimValueOf('item_visible') == 'on') ? 1 : 0;		// チェックボックス
		$default = ($request->trimValueOf('item_default') == 'on') ? 1 : 0;		// チェックボックス
		
		if ($act == 'select' || $act == 'selectlang'){		// 項目選択の場合
			if ($this->contentId == 0){		// コンテンツIDが0のときは、新規追加モードにする
				$this->mode = 'add';
				$this->tmpl->addVar("_widget", "sel_item_visible", 'checked');// デフォルトで項目表示
			} else {
				if ($act == 'select') $this->langId = $defaultLang;		// 言語は一旦リセット
				
				// 登録済みのコンテンツデータを取得
				$ret = $this->db->getContentByContentId($this->contentId, $this->langId, $row);
				if ($ret){
					// 取得値を設定
					$this->tmpl->addVar("_widget", "sel_item_name", $row['cn_name']);		// 名前
					$this->tmpl->addVar("_widget", "update_user", $this->convertToDispString($row['lu_name']));	// 更新者
					$this->tmpl->addVar("_widget", "update_dt", $this->convertToDispDateTime($row['cn_create_dt']));	// 更新日時
					
					$contentText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $row['cn_html']);// アプリケーションルートを変換
					//$this->tmpl->addVar("_widget", "sel_item_html", $this->convertToDispString($row['cn_html']));	// HTML
					$this->tmpl->addVar("_widget", "sel_item_html", $this->convertToDispString($contentText));	// HTML
					$this->tmpl->addVar("_widget", "sel_item_key", $row['cn_key']);	// 外部参照用キー
				
					// 項目表示、デフォルト値チェックボックス
					$visible = '';
					if ($row['cn_visible']){
						$visible = 'checked';
					}
					$default = '';
					if ($row['cn_default']){
						$default = 'checked';
					}
					$this->tmpl->addVar("_widget", "sel_item_visible", $visible);
					$this->tmpl->addVar("_widget", "sel_item_default", $default);
				
					// 選択中のシリアル番号を更新
					$this->serialNo = $row['cn_serial'];
				} else {		// 未登録のとき
					$this->tmpl->addVar("_widget", "sel_item_visible", 'checked');// デフォルトで項目表示
										
					$this->serialNo = 0;
				}
				// 言語ありなしに関わらず設定
				$this->tmpl->addVar("_widget", "serial", $this->serialNo);			// データシリアル番号
			}
			// 選択中のコンテンツIDを設定
			//$this->tmpl->addVar("_widget", "contentid", $this->contentId);
		} else if ($act == 'add' || $act == 'addlang' || $act == 'update' || $act == 'delete' || $act == 'deleteid'){		// データ更新のとき
			if ($act == 'add' || $act == 'addlang'){		// 項目追加の場合
				// 入力チェック
				$this->checkSingleByte($this->contentId, 'コンテンツID');
				$this->checkInput($name, '名前');
						
				// エラーなしの場合は、データを登録
				if ($this->getMsgCount() == 0){
					if ($act == 'add'){
						$ret = $this->db->addContentItem(0, $this->langId, $name, $html, $visible, $default, $key, $userInfo->userId, $newSerial);
					} else {
						$ret = $this->db->addContentItem($this->contentId, $this->langId, $name, $html, $visible, $default, $key, $userInfo->userId, $newSerial);
					}
					if ($ret){
						$this->setGuidanceMsg('データを追加しました');
						// シリアル番号更新
						$this->serialNo = $newSerial;
					} else {
						$this->setAppErrorMsg('データ追加に失敗しました');
					}
				}
			} else if ($act == 'update'){		// 項目更新の場合
				// 入力チェック
				$this->checkSingleByte($this->contentId, 'コンテンツID');
				$this->checkInput($name, '名前');
				
				// エラーなしの場合は、データを更新
				if ($this->getMsgCount() == 0){
					$ret = $this->db->updateContentItem($this->serialNo, $name, $html, $visible, $default, $key, $userInfo->userId, $newSerial);
					if ($ret){
						$this->setGuidanceMsg('データを更新しました');
						// シリアル番号更新
						$this->serialNo = $newSerial;
					} else {
						$this->setAppErrorMsg('データ更新に失敗しました');
					}
				}				
			} else if ($act == 'delete'){		// 項目削除の場合
				if (empty($this->serialNo)){
					$this->setUserErrorMsg('削除項目が選択されていません');
				}
				// エラーなしの場合は、データを削除
				if ($this->getMsgCount() == 0){
					$ret = $this->db->delContentItem($this->serialNo, $userInfo->userId);
					if ($ret){		// データ削除成功のとき
						$this->setGuidanceMsg('データを削除しました');
					} else {
						$this->setAppErrorMsg('データ削除に失敗しました');
					}
				}
			} else if ($act == 'deleteid'){		// ID項目削除の場合
				if (empty($this->serialNo)){
					$this->setUserErrorMsg('削除項目が選択されていません');
				}
				// エラーなしの場合は、データを削除
				if ($this->getMsgCount() == 0){
					$ret = $this->db->delContentItemById($this->serialNo, $userInfo->userId);
					if ($ret){		// データ削除成功のとき
						$this->setGuidanceMsg('データを削除しました');
					} else {
						$this->setAppErrorMsg('データ削除に失敗しました');
					}
				}
			}
			// 設定データを再取得
			if ($act == 'add' || $act == 'addlang' ||		// 項目追加の場合
				$act == 'update'){		// 項目更新の場合
				$ret = $this->db->getContentBySerial($this->serialNo, $row);
				if ($ret){
					$this->contentId = $row['cn_id'];		// コンテンツID
					$html = $row['cn_html'];				// HTML
					$key = $row['cn_key'];					// 外部参照用キー
					$update_user = $this->convertToDispString($row['lu_name']);// 更新者
					$update_dt = $this->convertToDispDateTime($row['cn_create_dt']);
					
					// 項目表示、デフォルト値チェックボックス
					$visible = $row['cn_visible'];
					$default = $row['cn_default'];
				}
			}
			// ### 入力値を再設定 ###
			$this->tmpl->addVar("_widget", "sel_item_name", $name);		// 名前
			$this->tmpl->addVar("_widget", "sel_item_html", $html);		// HTML
			$this->tmpl->addVar("_widget", "sel_item_key", $key);		// 外部参照用キー
			$this->tmpl->addVar("_widget", "update_user", $update_user);	// 更新者
			$this->tmpl->addVar("_widget", "update_dt", $update_dt);	// 更新日時
		
			// 項目表示、項目利用可否チェックボックス
			$visibleStr = '';
			if ($visible){
				$visibleStr = 'checked';
			}
			$defaultStr = '';
			if ($default){
				$defaultStr = 'checked';
			}
			$this->tmpl->addVar("_widget", "sel_item_visible", $visibleStr);
			$this->tmpl->addVar("_widget", "sel_item_default", $defaultStr);
		
			// 選択中のシリアル番号を設定
			$this->tmpl->addVar("_widget", "serial", $this->serialNo);
			
			// 選択中のコンテンツIDを設定
			//$this->tmpl->addVar("_widget", "contentid", $this->contentId);
		} else if ($act == 'addtomenu'){			// メニューに項目を追加
			// このウィジェットがマップされているページサブIDを取得
			$subPageId = $gPageManager->getPageSubIdByWidget('index', $gEnvManager->getCurrentWidgetId());
			$sub = '';
			if (!empty($subPageId)) $sub = 'sub=' . $subPageId . '&';
			
			// URLの作成
			$url = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . '/index.php?' . $sub . 'contentid=' . $this->contentId;

			// コンテンツ名を取得
			$menutItemName = '';
			$ret = $this->db->getContentByContentId($this->contentId, $this->langId, $row);
			if ($ret){
				// 取得値を設定
				$menutItemName = $row['cn_name'];		// 名前
			}
			
			// メニュー項目追加
			$ret = $this->db->addMenuItem($this->_menuId, $defaultLang, $menutItemName, $url, self::INC_INDEX, $userInfo->userId);
			if ($ret){
				$this->setGuidanceMsg('メインメニューに項目を追加しました');
			} else {
				$this->setAppErrorMsg('メインメニューの項目追加に失敗しました');
			}
			$this->contentId = '';		// コンテンツIDはリセット

		} else if ($act == 'deleteall'){		// すべての項目を削除の場合
			$ret = $this->db->delAllContentItems($userInfo->userId);
			if ($ret){		// データ削除成功のとき
				$this->setGuidanceMsg('データを削除しました');
				
				// 新規入力を選択状態にする
				$this->contentId = 0;
		
				$this->mode = 'add';
				$this->tmpl->addVar("_widget", "sel_item_visible", 'checked');// デフォルトで項目表示
			} else {
				$this->setAppErrorMsg('データ削除に失敗しました');
			}
		} else {	// 初期画面表示のとき
			// 新規入力を選択状態にする
			$this->contentId = 0;
		
			$this->mode = 'add';
			$this->tmpl->addVar("_widget", "sel_item_visible", 'checked');// デフォルトで項目表示
		}
		
		// 入力フィールドの設定、共通項目のデータ設定
		if ($this->mode == 'add'){
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');
			
			//$this->db->getLangLoopByContentId(array($this, 'langLoop'), null);
			// デフォルト言語を最初に登録
			$this->tmpl->addVar("default_lang", "default_lang", $defaultLangName);
			$this->tmpl->setAttribute('default_lang', 'visibility', 'visible');
		} else {
			if ($this->serialNo == 0){		// 未登録データのとき
				// データ追加ボタン表示
				$this->tmpl->setAttribute('add_button', 'visibility', 'visible');
			} else {
				// データ更新、削除ボタン表示
				if ($this->langId == $defaultLang){		// デフォルト言語のとき
					$this->tmpl->setAttribute('delete_id_button', 'visibility', 'visible');// デフォルト言語のときは全削除
				} else {
					$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// デフォルト言語以外はデータ削除
				}
				$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
			}
			// 言語選択メニュー作成
			if (!empty($this->contentId)){	// コンテンツが選択されているとき
				$this->db->getAllLang(array($this, 'langLoop'));
				$this->tmpl->setAttribute('select_lang', 'visibility', 'visible');
			}
		}
		
		// コンテンツ項目リストをデフォルト言語で取得
		$this->db->getAllContentItems(array($this, 'itemListLoop'), $defaultLang);
		
		// 画面モードの設定
		$this->tmpl->addVar("_widget", "mode", $this->mode);
		
		// 選択中のコンテンツIDを設定
		$this->tmpl->addVar("_widget", "contentid", $this->contentId);
		if ($this->contentId == 0){		// コンテンツIDが0のときは新規とする
			$this->tmpl->addVar("_widget", "sel_item_id", '新規');			// コンテンツID
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// コンテンツIDが0のときは新規追加をチェック状態にする
		} else {
			$this->tmpl->addVar("_widget", "sel_item_id", $this->contentId);			// コンテンツID
		}
			
		// パスの設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "widget_sc_url", $gEnvManager->getCurrentWidgetScriptsUrl());
		$this->tmpl->addVar("_widget", "image_path", $gEnvManager->getRootUrl() . '/resource/');		// 画像の格納場所
		
		// 表示中コンテンツIDを設定
		$contIdArray = implode($this->dispContIdArray, ',');
		$this->tmpl->addVar("_widget", "cont_ids", $contIdArray);
	}
	/**
	 * メニュー項目作成画面作成
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function createMenuItem($request, &$param)
	{
		global $gEnvManager;
			
		// ユーザ情報、表示言語
		$userInfo = $gEnvManager->getCurrentUserInfo();
		$defaultLang = $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		$act = $request->trimValueOf('act');
		$this->contentId = $request->trimValueOf('contentid');		// コンテンツID
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		$this->langId = $request->trimValueOf('item_lang');				// 現在メニューで選択中の言語
		if (empty($this->langId)) $this->langId = $defaultLang;			// 言語が選択されていないときは、デフォルト言語を設定
		$menutItemName = $request->trimValueOf('menuitemname');		// メニュー項目名
		
		if ($act == 'createitem'){		// メニュー項目作成
			// 入力データエラーチェック
			$contIdArray = explode(',', $request->trimValueOf('contidarray'));
			if (!ValueCheck::isNumeric($contIdArray)){		// 数値かどうかのチェック
				$this->setAppErrorMsg('数値以外が指定されています');
			}
			$sortValues = array();	// ソート用
			for ($i = 0; $i < count($contIdArray); $i++){
				// インデックス番号を取得
				$indexNo = $request->trimValueOf('index_text' . $contIdArray[$i]);
				if (!empty($indexNo)){		// 入力ありの場合
					// 数値エラーチェック
					if (ValueCheck::isNumeric($indexNo)){
						$sortValues[$contIdArray[$i]] = intval($indexNo);
					} else {
						$this->setUserErrorMsg('数値以外が入力されています ID=' . $contIdArray[$i]);
						break;
					}
				}
			}
			if (count($sortValues) <= 0) $this->setUserErrorMsg('表示順が入力されていません');
			$this->checkInput($menutItemName, 'メニュー項目名');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){			
				// 表示順にソート
				asort($sortValues, SORT_NUMERIC);

				// ソートしたコンテンツIDを取得
				$conts = array_keys($sortValues);
				
				// URLの作成
				$url = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . '/index.php?contentid=' . implode(',', $conts);
				//$url = $gEnvManager->getRootUrl() . '/index.php?contentid=' . implode(',', $conts);

				// メニュー項目追加
				$ret = $this->db->addMenuItem($this->_menuId, $defaultLang, $menutItemName, $url, $userInfo->userId);
				if ($ret){
					$this->setGuidanceMsg('メニュー項目を追加しました');
				} else {
					$this->setAppErrorMsg('メニュー項目追加に失敗しました');
				}
			}
		} else {
		}
		// コンテンツ項目リストをデフォルト言語で取得
		$this->db->getAllContentItems(array($this, 'itemListLoop'), $defaultLang);
		
		// 表示中コンテンツIDを設定
		$contIdArray = implode($this->dispContIdArray, ',');
		$this->tmpl->addVar("_widget", "cont_ids", $contIdArray);
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
			
		// 表示状態
		$visible = '';
		if ($fetchedRow['cn_visible']){
			$visible = 'checked';
		}
		// デフォルト時の項目かどうか
		$default = '';
		if ($fetchedRow['cn_default']){
			$default = 'checked';
		}
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['cn_id']);
		$selected = '';
		if ($id == $this->contentId){
			$selected = 'checked';
		}
		
		// 対応言語を取得
		$lang = '';
		$ret = $this->db->getLangByContentId($fetchedRow['cn_id'], $rows);
		if ($ret){
			$count = count($rows);
			for ($i = 0; $i < $count; $i++){
				if ($gEnvManager->getCurrentLanguage() == 'ja'){	// 日本語の場合
					$lang .= $rows[$i]['ln_name'];
					if ($i != $count -1) $lang .= ',';
				} else {
					$lang .= $rows[$i]['ln_name_en'];
					if ($i != $count -1) $lang .= ',';
				}
			}
		}
		
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $serial,			// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['cn_id']),			// ID
			'name' => $this->convertToDispString($fetchedRow['cn_name']),		// 名前
			'index' => $this->convertToDispString($fetchedRow['cn_index']),		// インデックス
			'lang' => $lang,													// 対応言語
			'link_str' => $this->convertToDispString($fetchedRow['cn_link_url']),		// リンクURL
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['cn_create_dt']),	// 更新日時
			'visible' => $visible,											// メニュー項目表示制御
			'default' => $default,											// デフォルト項目
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->dispContIdArray[] = $fetchedRow['cn_id'];
		return true;
	}
	/**
	 * 取得した言語をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function langLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['ln_id'] == $this->langId){
			$selected = 'selected';
		}
		if ($gEnvManager->getCurrentLanguage() == 'ja'){		// 日本語表示の場合
			$name = $this->convertToDispString($fetchedRow['ln_name']);
		} else {
			$name = $this->convertToDispString($fetchedRow['ln_name_en']);
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['ln_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('lang_list', $row);
		$this->tmpl->parseTemplate('lang_list', 'a');
		return true;
	}
}
?>
