<?php
/**
 * グローバル関数
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
/**
 * ウィジェット埋め込み
 *
 * テンプレートから固定で直接ウィジェットを呼び出すための関数
 *
 * @param string $widgetId		ウィジェットID
 * @return 						なし
 */
function m3AnchorWidget($widgetId)
{
	global $gEnvManager;

	// ウィジェットのindex.phpファイルのパスを作成
	$widgetIndexFile = $gEnvManager->getWidgetsPath() . '/' . $widgetId . '/index.php';
	if (file_exists($widgetIndexFile)){
		// 作業中のウィジェットIDを設定
		$gEnvManager->setCurrentWidgetId($widgetId);
	
		// ウィジェットを実行
		// ウィジェットの呼び出しは、複数回存在する可能性があるのでrequire_once()で呼び出さない
		require($widgetIndexFile);

		// 作業中のウィジェットIDを解除
		$gEnvManager->setCurrentWidgetId('');
		
		echo '<!-- ' . time() . ' -->' . M3_NL;
	} else {
		echo 'widget not found error: ' . $widgetId;
	}
}
/**
 * ポジションタグ設定
 *
 * テンプレートにウィジェット表示ポジションタグを設定する
 *
 * @param string $positionId	表示位置ポジションID
 * @return 						なし
 */
function m3AnchorPosition($positionId)
{
}
/**
 * 配列を挿入する
 *
 * 配列を保持する配列の指定位置に配列を挿入する
 *
 * @param array $srcArray		挿入先の配列
 * @param array $insertArray	挿入する配列
 * @param int $position			挿入位置。-1のときは最後に追加
 * @return array				挿入後の配列
 */
function array_insert($srcArray, $insertArray, $position = -1)
{
    // 引数$arrayが配列でない場合は空配列を返す
    if (!is_array($srcArray)) return array();
	
	// 挿入位置を修正
	$position = ($position == -1) ? (count($srcArray)) : $position;
	
    // 挿入する位置～末尾まで
    $lastArray = array_splice($srcArray, $position);
	
    // 先頭～挿入前位置までの配列に、挿入する値を追加
    array_push($srcArray, $insertArray);
	
    // 配列を結合
    return array_merge($srcArray, $lastArray);
}
/**
 * パスワードを生成する
 *
 * @param int     $len		文字列長
 * @param string  $str		パスワード生成のために使用する文字
 * @return string			作成したパスワード
 */
function makePassword($len, $str = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-+#%?!$@*=')
{
	$l = strlen($str) - 1;
	$pwd = "";
	for ($i = 0; $i < $len; $i++){
		// 一度使用した文字は再度使わない
		$n = (int)mt_rand(0, $l);
		$newChar = substr($str, $n, 1);
		$str = substr($str, 0, $n) . substr($str, $n + 1);
		$pwd .= $newChar;
		$l--;
	}
	return $pwd;
}
/**
 * メールアドレスの取り出し
 *
 * 文字列の中から「<」「>」で括られたメールアドレスと名前を取得する
 * 例) 名前<name@sample.domain.com> →　「名前」「name@sample.domain.com」
 *
 * @param string  $str		メールアドレスを取得する対象文字列
 * @param string  $mail		メールアドレス
 * @param string  $name		メールアドレス以外の文字列
 * @return bool				true=取得、false=取得失敗
 */
function separateMailAddress($str, &$mail, &$name)
{
	$pattern = "/<.*>/";		// メールアドレス検索パターン
	$ret = preg_match($pattern, $str, $matches);
	if ($ret == 1){		// メールアドレスが見つかったとき
		$mail = trim($matches[0], ' <>');
		$name = preg_replace($pattern, '', $str);
		return true;
	} else {
		return false;
	}
}
/**
 * メールアドレス形式かどうかのチェック
 *
 * @param string  $str		対象文字列
 * @return bool				true=メールアドレス形式、false=不備
 */
function isMailAddress($str)
{
	return preg_match("/[\w\d\-\.]+\@[\w\d\-\.]+/", $str);
}
/**
 * CSVファイルの切り出し
 *
 * ファイルポインタから行を取得し、解析したデータを配列で返す
 *
 * @param resource  $fp		ファイルポインタ
 * @return array			解析後のデータ
 */
function fgetByCsv(&$fp)
{
	if (feof($fp)) return false;

	$csv = '';
	while (!feof($fp)){
	    $csv .= mb_convert_encoding(fgets($fp), 'UTF-8', 'SJIS-win');
	    if (((preg_match_all('/"/', $csv, $matches)) % 2) == 0) break;
	}

	$values = array();
	$temp = preg_replace('/(?:\x0D\x0A|[\x0D\x0A])?$/', ',', $csv, 1);
	preg_match_all('/("[^"]*(?:""[^"]*)*"|[^,]*),/', $temp, $matches);

	for ($i = 0; $i < count($matches[1]) ; $i++){
	    if (preg_match('/^"(.*)"$/s', $matches[1][$i], $m)){
	        $matches[1][$i] = preg_replace('/""/', '"', $m[1]);
	    }
	    $values[] = $matches[1][$i];
	}
	return $values;
}
/**
 * CSVファイルをタブで切り出し
 *
 * ファイルポインタから行を取得し、解析したデータを配列で返す
 *
 * @param resource  $fp		ファイルポインタ
 * @return array			解析後のデータ
 */
function fgetByCsvWithTab(&$fp)
{
	if (feof($fp)) return false;
	
	// UTF-8に変換
	$csv = '';
	while (!feof($fp)){		// 空行は読み飛ばす
	    $csv = mb_convert_encoding(fgets($fp), 'UTF-8', 'SJIS-win');
		$checkCsv = trim($csv);
		if (!empty($checkCsv)) break;
	}
	if (feof($fp)) return false;
	
	$values = explode("\t", $csv);
	return $values;
}
/**
 * ディレクトリの削除
 *
 * @param string $dirname			ディレクトリのパス
 * @return bool						true=削除完了、false=削除失敗
 */
function rmDirectory($dirname)
{
	$ret = false;
	if ($dirHandle = opendir($dirname)){
		chdir($dirname);
		while ($file = readdir($dirHandle)) {
			if ($file == '.' || $file == '..') continue;
			if (is_dir($file)) rmDirectory($file);
			else unlink($file);
		}
		chdir('..');
		$ret = rmdir($dirname);
		closedir($dirHandle);
	}
	return $ret;
}
/**
 * ユーザカスタマイズ用パラメータの解析
 *
 * フォーマット　key1:value1;key2:value2;key3:value3;
 *
 * @param string $src			解析対象
 * @return array $dest			解析後の配列(メンバーkye,valueを持つオブジェクトの1次配列が返る)
 */
function parseUserCustomParam($src)
{
	$dest = array();
	$parsedArray = explode(';', $src);
	for ($i = 0; $i < count($parsedArray); $i++){
		list($key, $value) = explode(':', $parsedArray[$i]);
		$obj = new stdClass;
		$obj->key = $key;
		$obj->value = $value;
		$dest[] = $obj;
	}
	return $dest;
}
?>
