# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1811
## - Date: 2019-01-04
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1811) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

from gluon.html import *


def d__elementset(dbm, classid=1):
    """
    要素セット辞書を返す
    {
        '*class_id': {
            'group': [
                *class_element_id
            ]
            ,'keyset': [
                *class_element_definition_name
            ]
            ,'nameset': {
                '*class_element_definition_name': {
                    'id':     *class_element_id
                    'title':   *class_element_name (title)
                }
            }
        }
    }
    """

    # 要素セット辞書
    d_elements = {}
    for row in dbm(dbm.mr_classes).select(orderby=[dbm.mr_classes.mr_order,dbm.mr_classes.id]):
        # クラス要素
        rows = dbm(
                dbm.mr_class_elements.mr_class_id == row.id
            ).select(
                orderby=[
                    dbm.mr_class_elements.mr_order
                    ,dbm.mr_class_elements.id
                ]
            )

        # 定義名をキーとする要素名と要素IDの辞書
        d_meta = {}
        for r in rows:
            if r.mr_definition_name is not None and not r.mr_definition_name in d_meta:
                # set first element
                d_meta[r.mr_definition_name] = dict(id = r.id, title = r.mr_title)

        d_elements[row.id] = dict(
            target = row.mr_target
            ,title = row.mr_title
            ,description = row.mr_description
            ,group = [r.id for r in rows] #クラス要素IDの配列
            ,keyset = [r.mr_definition_name for r in rows]
            ,nameset = d_meta
        )
    try:
        return d_elements if classid == 0 else d_elements[classid]
    except:
        return None




def l_d_sections(dbm, pageid, a_offset=0, a_limit=20):
    """
    List of sections
    """

    title = dbm.mr_pages[pageid]['mr_title'] or None

    # コンテナ
    l_d = []

    rows = dbm((dbm.mr_sections.mr_open == True)
                & (dbm.mr_sections.mr_page_id == pageid)
            ).select(
                orderby=[dbm.mr_sections.mr_order,~dbm.mr_sections.id]
            )

    for row in rows:

        # 各リソースが依存するクラス要素セットの取得
        d_elements = d__elementset(dbm, row.mr_class_id)

        # 各リソースのアイテムの取得
        rows2 = dbm(
                    (dbm.mr_section_items.mr_section_id == row.id)
                    & dbm.mr_section_items.mr_class_element_id.belongs(d_elements['group'])
                    #& (dbm.mr_section_items.mr_open == True)
                ).select(
                    #left=dbm.mr_class_elements.on(dbm.mr_section_items.mr_class_element_id == dbm.mr_class_elements.id)
                )

        # 定義名の取得
        d_d = {}
        d_d['subid'] = row.id
        d_d['ids'] = (0, 0, 0)
        d_d['keyset'] = d_elements['keyset']

        for ky in d_elements['keyset']:
            if ky in ('creator',):
                d_d[ky] = [dict(label='Author', value=None)]
            elif ky not in ('date'):
                d_d[ky] = [dict(label='Date', value=None)]
            elif ky not in ('created','updated'):
                d_d[ky] = []

        for r2 in rows2:
            for ky in d_elements['keyset']:
                if r2.mr_class_element_id == d_elements['nameset'][ky]['id']:
                    if ky in ('creator','date'):
                        d_d[ky] = [dict(
                                    label=d_elements['nameset'][ky]['title']
                                    ,value=r2.mr_text
                                )]
                    elif ky in ('created','updated'):
                        d_d[ky] = dict(
                                    label=d_elements['nameset'][ky]['title']
                                    ,value=r2.mr_text
                                )
                    else:
                        d_d[ky].append(
                                    dict(
                                        label=d_elements['nameset'][ky]['title']
                                        ,value=r2.mr_text
                                    )
                                )
                    break

        l_d.append(d_d)

    return dict(title=title, array=l_d)




def l_d_resources(dbm, collid, q=[], a_offset=0, a_limit=20):
    """
    List of resources
    """

    title = None

    if type(q) is not list:
        q = []

    # コンテナ
    l_d = []

    if collid > 1:

        rows = dbm((dbm.mr_resources.mr_open==True)
                    & dbm.mr_resources.mr_collection_ids.contains(collid)
                ).select(
                    orderby=[dbm.mr_resources.mr_order,dbm.mr_resources.id]
                )
        title = dbm.mr_collections[collid]['mr_title'] or None
    else:
        rows = dbm((dbm.mr_resources.mr_open==True)
                    & (dbm.mr_resources.id>0)
                ).select(
                    orderby=[dbm.mr_resources.mr_order,dbm.mr_resources.id]
                )

    for row in rows:

        d_elements = d__elementset(dbm, row.mr_class_id)

        # 各リソースのアイテムの取得
        count2 = dbm((dbm.mr_resource_items.mr_open == True)
                    & (dbm.mr_resource_items.mr_resource_id == row.id)
                    & dbm.mr_resource_items.mr_text.contains(q, all=True)
                ).count()

        if count2 == 0: continue

        rows2 = dbm((dbm.mr_resource_items.mr_open == True)
                    & (dbm.mr_resource_items.mr_resource_id == row.id)
                    & dbm.mr_resource_items.mr_class_element_id.belongs(d_elements['group'])
                    #& dbm.mr_resource_items.mr_text.contains(q, all=True)
                ).select(
                    left=dbm.mr_class_elements.on(dbm.mr_resource_items.mr_class_element_id == dbm.mr_class_elements.id)
                )

        # 定義名の取得
        d_d = {}
        d_d['subid'] = row.id
        d_d['ids'] = (row.id, 0, 0)
        d_d['role'] = 'resource'

        d_d['keyset'] = d_elements['keyset']
        d_d['contains'] = set([])
        d_d['title'] = dict(label=None, value=None)
        d_d['description'] = dict(label=None, value=None)
        for ky in d_elements['keyset']:
            d_d[ky] = dict(label=d_elements['nameset'][ky]['title'], value=None)
            for r2 in rows2:
                if r2.mr_resource_items.mr_class_element_id == d_elements['nameset'][ky]['id']:
                    d_d[ky] = dict(
                                    label=d_elements['nameset'][ky]['title']
                                    ,value=r2.mr_resource_items.mr_text
                                )
                    break

        d_d['files'] = get_l_d_files(dbm, row.id, d_d['contains'])
        d_d['annotes'] = get_l_d_annotes(dbm, row.id)

        l_d.append(d_d)

    return dict(title=title, array=l_d)




def l_d_resource_items(dbm, resourceid, a_offset=0, a_limit=20):
    """
    List of resource items
    """

    # コンテナ
    l_d = []

    # このリソース
    row_resource = dbm.mr_resources[resourceid]

    if row_resource:

        d_elements = d__elementset(dbm, row_resource.mr_class_id)

        # このリソースのアイテムの取得
        rows2 = dbm((dbm.mr_resource_items.mr_open == True)
                    & (dbm.mr_resource_items.mr_resource_id == row_resource.id)
                    & dbm.mr_resource_items.mr_class_element_id.belongs(d_elements['group'])
                ).select(
                    left=dbm.mr_class_elements.on(dbm.mr_resource_items.mr_class_element_id == dbm.mr_class_elements.id)
                )

        # 定義名の取得
        d_d = {}
        d_d['subid'] = row_resource.id
        d_d['ids'] = (resourceid, 0, 0)
        d_d['role'] = 'resource'

        d_d['keyset'] = d_elements['keyset']
        d_d['contains'] = set([])
        d_d['title'] = dict(label=None, value=None)
        d_d['description'] = dict(label=None, value=None)
        for ky in d_elements['keyset']:
            d_d[ky] = dict(label=d_elements['nameset'][ky]['title'], value=None)
            for r2 in rows2:
                if r2.mr_resource_items.mr_class_element_id == d_elements['nameset'][ky]['id']:
                    d_d[ky] = dict(
                                    label=d_elements['nameset'][ky]['title']
                                    ,value=r2.mr_resource_items.mr_text
                                )
                    break

        d_d['files'] = get_l_d_files(dbm, row_resource.id, d_d['contains'])
        d_d['annotes'] = get_l_d_annotes(dbm, row_resource.id)

        l_d.append(d_d)

    return dict(title=d_d['title']['value'] or None ,array=l_d)


def l_d_file(dbm, fileid, a_offset=0, a_limit=20):
    """
    Data of a file
    """

    # コンテナ
    l_d = []

    # このアノテーション
    row = dbm.mr_files[fileid]

    if row:

        # このファイルのリソースの取得
        r_resource = dbm.mr_resources[row.mr_resource_id]

        # 定義名の取得
        d_d = {}
        d_d['subid'] = row.id
        d_d['ids'] = (r_resource.id, row.id, 0)
        d_d['role'] = 'file'

        d_d['keyset'] = []
        d_d['contains'] = set([])
        d_d['title'] = dict(label='title', value=row.mr_title)
        d_d['description'] = dict(label='descriptiont', value=row.mr_description)

        d_d['files'] = [__get_l_d_file(row, d_d['contains'])]
        d_d['annotes'] = get_l_d_annotes(dbm, r_resource.id)

        l_d.append(d_d)

    return dict(title=d_d['title']['value'] or '' ,array=l_d)


def l_d_annote(dbm, annoteid, a_offset=0, a_limit=20):
    """
    Data of annotation
    """

    # コンテナ
    l_d = []

    # このアノテーション
    row = dbm.mr_annotes[annoteid]

    if row:

        # このアノテーションのリソースの取得
        r_resource = dbm.mr_resources[row.mr_resource_id]

        # このアノテーションのファイルの取得
        r_file = dbm.mr_files[row.mr_file_id]

        # 定義名の取得
        d_d = {}
        d_d['subid'] = row.id
        d_d['ids'] = (row.mr_resource_id, r_file.id, row.id)
        d_d['role'] = 'annote'

        d_d['keyset'] = []
        d_d['contains'] = set([])
        d_d['title'] = dict(label='slug', value=row.mr_slug)
        d_d['description'] = dict(label='text', value=row.mr_text)

        d_d['files'] = [__get_l_d_file(r_file, d_d['contains'])]
        d_d['annotes'] = []

        d_d['area'] = dict(label='area', value=row.mr_annote_area)
        d_d['data'] = dict(label='data', value=row.mr_annote_data)
        d_d['rotation'] = dict(label='rotation', value=row.mr_annote_rotation)

        l_d.append(d_d)

    return dict(title=d_d['title']['value'] or None ,array=l_d)




def __get_l_d_file(r, l_contains, a_offset=0, a_limit=20):
    """
    Data of file
    """

    d_f = {}

    if r:

            d_f['subid'] = r.id
            #d_f['ids'] = (0, r.id, 0)
            d_f['role'] = 'file'

            # Metadata
            d_f['title'] = r.mr_title
            if len(r.mr_title) == 0:
                d_f['title'] = r.mr_original_file_name

            # Thumbnail
            d_f['thumbnail'] = XML('&nbsp;')
            if r.mr_ims is not None and '.jpg' in r.mr_ims:
                d_f['thumbnail'] = [r.mr_subfolder, r.mr_ims]

            # Snap image
            d_f['snapimage'] = XML('&nbsp;')
            if r.mr_imm is not None and '.jpg' in r.mr_imm:
                d_f['snapimage'] = [r.mr_subfolder, r.mr_imm]

            # Link
            d_f['href'] = [r.mr_subfolder,r.mr_iml,r.mr_public_file_format]
            if r.mr_public_file_format == 'pdf':
                d_f['href'] = [r.mr_subfolder, r.mr_iml, r.mr_public_file_format]

            # Other matadata
            d_f['identifier'] = r.mr_identifier
            d_f['width'] = r.mr_imlw
            d_f['height'] = r.mr_imlh
            d_f['format'] = r.mr_public_file_format
            #d_f['date'] = r.mr_create_date
            #d_f['note'] = r.mr_note

            l_contains.add(d_f['format'])

    return d_f




def get_l_d_files(dbm, resourceid, l_contains, a_offset=0, a_limit=20):
    """
    List of files
    """

    # リソースに関連するファイルのコンテナ
    l_d_f = []

    rows = dbm(
                (dbm.mr_files.mr_resource_id == resourceid)
                & (dbm.mr_files.mr_open == True)
            ).select(
                orderby=[dbm.mr_files.mr_order,~dbm.mr_files.id]
            )

    if rows:

        for r in rows:

            d_f = __get_l_d_file(r, l_contains)
            d_f['ids'] = (resourceid, r.id, 0)

            l_d_f.append(d_f)

    return l_d_f




def get_l_d_annotes(dbm, resourceid, a_offset=0, a_limit=20):
    """
    List of annotations
    """

    # リソースに関連するアノテーションのコンテナ
    l_d_a = []

    rows = dbm(
                (dbm.mr_annotes.mr_resource_id == resourceid)
                & (dbm.mr_annotes.mr_open == True)
            ).select(
                orderby=[dbm.mr_annotes.mr_order,~dbm.mr_annotes.id]
            )

    if rows:

        for r in rows:

            # アノテーションがあるファイル
            rf = dbm.mr_files[r.mr_file_id]

            d_a = {}

            d_a['subid'] = r.id
            d_a['ids'] = (resourceid, rf.id, r.id)
            d_a['role'] = 'annote'

            # Metadata

            if len(r.mr_text) > 0:
                d_a['title'] = r.mr_text[:20]
            elif len(r.mr_slug) > 0:
                d_a['title'] = r.mr_slug[:20]
            else:
                d_a['title'] = '(Undefined)'

            # Thumbnail
            d_a['thumbnail'] = XML('&nbsp;')
            if rf.mr_ims is not None and '.jpg' in rf.mr_ims:
                d_a['thumbnail'] = [rf.mr_subfolder, rf.mr_ims]

            # Snap image
            d_a['snapimage'] = XML('&nbsp;')
            if rf.mr_imm is not None and '.jpg' in rf.mr_imm:
                d_a['snapimage'] = [rf.mr_subfolder, rf.mr_imm]

            # Link
            d_a['href'] = [rf.mr_subfolder,rf.mr_iml,rf.mr_public_file_format]
            #if rf.mr_public_file_format == 'pdf':
            #    d_a['href'] = [rf.mr_subfolder, rf.mr_iml, rf.mr_public_file_format]

            # Other matadata
            d_a['identifier'] = rf.mr_identifier
            d_a['width'] = rf.mr_imlw
            d_a['height'] = rf.mr_imlh
            d_a['format'] = rf.mr_public_file_format

            d_a['annotearea'] = r.mr_annote_area    # list
            d_a['annotetype'] = r.mr_annote_type    # str
            d_a['annoterotation'] = r.mr_annote_rotation    # double
            d_a['annotedata'] = r.mr_annote_data    # list
            #d_a['date'] = rf.mr_create_date
            #d_a['note'] = rf.mr_note

            l_d_a.append(d_a)

    return l_d_a
