# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1811
## - Date: 2019-01-04
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1811) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os
import io
import datetime
import re
import json
from gluon.sanitizer import sanitize

mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])
mr_helper = local_import('mr_helper', reload=MR_CONF['RELOAD'])


# ========================================
# Main controllers
# 2018-11
# ========================================

def index():
    """
    トップ
    2018-11
    """
    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページセクション一覧
    da = mr_datahelper.l_d_sections(dbm, pageid)

    # ページがpageidであるページセクション（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_dom in da['array']:

        dom_section = TAG.section(
                        DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_dom['description']]
                            ,_class='m-div-text'
                        )
                        ,_class='m-page-section m-index-section'
                    )
        dom_div.append(dom_section)

    # メニュー索引の作成
    dom_menu = __get_menu()

    return dict(linemenu=dom_menu, title=title, dom=dom_div)


def page():
    """
    ページ
    2018-11
    """
    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページセクション一覧
    da = mr_datahelper.l_d_sections(dbm, pageid)

    # ページがpageidであるページセクション（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_dom in da['array']:

        dom_section = TAG.section(
                        *[H2(mr_helper.__helper_br(v['value'])) for v in d_dom['title']]
                        ,DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_dom['description']]
                            ,_class='m-div-text'
                        )
                        ,DIV(
                            SPAN(T(d_dom['date'][0]['label']),': ',XML(d_dom['date'][0]['value']) or XML('&mdash;'))
                            ,XML('&nbsp'),'|',XML('&nbsp;'),SPAN(T(d_dom['creator'][0]['label']),': ',XML(d_dom['creator'][0]['value']) or XML('&mdash;'))
                            ,_class='m-div-info'
                        )
                        ,_class='m-page-section'
                    )
        dom_div.append(dom_section)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div)


def __form_search():
    """
    検索フォーム（最小）
    2018-11
    """
    form = FORM(
                DIV(
                    DIV(
                        INPUT(
                            _type='search'
                            ,_placeholder=T('Search words')
                            ,_name='q'
                            ,_class='form-control'
                        )
                        ,_class='col col-8'
                    )
                    ,DIV(
                        TAG.button(
                            I(_class='fa fa-search')
                            ,T('Search')
                            ,_type='submit'
                            ,_name='dosearch'
                            ,_class='btn btn-primary'
                        )
                        ,_class='col col-4'
                    )
                    ,_class='formgroup row m-search-box'
                )
            )

    return form


def list():
    """
    リソース・リスト（コレクション）
    2018-11
    """
    # 引数（コレクションID）の取得
    collid = 0  #デフォルト
    if len(request.args) > 0:
        collid = request.args(0, cast=int) or 0

    l_query = []

    form = __form_search()

    if form.accepts(request, session, keepvalues=True):
        #response.flash = T('form accepted')
        l_query = sanitize(form.vars.get('q')).split()

    elif form.errors:
        response.flash = T('form has errors')
    else:
        #response.flash = T('please fill the form')
        pass

    # リソース一覧
    da = mr_datahelper.l_d_resources(dbm, collid, l_query)

    session.imgs = {}

    # コレクションがcollidであるリソース（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_dom in da['array']:

        dom_resource = DIV(
                        DIV(
                            __get_dom_thumbnail_files(session, d_dom)
                            ,_class='col'
                        )
                        ,DIV(
                            H4(A(d_dom['title']['value']
                                ,_href=URL('item',args=[d_dom['subid']])
                                )
                            )
                            ,DIV(
                                P(mr_helper.__helper_br(d_dom['description']['value']),_class='col col-12')
                                ,_class='row'
                            )
                            ,_class='col'
                        )
                        ,_class='row m-resource-block'
                    )

        dom_div.append(dom_resource)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div, form=form)


def item():
    """
    リソース・アイテム
    2018-11
    """
    # 引数（リソースID）の取得
    resourceid = 1  #デフォルト
    if len(request.args) > 0:
        resourceid = request.args(0, cast=int) or 1

    # リソースアイテム
    da = mr_datahelper.l_d_resource_items(dbm, resourceid)

    session.imgs = {}

    # リソースがresourceidであるリソースアイテム（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_dom in da['array']:

        dom_resource = DIV(
                        H2(d_dom['title']['value'])
                        ,DIV(
                            P(mr_helper.__helper_br(d_dom['description']['value']),_class='col col-12')
                            ,TABLE(*[
                                TR(TD(d_dom[ky]['label'], _class='m-label'),TD(mr_helper.__helper_br(d_dom[ky]['value']))) for ky in d_dom['keyset']
                                if ky not in ('title','description') and d_dom[ky]['value'] is not None
                            ],_class='col col-12')
                            ,_class='row'
                        )
                        ,__get_dom_image_annotes(session, d_dom, ['area'], True)
                        ,_class='m-resource-item'
                    )
        dom_div.append(dom_resource)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div)


def viewer():
    """
    画像表示
    2018-11
    """
    var_a_id = 0

    var_target = tuple(request.args)
    (var_r_id,var_f_id,var_a_id) = session.imgs[var_target]

    var_manifest = None

    var_folder = None
    var_name = None
    var_format = None

    var_on_annote = False

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            #IIIF Manifest
            var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        if 'annote' in request.args:
            var_on_annote = True

    # プレビュー・リスト（このバージョンではアノテーション）
    da = mr_datahelper.l_d_file(dbm, var_f_id)

    preview = UL()

    for d in da['array'][0]['annotes']:
        if not var_on_annote and d['annotetype'] == 'rect' and d['ids'][1] == var_f_id:

            li = LI(
                    SPAN(
                        d['title']
                    )
                    ,_id='n%d' % d['subid']
                    ,_class=''
                    ,**{ '_data-rect': ','.join( [str(v) for v in d['annotedata']] ) }
                )
            preview.append(li)

    return dict(vmanifest=var_manifest, vfolder=var_folder, vname=var_name, vformat=var_format, preview=preview, idset=session.imgs[var_target])


# ========================================
# IIIF Manifest
# 2018-11
# ========================================

def iiif():
    """
    IIIF Presentation API 2.1
    2018-11
    """
    # 引数（リソースID/アノートID）の取得
    resourceid = 1  # Default
    fileid = 0  # Default
    annoteid = 0  # Default
    req_api_type = 'manifest.json'
    if len(request.args) > 1:
        domain = sanitize(request.args(0))
        if domain == 'annote':
            annoteid = request.args(1, cast=int) or 0
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'file':
            fileid = request.args(1, cast=int) or 0
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'resource':
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        else:
            domain = 'resource'
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))

    if req_api_type.startswith('manifest'):

        if domain == 'annote':
            da = mr_datahelper.l_d_annote(dbm, annoteid)
        elif domain == 'file':
            da = mr_datahelper.l_d_file(dbm, fileid)
        else:
            # get Dataset of Resource-Items
            da = mr_datahelper.l_d_resource_items(dbm, resourceid)

        # get Manifest JSON
        json_ld = __get_iiif_manifest(da['array'])

        return response.json(json_ld)

    elif req_api_type.startswith('annotationlist'):

        da = mr_datahelper.l_d_file(dbm, fileid)

        # get Annotation List JSON
        json_ld = __get_iiif_annotationlist(da['array'])

        return response.json(json_ld)

    else:
        return response.json({})


def __get_iiif_manifest(array):
    """
    Construction of IIIF Presentation API 2.1
    2018-11
    """
    # Context
    d_context = {
                    "@context": "http://iiif.io/api/presentation/2/context.json"
                    ,"@type": "sc:Manifest"
                    ,"@id": "%s/iiif/%s/manifest.json" % (MR_CONF['SERVER_URL'],'test')
                    ,"label": "test"
                    ,"sequences":[
                        {
                            "@type": "sc:Sequence"
                            ,"canvases": [
                                {
                                    "@type": "sc:Canvas"
                                }
                            ]
                        }
                    ]
                 }

    if len(array) == 1:

        d_d = array[0]

        l_d_metadata = []
        for ky in d_d:
            if ky and (not ky in ('description','title','keyset','subid','files','annotes','ids','contains','role')):
                l_d_metadata.append(d_d[ky])

        if 'role' in d_d:
            if d_d['role'] == 'annote':
                d_context['@id'] = "%s/default/iiif/annote/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))
            elif d_d['role'] == 'file':
                d_context['@id'] = "%s/default/iiif/file/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))
        else:
            d_context['@id'] = "%s/default/iiif/resource/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))

        d_context['label'] = d_d['title']['value'] or ''
        d_context['description'] = d_d['description']['value'] or ''
        d_context['metadata'] = l_d_metadata

        # Sequences
        d_context['sequences'] = []
        for i,r in enumerate(d_d['files']):
            d_sequense = {"@type": "sc:Sequence"}
            d_context['sequences'].append(d_sequense)

            # Canvases
            d_sequense['canvases'] = []
            if r:
                d_canvas = {"@type": "sc:Canvas"}
                d_sequense['canvases'].append(d_canvas)

                canves_id = "%s/default/iiif/%s/%s/canvas/image%s" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']),str(i+1))

                d_canvas['@id'] = canves_id
                d_canvas['label'] = r['title']

                if 'area' in d_d:
                    d_canvas['width'] = d_d['area']['value'][2]
                    d_canvas['height'] = d_d['area']['value'][3]
                else:
                    d_canvas['width'] = r['width']
                    d_canvas['height'] = r['height']

                # get default @id
                default_id = ''
                if ('format' in r) and (r['format'] in ('tif','jp2')):
                    default_id = '%s%s.%s/full/full/0/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'])
                else:
                #elif ('format' in r) and (r['format'] in ('jpg')):
                    default_id = "%s/resources/%s.%s" % (MR_CONF['SERVER_URL'],'/'.join(r['href'][:-1]),r['format'])

                # get image @id
                resource_id = ''
                if ('format' in r) and (r['format'] in ('tif','jp2')):
                    if 'area' in d_d:
                        resource_id = '%s%s.%s/%s/full/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'],','.join([str(v) for v in d_d['area']['value']]),int(d_d['rotation']['value']))
                    else:
                        resource_id = '%s%s.%s/full/full/0/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'])
                elif ('format' in r) and (r['format'] in ('fzp','fzp3','dzi','zoomify')):
                    resource_id = "%s/resources/%s" % (MR_CONF['SERVER_URL'],'/'.join(r['snapimage']))
                else:
                #elif ('format' in r) and (r['format'] in ('jpg')):
                    resource_id = "%s/resources/%s.%s" % (MR_CONF['SERVER_URL'],'/'.join(r['href'][:-1]),r['format'])

                # get thumbnail image @id
                thumbnail_id = ''
                if ('format' in r) and (r['format'] in ('tif','jp2')):
                    if 'area' in d_d:
                        thumbnail_id = '%s%s.%s/%s/%d,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'],','.join([str(v) for v in d_d['area']['value']]),MR_CONF['IMG_THUMBNAIL_SIZE'],int(d_d['rotation']['value']))
                    else:
                        thumbnail_id = '%s%s.%s/full/%d,/0/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'],MR_CONF['IMG_THUMBNAIL_SIZE'])

                elif ('format' in r) and (r['format'] in ('fzp','fzp3','dzi','zoomify')):
                    thumbnail_id = "%s/resources/%s" % (MR_CONF['SERVER_URL'],'/'.join(r['thumbnail']))

                elif ('format' in r) and (r['format'] in ('jpg')):
                    thumbnail_id = "%s/resources/%s" % (MR_CONF['SERVER_URL'],'/'.join(r['thumbnail']))

                # Thumbnail
                d_canvas['thumbnail'] = { "@type": "dctypes:Image"
                            ,"@id": thumbnail_id
                            ,"format": "image/jpeg"
                            }
                # Images
                d_canvas['images'] = []
                if r:
                    d_image = {"@type": "oa:Annotation"
                            ,"motivation": "sc:painting"
                            ,"on": canves_id
                            }
                    d_canvas['images'].append(d_image)

                    # Resource
                    d_resource = {"@type": "dctypes:Image"
                            ,"@id": resource_id
                            ,"format": "image/jpeg"
                            }
                    d_image['resource'] = d_resource;

                    if ('format' in r) and (r['format'] in ('tif','jp2')):

                        if 'area' in d_d:
                            # default
                            d_default = {"@type": "dctypes:Image"
                                ,"@id": default_id
                                }
                            d_resource['default'] = d_default

                            # Service
                            d_service = {"@context": "http://iiif.io/api/image/2/context.json"
                                ,"@id": '%s%s.%s' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['href'][-1])
                                }
                            d_default['service'] = d_service

                        else:
                            # Service
                            d_service = {"@context":    "http://iiif.io/api/image/2/context.json"
                                ,"@id": '%s%s.%s' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['href'][-1])
                                }
                            d_resource['service'] = d_service

                    if 'area' in d_d:
                        # Selector
                        d_selector = {
                            "@context": "http://iiif.io/api/presentation/2/context.json"
                            ,"@type": "iiif:ImageApiSelector"
                            ,"region": "%s" % ','.join([str(v) for v in d_d['area']['value']])
                            }
                        d_image['selector'] = d_selector

                # アノテーションの場合は補正
                if d_d['role'] == 'annote':
                    file_subid = d_d['files'][0]['subid']
                else:
                    file_subid = d_d['subid']

                # Annotation link
                d_canvas['otherContent'] = []
                d_annote = {"@type": "sc:AnnotationList"
                            ,"@id": "%s/default/iiif/file/%s/annotationlist.json" % (MR_CONF['SERVER_URL'],str(file_subid))
                            }
                if d_d['role'] == 'file':
                    d_canvas['otherContent'].append(d_annote)

    return d_context


def __get_iiif_annotationlist(array):
    """
    Construction of IIIF Presentation API 2.1
    2018-11
    """
    # Context
    d_context = {
                    "@context": "http://iiif.io/api/presentation/2/context.json"
                    ,"@type": "sc:AnnotationList"
                    ,"@id": "%s/iiif/%s/annotationlist.json" % (MR_CONF['SERVER_URL'],'test')
                    ,"resources":[
                        {
                            "@type": "oa:Annotation"
                            ,"motivation": "sc:painting"
                            ,"resource": [
                                {
                                    "@type": "cnt:ContentAsText"
                                    ,"chars": ""
                                    ,"format": "text/plain"
                                    ,"language": "ja"
                                }
                            ]
                            ,"on": {
                                "@type": "oa:SpecificResource"
                                ,"full": "%s/iiif/%s/canvas/image" % (MR_CONF['SERVER_URL'],'test')
                                ,"selector": {
                                    "@type": "oa:FragmentSelector"
                                    ,"value": "xywh=0,0,0,0"
                                }
                                ,"within": {
                                    "@id": "%s/iiif/%s/manifest.json" % (MR_CONF['SERVER_URL'],'test')
                                    ,"@type": "sc:Manifest"
                                }
                            }
                        }
                    ]
                 }

    if len(array) == 1:

        d_d = array[0]

        l_d_metadata = []
        for ky in d_d:
            if ky and (not ky in ('description','title','keyset','subid','files')):
                l_d_metadata.append(d_d[ky])

        d_context['@id'] = "%s/default/iiif/%s/%s/annotationlist.json" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']))

        d_manifest = "%s/default/iiif/%s/%s/manifest.json" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']))

        d_full = "%s/default/iiif/%s/%s/canvas/image1" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']))

        d_context['resources'] = []
        for i,r in enumerate(d_d['annotes']):
            if r['annotetype'] == 'area':
                continue

            if r:
                # Canvases
                d_annote = {
                    "@type": "oa:Annotation"
                    ,"motivation": "sc:painting"
                    ,"resource": {
                        "@type": "cnt:ContentAsText"
                        ,"chars": r['title'] or ''
                        ,"format": "text/plain"
                        ,"language": "ja"
                    }
                    ,"on": {
                        "@type": "oa:SpecificResource"
                        ,"full": d_full
                        ,"selector": {
                            "@type": "oa:FragmentSelector"
                            ,"value": "xywh=%s" % ','.join([str(v) for v in r['annotedata']])
                        }
                        ,"within": {
                            "@type": "sc:Manifest"
                            ,"@id": d_manifest
                        }
                    }
                }
                d_context['resources'].append(d_annote)

    return d_context


# ========================================
# Menu
# 2018-11
# ========================================

def __get_menu():
    """
    Menuを取得する
    2018-11
    """
    # トップのメニュー索引の作成
    dom_div = DIV(_class='m-line')

    ul = UL(_class='list-inline m-menu')

    li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item m-menu-item")

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('list',args=[str(r.id)])),_class="list-group-item m-menu-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('page',args=[str(r.id)]),_class=""),_class="list-group-item m-menu-item")
        ul.append(li)

    dom_div.append(ul)

    return dom_div


def __get_sidemenu():
    """
    Side menuを取得する
    2018-11
    """
    # トップ以外のサイドメニュー索引の作成
    dom_div = DIV(_class='m-leftside')

    ul = UL(_class='list-group list-group-flush m-collection')

    li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item")
    ul.append(li)

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('list',args=[str(r.id)])),_class="list-group-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('page',args=[str(r.id)]),_class=""),_class="list-group-item")
        ul.append(li)

    dom_div.append(ul)

    return dom_div


# ========================================
# Thumbnail image
# 2018-11
# ========================================

def __get_dom_icon_manifest(d_dom):
    """
    Manifest link
    2018-11
    """
    a_manifest = ''

    if 'format' in d_dom:
        if 'tif' in d_dom['format'] or 'jp2' in d_dom['format']:
            a_manifest = SPAN(A(
                IMG(
                    _src=URL('static','mr_images/iiif_logo.png')
                    ,_width='32'
                )
                ,_href=URL('iiif',args=[d_dom['role'],d_dom['subid'],'manifest.json'])
                ,_target='_blank'
                ,_title='IIIF-Manifest'
                )
                ,_class="m-manifest-link")
        elif 'jpg' in d_dom['format']:
            a_manifest = SPAN(A(#'IIIF-Manifest'
                IMG(
                    _src=URL('static','mr_images/iiif_logo.png')
                    ,_width='32'
                )
                ,_href=URL('iiif',args=[d_dom['role'],d_dom['subid'],'manifest.json'])
                ,_target='_blank'
                ,_title='IIIF-Manifest'
                )
                ,_class="m-manifest-link")

    return a_manifest


def __get_dom_image_annotes(_session, d_d, _atypes=['area'], enable_link=False):
    """
    Annotation imageのHTMLを取得する
    2018-11
    """
    dom_file_ul = None

    if len(d_d['files']) > 0:

        dom_file_ul = UL(_class='m-items')

        for d_dom in d_d['files']:

            # Manifest link
            a_manifest = __get_dom_icon_manifest(d_dom)

            # Snap image
            img = IMG(_src='/%s/resources/%s' % (MR_CONF['APP_NAME'],'/'.join(d_dom['snapimage']))
                        ,_width=240
                        ,_alt=d_dom['title']
                        ,_class='m-snapimage'
                    )
            href = URL('viewer',args=d_dom['href'])
            if 'pdf' in d_dom['href']:
                href = '/%s/resources/%s.pdf' % (MR_CONF['IMAGE_NAME'],'/'.join(d_dom['href'][:-1]))

            _session.imgs[tuple(d_dom['href'])] = d_dom['ids']

            dom_file_li= LI(
                            DIV(
                                DIV(
                                    A(img
                                        ,_href=href
                                        ,_target='_blank'
                                        ,_title=d_dom['title']
                                    )
                                    ,a_manifest
                                    ,_label=d_dom['title']
                                    ,_class='m-image m-item-snapimage'
                                    ,**{'_data-id':d_dom['subid']}
                                )
                                ,P(
                                    d_dom['title']
                                )
                            )
                            ,_class='m-item m-item-wid240'
                        )

            dom_file_ul.append(dom_file_li)

    if len(d_d['annotes']) > 0:

        for d_dom in d_d['annotes']:

            # 対象のアノテーション形式（デフォルト'area'）以外はスルー（出力抑制）
            if d_dom['annotetype'] not in _atypes: continue

            # Manifest link
            a_manifest = __get_dom_icon_manifest(d_dom)

            # Snap image
            if 'tif' in d_dom['format'] or 'jp2' in d_dom['format']:
                img_src = '%s%s.%s/%s/240,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(d_dom['href'][:-1]),d_dom['format'],','.join([str(v) for v in d_dom['annotearea']]),int(d_dom['annoterotation']))
            elif 'jpg' in d_dom['format']:
                img_src='/%s/resources/%s' % (MR_CONF['APP_NAME'],'/'.join(d_dom['thumbnail']))
            else:
                continue

            img = IMG(_src=img_src
                        ,_alt=d_dom['title']
                        ,_class='m-thumbnail'
                    )
            href = URL('viewer',args=d_dom['href'])
            var_args = d_dom['href']
            if 'tif' in d_dom['format'] or 'jp2' in d_dom['format']:
                manifest_id = "iiif/annote/%s/manifest.json" % (str(d_dom['subid']))
                var_args = ['iiif','annote',str(d_dom['subid']),'manifest.json']
                href = URL('viewer',args=[manifest_id])

            if enable_link:
                img_obj = A(img
                            ,_href=href
                            ,_target='_blank'
                            ,_title=d_dom['title']
                        )
            else:
                img_obj = img

            _session.imgs[tuple(var_args)] = d_dom['ids']

            dom_file_li= LI(
                            DIV(
                                DIV(img_obj
                                    ,a_manifest
                                    ,_label=d_dom['title']
                                    ,_class='m-image m-item-thumbnail'
                                    ,**{'_data-id':d_dom['subid']}
                                )
                                ,P(
                                    d_dom['title']
                                )
                            )
                            ,_class='m-item m-item-wid240'
                        )

            dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __get_dom_thumbnail_annotes(_session, d_d, enable_link=False):
    """
    Annotation imageのHTMLを取得する
    2018-11
    """
    dom_file_ul = None

    if len(d_d['annotes']) > 0:

        dom_file_ul = UL(_class='m-items')

        for d_dom in d_d['annotes']:

            # Manifest link
            a_manifest = __get_dom_icon_manifest(d_dom)

            # Thumbnail image
            if 'tif' in d_dom['format'] or 'jp2' in d_dom['format']:
                img_src = '%s%s.%s/%s/%d,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(d_dom['href'][:-1]),d_dom['format'],','.join([str(v) for v in d_dom['annotearea']]),MR_CONF['IMG_THUMBNAIL_SIZE'],int(d_dom['annoterotation']))
            elif 'jpg' in d_dom['format']:
                img_src='/%s/resources/%s' % (MR_CONF['APP_NAME'],'/'.join(d_dom['thumbnail']))

            img = IMG(_src=img_src
                        ,_alt=d_dom['title']
                        ,_class='m-thumbnail'
                    )
            href = URL('viewer',args=d_dom['href'])
            var_args = d_dom['href']
            if 'tif' in d_dom['format'] or 'jp2' in d_dom['format']:
                manifest_id = "iiif/annote/%s/manifest.json" % (str(d_dom['subid']))
                var_args = ['iiif','annote',str(d_dom['subid']),'manifest.json']
                href = URL('viewer',args=[manifest_id])

            if enable_link:
                img_obj = A(img
                            ,_href=href
                            ,_target='_blank'
                            ,_title=d_dom['title']
                        )
            else:
                img_obj = img

            _session.imgs[tuple(var_args)] = d_dom['ids']

            dom_file_li= LI(
                            DIV(
                                DIV(img_obj
                                    ,a_manifest
                                    ,_label=d_dom['title']
                                    ,_class='m-image m-item-thumbnail'
                                    ,**{'_data-id':d_dom['subid']}
                                )
                                ,P(
                                    d_dom['title']
                                )
                            )
                            ,_class='m-item m-item-wid240'
                        )

            dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __get_dom_thumbnail_files(_session, d_d):
    """
    Thumbnail imageのHTMLを取得する
    2018-11
    """
    dom_file_ul = None

    if len(d_d['files']) > 0:

        dom_file_ul = UL(_class='m-items')

        for d_dom in d_d['files']:

            # Thumbnail image
            img = IMG(_src='/%s/resources/%s' % (MR_CONF['APP_NAME'],'/'.join(d_dom['thumbnail']))
                        ,_alt=d_dom['title']
                        ,_class='m-thumbnail'
                    )

            href = URL('item',args=[d_d['subid']])

            _session.imgs[tuple(d_dom['href'])] = d_dom['ids']

            dom_file_li= LI(
                            DIV(
                                DIV(
                                    A(img
                                        ,_href=href
                                    )
                                    ,_label=d_dom['title']
                                    ,_class='m-image m-item-thumbnail'
                                    ,**{'_data-id':d_dom['subid']}
                                )
                                ,P(
                                    d_dom['title']
                                )
                            )
                            ,_class='m-item m-item-wid160'
                        )

            dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __get_dom_snapimage_files(_session, d_d):
    """
    Snap imageのHTMLを取得する
    2018-11
    """
    dom_file_ul = None

    if len(d_d['files']) > 0:

        dom_file_ul = UL(_class='m-items')

        for d_dom in d_d['files']:

            # Manifest link
            a_manifest = __get_dom_icon_manifest(d_dom)

            # Snap image
            img = IMG(_src='/%s/resources/%s' % (MR_CONF['APP_NAME'],'/'.join(d_dom['snapimage']))
                        ,_alt=d_dom['title']
                        ,_width='320'
                        ,_class='m-snapimage'
                    )

            href = URL('viewer',args=d_dom['href'])
            a_title = T('click to open viewer')

            if 'pdf' in d_dom['href']:
                href = '/%s/resources/%s.pdf' % (MR_CONF['IMAGE_NAME'],'/'.join(d_dom['href'][:-1]))
                a_title = T('click to open pdf')

            _session.imgs[tuple(d_dom['href'])] = d_dom['ids']

            dom_file_li= LI(
                            DIV(
                                DIV(
                                    A(img
                                        ,_href=href
                                        ,_target='_blank'
                                        ,_title=a_title
                                    )
                                    ,a_manifest
                                    ,_label=d_dom['title']
                                    ,_class='m-image m-item-snapimage'
                                    ,**{'_data-id':d_dom['subid']}
                                )
                                ,P(
                                    d_dom['title']
                                )
                            )
                            ,_class='m-item m-item-wid320'
                        )

            dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


# ========================================
# User
# 2018-11
# ========================================

def user():
    """
    ユーザー認証
    2018-11
    """
    auth.settings.controller = 'default'
    return dict(form=auth())
