#!/usr/bin/env ruby
require "fileutils"
require 'pp'
$LOAD_PATH << "/usr/lib64/ruby/site_ruby/1.8/x86_64-linux"
require 'RRD'

SCRIPT_DIR=File.dirname(File.expand_path(__FILE__))
RRD_DIR="#{SCRIPT_DIR}/rrd"
IPVSADM="/sbin/ipvsadm"
CMD_STATS="#{IPVSADM} -L -n --stats --exact"
CMD_CONN="#{IPVSADM} -L -n"
LOG_FILE="/var/log/lvs_stats.log"

$log = File.open(LOG_FILE, "a") if ARGV[0] == "log"

def rrd_stats_create(rrd_name)
  RRD.create(
    rrd_name,
   "--start", "#{Time.now.to_i-1}",
   "--step",  "300",
   "DS:ActiveConn:GAUGE:600:U:U",
   "DS:InActConn:GAUGE:600:U:U",
   "DS:Conns:DERIVE:600:0:U",
   "DS:InPkts:DERIVE:600:0:U",
   "DS:OutPkts:DERIVE:600:0:U",
   "DS:InBytes:DERIVE:600:0:U",
   "DS:OutBytes:DERIVE:600:0:U",
   "RRA:AVERAGE:0.5:1:28800",
   "RRA:AVERAGE:0.5:6:4800",
   "RRA:AVERAGE:0.5:24:2400",
   "RRA:AVERAGE:0.5:288:797",
   "RRA:MAX:0.5:1:28800",
   "RRA:MAX:0.5:6:4800",
   "RRA:MAX:0.5:24:2400",
   "RRA:MAX:0.5:288:797"
  )
end

vs_name=""

conn_table=Hash.new {|h,k| h[k] = [0,0] }
stats_table=Hash.new{|h,k| h[k] = [0,0,0,0,0] }

conn_result=`#{CMD_CONN}`
conn_result.each do |line|
  if line =~ /^TCP/
    vs_name=line.split[1]
  elsif line =~ /\s+->\s+/
    next if vs_name.empty?
    #pp line.split.values_at(-2,-1)
    act_conn , inact_conn = line.split.values_at(-2,-1)
    conn_table[vs_name][0] += act_conn.to_i
    conn_table[vs_name][1] += inact_conn.to_i
  end
end

#puts conn_table.keys

stats_result=`#{CMD_STATS}`


TIME=Time.now.strftime("%Y%m%d-%H%M%S")
#if $log
#  #$log.puts "==== #{Time.now.strftime("%Y%m%d-%H%M%S")} ===="
#  #$log.puts conn_result
#  #$log.puts
#  #$log.puts stats_result
#  #$log.puts
#end


stats_result.each do |line|
  line.chomp!
  if line =~ /^TCP/
    vs_name, conns, in_pkts, out_pkts, in_bytes, out_bytes= line.split[1..-1]
    rrd="#{RRD_DIR}/#{vs_name.sub(":","_")}.rrd"
    unless FileTest.exist?(rrd)
      rrd_stats_create(rrd)
      #puts %Q!rrd_stats_create(#{rrd})!
    end
    stats_table[vs_name] = conns, in_pkts, out_pkts, in_bytes, out_bytes
  end
end

stats_table.each do |vs_name, stats_count|
  conn_str = conn_table[vs_name].join(":")
  update_str = "N:#{conn_str}:#{stats_count.join(":")}"
  rrd="#{RRD_DIR}/#{vs_name.sub(":","_")}.rrd"
  #$log.puts %Q!RRD.update(#{rrd},"#{update_str}")! if $log
  RRD.update(rrd,"#{update_str}")
end
$log.close if $log
