/*
 * Copyright (c) 2006-2008 NTT DATA CORPORATION.
 * All rights reserved.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#ifdef TEXTPORTER
#include <text_oem.h>

static inline BOOL CallBackFunc(LDDMC_OLEERR* OleErr)
{
  /*
    elog(LOG, "pgsenna2: This OleErr is level %d\n",OleErr->LevNum);
    elog(LOG, "pgsenna2: This OleErr's code is %d\n",OleErr->ErrCode);
    elog(LOG, "pgsenna2: This OleErr's Engine is %s\n",OleErr->DtctResult);
  */
  return 0;
}

int _DMC_GetText_V4(unsigned char *pdfpath, unsigned char *path2,
                    char *enc, int flag)
{
  int iRet;
  DMC_TEXTINFO_V4 textinfo;

  textinfo.bBigEndian  = 1;
  if (flag) {
    textinfo.Option = DMC_GETTEXT_OPT_LF | DMC_GETTEXT_OPT_OUT;
  } else {
    textinfo.Option = DMC_GETTEXT_OPT_LF;
  }
  textinfo.Option1     = 0;
  textinfo.Size        = 0;
  textinfo.Csv_c       = 0;
  strcpy((char *)textinfo.GroupName, enc);
  strcpy((char *)textinfo.DefLangName, "jp");
  iRet = DMC_GetText_V4((Byte*)pdfpath,
                        (Byte*)path2,
                        &textinfo,
                        (DMC_OLEERR_CALLBACK)CallBackFunc);
  return iRet;
}

#endif   /* TEXTPORTER */
