/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <ctype.h>
#include <stdio.h>
//#include <unistd.h>
#include <string.h>
#include "sym.h"
#include "snip.h"

#define BUFSIZE 65536
#define SNIPPETSIZE 80
#define ENCODE sen_enc_euc_jp
#define FLAGS (SEN_SNIP_NORMALIZE)
//#define FLAGS (0)

char keybuf[SEN_SYM_MAX_KEY_SIZE];
char buffer[BUFSIZE];

static sen_sym *
sym_open(const char *filename)
{
  sen_sym *sym;
  if (!(sym = sen_sym_open(filename))) {
    sym = sen_sym_create(filename, 0, 0, ENCODE);
  }
  return sym;
}

static char *
chomp(char *string)
{
  int l = strlen(string);
  if (l) {
    char *p = string + l - 1;
    if (*p == '\n') { *p = '\0'; }
  }
  return string;
}

static int
do_insert(const char *filename, const char *string)
{
  sen_sym *sym;
  if (!(sym = sym_open(filename))) { return -1; }
  if (string) {
    sen_sym_get(sym, string);
  } else {
    while (!feof(stdin)) {
      if (!fgets(keybuf, SEN_SYM_MAX_KEY_SIZE, stdin)) { break; }
      sen_sym_get(sym, chomp(keybuf));
    }
  }
  return 0;
}

static int
do_delete(const char *filename, const char *string)
{
  sen_sym *sym;
  if (!(sym = sym_open(filename))) { return -1; }
  if (string) {
    sen_sym_del(sym, string);
  } else {
    while (!feof(stdin)) {
      if (!fgets(keybuf, SEN_SYM_MAX_KEY_SIZE, stdin)) { break; }
      sen_sym_del(sym, chomp(keybuf));
    }
  }
  return 0;
}

static int
do_select(const char *filename, const char *string)
{
  int i, nconds, total = 0, n_results, max_tagged_len;
  sen_snip *snip;
  sen_sym *sym;
  char **opentag;
  char **closetag;
  char *snip_result;

  if (!(sym = sym_open(filename))) { return -1; }
  sen_sym_info(sym, NULL, NULL, NULL, &nconds, NULL);
//  printf("%d\n", nconds);
  snip = sen_snip_open(ENCODE, FLAGS, SNIPPETSIZE, 3, "{", "}",(sen_snip_mapping *)-1);

  opentag = SEN_MALLOC(sizeof(char *) * nconds);
  closetag = SEN_MALLOC(sizeof(char *) * nconds);

  for (i = 0; i < nconds; i++) {
    int keylen;
    sen_sym_key(sym, i + 1, keybuf, SEN_SYM_MAX_KEY_SIZE);
    keylen = strlen(keybuf);
    opentag[i] = SEN_MALLOC(sizeof(char) * (keylen + 3));
    sprintf(opentag[i], "<%s>", keybuf);
    closetag[i] = SEN_MALLOC(sizeof(char) * (keylen + 4));
    sprintf(closetag[i], "</%s>", keybuf);
    
    sen_snip_add_cond(snip, keybuf, opentag[i], closetag[i]);
//        puts(keybuf);
  }
  while (!feof(stdin)) {
    if (!fgets(buffer, BUFSIZE, stdin)) { break; }
    sen_snip_exec(snip, chomp(buffer), &n_results, &max_tagged_len);

    snip_result = SEN_MALLOC(sizeof(char) * max_tagged_len);
    total += n_results;
    for (i = 0; i < n_results; i++) {
      sen_snip_get_result(snip, i, snip_result);
      puts(snip_result);
    }
    SEN_FREE(snip_result);
  }
//  printf("%d\n", total);
  sen_snip_close(snip);
  for (i = 0; i < nconds; i++) {
    SEN_FREE(opentag[i]);
    SEN_FREE(closetag[i]);
  }
  SEN_FREE(opentag);
  SEN_FREE(closetag);
  
  return 0;
}

int
main(int argc, char **argv)
{
  if (argc >= 3) {
    switch (*argv[2]) {
    case 'i' :
    case 'I' :
      return do_insert(argv[1], argc > 3 ? argv[3] : NULL);
    case 'd' :
    case 'D' :
      return do_delete(argv[1], argc > 3 ? argv[3] : NULL);
    case 's' :
    case 'S' :
      return do_select(argv[1], argc > 3 ? argv[3] : NULL);
    default :
      break;
    }
  }
  puts("Usage: sniptest indexname ins|del|sel [string]");
  return 1;
}
