/*******************************************************
 *
 * COPYRIGHT (C) FUJITSU,LTD. 2001 ALL RIGHTS RESERVED.
 * 
 * Created by T.INDOH <indou.takao@jp.fujitsu.com>
 * Updated by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 *******************************************************/

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/lkst.h>
#include <linux/lkst_private.h>

MODULE_AUTHOR("T.INDOH <indou.takao@jp.fujitsu.com>");
MODULE_LICENSE("GPL");

/* Declaration of hook header */
LKST_ETYPE_DEF_MODULE(0x100, NORMAL, NEW_EVENT1, "New event1(insmod)", \
		     "0", NULL,NULL,NULL);
LKST_ETYPE_DEF_MODULE(0x101, NORMAL, NEW_EVENT2, "New event2(reset timer)", \
		     "jiffies", NULL,NULL,NULL);
LKST_ETYPE_DEF_MODULE(0x102, NORMAL, NEW_EVENT3, "New event3(rmmod)", \
		     "1", NULL,NULL,NULL);

static struct timer_list test_timer;

void func(void)
{
	/* reset the timer */
	printk("reset timer\n");
	mod_timer(&test_timer, jiffies + 10 * HZ);

	LKST_HOOK(LKST_ETYPE_NEW_EVENT2,
	          LKST_ARG32(jiffies,0), LKST_ARG32(0,0),
	          LKST_ARG32(0,0), LKST_ARG32(0,0));
}

static int __init testmod_init(void)
{
	int ret;
	printk("testmod installed\n");

	/* Initialization of hook header */
	ret = lkst_hook_etype_register(&LKST_ETYPE_INFO(NEW_EVENT1));
	if (ret < 0) goto eout3;
	ret = lkst_hook_etype_register(&LKST_ETYPE_INFO(NEW_EVENT2));
	if (ret < 0) goto eout2;
	ret = lkst_hook_etype_register(&LKST_ETYPE_INFO(NEW_EVENT3));
	if (ret < 0) goto eout1;

	LKST_HOOK(LKST_ETYPE_NEW_EVENT1,
	          LKST_ARG32(0,0), LKST_ARG32(0,0),
	          LKST_ARG32(0,0), LKST_ARG32(0,0));

	/* set timer */
	init_timer(&test_timer);
	test_timer.expires  = jiffies + 10 * HZ;
	test_timer.data     = 0;
	test_timer.function = (void *)&func;
	add_timer(&test_timer);

	return 0;
	eout1:
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(NEW_EVENT2));
	eout2:
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(NEW_EVENT1));
	eout3:
	return ret;
}

static void __exit testmod_exit(void)
{
	printk("testmod uninstalled\n");
	del_timer(&test_timer);

	LKST_HOOK(LKST_ETYPE_NEW_EVENT3,
	          LKST_ARG32(1,0), LKST_ARG32(0,0),
	          LKST_ARG32(0,0), LKST_ARG32(0,0));

	/* Cleanup of hook header for module */
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(NEW_EVENT3));
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(NEW_EVENT2));
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(NEW_EVENT1));
}

module_init(testmod_init);
module_exit(testmod_exit);
