/*-*-c++-*-
 * $Id: resourceadapter.cpp,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "resourceadapter.h"
#include <qtextcodec.h>
#include <qbitmap.h>

#ifdef WIN32
#ifdef _DEBUG
#include <qmessagebox.h>
#endif


QPixmap &
Resource::getBitmap(int id) {

	HRSRC r = FindResourceEx(NULL, "PNG", MAKEINTRESOURCE(id),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL));
	if (!r) {
#ifdef _DEBUG
		QMessageBox::information(0, "Debug",
			QString("FindResourceEx returned %1").arg(GetLastError()));
#endif
		return *(new QPixmap());
	}
	DWORD s = SizeofResource(NULL, r);
	HGLOBAL g = LoadResource(NULL, r);
	if (!g) {
#ifdef _DEBUG
		QMessageBox::information(0, "Debug",
			QString("LoadResource returned %1").arg(GetLastError()));
#endif
		return *(new QPixmap());
	}
	LPVOID p = LockResource(g);
	if (p) {
		QByteArray a(s);

		a.duplicate((const char *)p, s);
		a.detach();
		QPixmap::setDefaultOptimization(QPixmap::MemoryOptim);
		QPixmap *pm = new QPixmap(a);
		DeleteObject(g);
		return *pm;
	}
#ifdef _DEBUG
	QMessageBox::information(0, "Debug",
		QString("LockResource returned %1").arg(GetLastError()));
#endif
	return *(new QPixmap());
}
#else

QPixmap &
Resource::getBitmap(const char *path) {
	return *(new QPixmap(path));
}
#endif

QString
Resource::getPluginDir() {
#ifdef WIN32
#ifdef _DEBUG
	return QString(execdir());
#else
	return QString(execdir()) + "/plugins";
#endif
#else
	return QString(DATADIR) +  "/plugins";
#endif
}

QString
Resource::getMessageDir() {
#ifdef WIN32
#ifdef _DEBUG
	return QString(execdir()) + "/../../QLcrash";
#else
	return QString(execdir());
#endif
#else
	return QString(DATADIR);
#endif
}

QString
Resource::currentLocale() {
#ifdef WIN32
	// convert those stupid WinBlows lag id's into proper ISO codes
	WORD langId = PRIMARYLANGID(GetUserDefaultLangID());
	switch (langId) {
		case LANG_AFRIKAANS:
			return QString("C");
			break;
		case LANG_ALBANIAN:
			return QString("C");
			break;
		case LANG_ARABIC:
			return QString("C");
			break;
		case LANG_ARMENIAN:
			return QString("C");
			break;
		case LANG_ASSAMESE:
			return QString("C");
			break;
		case LANG_AZERI:
			return QString("C");
			break;
		case LANG_BASQUE:
			return QString("C");
			break;
		case LANG_BELARUSIAN:
			return QString("C");
			break;
		case LANG_BENGALI:
			return QString("C");
			break;
		case LANG_BULGARIAN:
			return QString("C");
			break;
		case LANG_CATALAN:
			return QString("C");
			break;
		case LANG_CHINESE:
			return QString("C");
			break;
		case LANG_CROATIAN:
			return QString("C");
			break;
		case LANG_CZECH:
			return QString("cz");
			break;
		case LANG_DANISH:
			return QString("da");
			break;
		case LANG_DUTCH:
			return QString("nl");
			break;
		case LANG_ENGLISH:
			return QString("en");
			break;
		case LANG_ESTONIAN:
			return QString("C");
			break;
		case LANG_FAEROESE:
			return QString("C");
			break;
		case LANG_FARSI:
			return QString("C");
			break;
		case LANG_FINNISH:
			return QString("fi");
			break;
		case LANG_FRENCH:
			return QString("fr");
			break;
		case LANG_GEORGIAN:
			return QString("C");
			break;
		case LANG_GERMAN:
			return QString("de");
			break;
		case LANG_GREEK:
			return QString("C");
			break;
		case LANG_GUJARATI:
			return QString("C");
			break;
		case LANG_HEBREW:
			return QString("C");
			break;
		case LANG_HINDI:
			return QString("C");
			break;
		case LANG_HUNGARIAN:
			return QString("C");
			break;
		case LANG_ICELANDIC:
			return QString("C");
			break;
		case LANG_INDONESIAN:
			return QString("C");
			break;
		case LANG_ITALIAN:
			return QString("it");
			break;
		case LANG_JAPANESE:
			return QString("C");
			break;
		case LANG_KANNADA:
			return QString("C");
			break;
		case LANG_KASHMIRI:
			return QString("C");
			break;
		case LANG_KAZAK:
			return QString("C");
			break;
		case LANG_KONKANI:
			return QString("C");
			break;
		case LANG_KOREAN:
			return QString("C");
			break;
		case LANG_LATVIAN:
			return QString("C");
			break;
		case LANG_LITHUANIAN:
			return QString("C");
			break;
		case LANG_MACEDONIAN:
			return QString("C");
			break;
		case LANG_MALAY:
			return QString("C");
			break;
		case LANG_MALAYALAM:
			return QString("C");
			break;
		case LANG_MANIPURI:
			return QString("C");
			break;
		case LANG_MARATHI:
			return QString("C");
			break;
		case LANG_NEPALI:
			return QString("C");
			break;
		case LANG_NEUTRAL:
			return QString("C");
			break;
		case LANG_NORWEGIAN:
			return QString("no");
			break;
		case LANG_ORIYA:
			return QString("C");
			break;
		case LANG_POLISH:
			return QString("pl");
			break;
		case LANG_PORTUGUESE:
			return QString("pt");
			break;
		case LANG_PUNJABI:
			return QString("C");
			break;
		case LANG_ROMANIAN:
			return QString("C");
			break;
		case LANG_RUSSIAN:
			return QString("C");
			break;
		case LANG_SANSKRIT:
			return QString("C");
			break;
// That shitty MSDN doc states duplicate LANG ids ...
//		case LANG_SERBIAN:
//			return QString("C");
//			break;
		case LANG_SINDHI:
			return QString("C");
			break;
		case LANG_SLOVAK:
			return QString("C");
			break;
		case LANG_SLOVENIAN:
			return QString("C");
			break;
		case LANG_SPANISH:
			return QString("es");
			break;
		case LANG_SWAHILI:
			return QString("C");
			break;
		case LANG_SWEDISH:
			return QString("sv");
			break;
		case LANG_TAMIL:
			return QString("C");
			break;
		case LANG_TATAR:
			return QString("C");
			break;
		case LANG_TELUGU:
			return QString("C");
			break;
		case LANG_THAI:
			return QString("C");
			break;
		case LANG_TURKISH:
			return QString("tr");
			break;
// ... and even undeclared LANG ids.
//		case LANG_UKRANIAN:
//			return QString("C");
//			break;
		case LANG_URDU:
			return QString("C");
			break;
		case LANG_UZBEK:
			return QString("C");
			break;
		case LANG_VIETNAMESE:
			return QString("C");
			break;
		default:
			return QString("C");
			break;
	}
#else
	return QString(QTextCodec::locale());
#endif
}
