/*-*-c++-*-
 * $Id: gram.cpp,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <stdio.h>
#line 1 "gram.y"

	#include "parser.h"
	
	// specify parser prefix
	#define yy sp

#line 32 "gram.cpp"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    ParseTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    ParseARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    ParseKRARGDECL     A version of ParseARGDECL for K&R C.
**    ParseANSIARGDECL   A version of ParseARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 21
#define YYACTIONTYPE unsigned char
#define ParseTOKENTYPE  TokenStruct 
typedef union {
  ParseTOKENTYPE yy0;
  int yy41;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define ParseARGDECL ,obj 
#define ParseXARGDECL  CParser* obj ;
#define ParseANSIARGDECL , CParser* obj 
#define YYNSTATE 60
#define YYNRULE 25
#define YYERRORSYMBOL 16
#define YYERRSYMDT yy41
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  15,  86, &yyActionTable[   1] }, /*               datatype accept */
  {  11,   2, 0                    }, /*                 STRUCT shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,   1, &yyActionTable[   0] }, /*                 struct shift  1 */
/* State 1 */
  {   0,  60, 0                    }, /*                      $ reduce 0 */
/* State 2 */
  {  12,  58, 0                    }, /*          brace_content shift  58 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
  {  10,   3, &yyActionTable[   6] }, /*                 STRING shift  3 */
  {YYNOCODE,0,0}, /* Unused */
/* State 3 */
  {  12,   4, &yyActionTable[  10] }, /*          brace_content shift  4 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
/* State 4 */
  {  18,   5, 0                    }, /*              separator shift  5 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 5 */
  {   0,  61, 0                    }, /*                      $ reduce 1 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 6 */
  {YYNOCODE,0,0}, /* Unused */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {  18,   9, 0                    }, /*              separator shift  9 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 9 */
  {  14,  10, 0                    }, /*                content shift  10 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 10 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {  17,  37, &yyActionTable[  24] }, /*                   name shift  37 */
  {  10,  18, 0                    }, /*                 STRING shift  18 */
  {   1,  11, 0                    }, /*            BRACE_CLOSE shift  11 */
  {   4,  55, 0                    }, /*           BRACKET_OPEN shift  55 */
  {  13,  12, 0                    }, /*                bracket shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
/* State 11 */
  {   9,  63, 0                    }, /*                    SEP reduce 3 */
/* State 12 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {  17,  13, 0                    }, /*                   name shift  13 */
  {  10,  18, 0                    }, /*                 STRING shift  18 */
  {  11,  31, 0                    }, /*                 STRUCT shift  31 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
/* State 13 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
  {  18,  14, &yyActionTable[  38] }, /*              separator shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  12,  29, 0                    }, /*          brace_content shift  29 */
  {   5,  15, 0                    }, /*                  EQUAL shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 14 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 15 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {  17,  16, 0                    }, /*                   name shift  16 */
  {  10,  18, 0                    }, /*                 STRING shift  18 */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
/* State 16 */
  {  18,  17, 0                    }, /*              separator shift  17 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 17 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 19 */
  {  10,  20, 0                    }, /*                 STRING shift  20 */
/* State 20 */
  {   6,  21, 0                    }, /*            PAREN_CLOSE shift  21 */
  {   5,  22, 0                    }, /*                  EQUAL shift  22 */
/* State 21 */
  {YYNOCODE,0,0}, /* Unused */
/* State 22 */
  {  10,  23, 0                    }, /*                 STRING shift  23 */
/* State 23 */
  {   6,  24, 0                    }, /*            PAREN_CLOSE shift  24 */
/* State 24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 25 */
  {  10,  26, &yyActionTable[  63] }, /*                 STRING shift  26 */
  {   8,  28, 0                    }, /*                  QUOTE shift  28 */
/* State 26 */
  {   8,  27, 0                    }, /*                  QUOTE shift  27 */
/* State 27 */
  {YYNOCODE,0,0}, /* Unused */
/* State 28 */
  {YYNOCODE,0,0}, /* Unused */
/* State 29 */
  {  18,  30, 0                    }, /*              separator shift  30 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 30 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 31 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {  17,  34, 0                    }, /*                   name shift  34 */
  {  10,  18, &yyActionTable[  73] }, /*                 STRING shift  18 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
  {  12,  32, 0                    }, /*          brace_content shift  32 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
/* State 32 */
  {  18,  33, 0                    }, /*              separator shift  33 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 33 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 34 */
  {  12,  35, &yyActionTable[  82] }, /*          brace_content shift  35 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
/* State 35 */
  {  18,  36, 0                    }, /*              separator shift  36 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 36 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 37 */
  {   5,  38, 0                    }, /*                  EQUAL shift  38 */
/* State 38 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
  {  17,  41, 0                    }, /*                   name shift  41 */
  {  18,  48, &yyActionTable[  87] }, /*              separator shift  48 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
  {  10,  18, 0                    }, /*                 STRING shift  18 */
  {  11,  49, 0                    }, /*                 STRUCT shift  49 */
  {  12,  39, 0                    }, /*          brace_content shift  39 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 39 */
  {  18,  40, 0                    }, /*              separator shift  40 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 40 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 41 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
  {  18,  42, &yyActionTable[ 106] }, /*              separator shift  42 */
  {YYNOCODE,0,0}, /* Unused */
  {  12,  46, 0                    }, /*          brace_content shift  46 */
  {   5,  43, 0                    }, /*                  EQUAL shift  43 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 42 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 43 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {  17,  44, 0                    }, /*                   name shift  44 */
  {  10,  18, 0                    }, /*                 STRING shift  18 */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
/* State 44 */
  {  18,  45, 0                    }, /*              separator shift  45 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 45 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 46 */
  {  18,  47, 0                    }, /*              separator shift  47 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 47 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 48 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 49 */
  {  12,  50, 0                    }, /*          brace_content shift  50 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
  {  10,  52, &yyActionTable[ 127] }, /*                 STRING shift  52 */
  {YYNOCODE,0,0}, /* Unused */
/* State 50 */
  {  18,  51, 0                    }, /*              separator shift  51 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 51 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 52 */
  {  12,  53, &yyActionTable[ 134] }, /*          brace_content shift  53 */
  {   2,   8, 0                    }, /*             BRACE_OPEN shift  8 */
/* State 53 */
  {  18,  54, 0                    }, /*              separator shift  54 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 54 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
/* State 55 */
  {   8,  25, 0                    }, /*                  QUOTE shift  25 */
  {  17,  56, 0                    }, /*                   name shift  56 */
  {  10,  18, 0                    }, /*                 STRING shift  18 */
  {   7,  19, 0                    }, /*             PAREN_OPEN shift  19 */
/* State 56 */
  {   3,  57, 0                    }, /*          BRACKET_CLOSE shift  57 */
/* State 57 */
  {YYNOCODE,0,0}, /* Unused */
/* State 58 */
  {  18,  59, 0                    }, /*              separator shift  59 */
  {   9,   7, 0                    }, /*                    SEP shift  7 */
/* State 59 */
  {   0,  62, 0                    }, /*                      $ reduce 2 */
  {   9,   6, 0                    }, /*                    SEP shift  6 */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.  
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 3, 85},
  { &yyActionTable[4], 0, 85},
  { &yyActionTable[5], 3, 85},
  { &yyActionTable[9], 1, 85},
  { &yyActionTable[11], 1, 85},
  { &yyActionTable[13], 1, 85},
  { &yyActionTable[15], 0, 83},
  { &yyActionTable[16], 0, 82},
  { &yyActionTable[17], 1, 85},
  { &yyActionTable[19], 1, 64},
  { &yyActionTable[21], 7, 85},
  { &yyActionTable[29], 0, 85},
  { &yyActionTable[30], 7, 85},
  { &yyActionTable[38], 7, 85},
  { &yyActionTable[46], 0, 65},
  { &yyActionTable[47], 3, 85},
  { &yyActionTable[51], 1, 85},
  { &yyActionTable[53], 0, 68},
  { &yyActionTable[54], 0, 77},
  { &yyActionTable[55], 0, 85},
  { &yyActionTable[56], 1, 85},
  { &yyActionTable[58], 0, 78},
  { &yyActionTable[59], 0, 85},
  { &yyActionTable[60], 0, 85},
  { &yyActionTable[61], 0, 79},
  { &yyActionTable[62], 1, 85},
  { &yyActionTable[64], 0, 85},
  { &yyActionTable[65], 0, 80},
  { &yyActionTable[66], 0, 81},
  { &yyActionTable[67], 1, 85},
  { &yyActionTable[69], 0, 69},
  { &yyActionTable[70], 7, 85},
  { &yyActionTable[78], 1, 85},
  { &yyActionTable[80], 0, 66},
  { &yyActionTable[81], 1, 85},
  { &yyActionTable[83], 1, 85},
  { &yyActionTable[85], 0, 67},
  { &yyActionTable[86], 0, 85},
  { &yyActionTable[87], 15, 85},
  { &yyActionTable[103], 1, 85},
  { &yyActionTable[105], 0, 70},
  { &yyActionTable[106], 7, 85},
  { &yyActionTable[114], 0, 71},
  { &yyActionTable[115], 3, 85},
  { &yyActionTable[119], 1, 85},
  { &yyActionTable[121], 0, 72},
  { &yyActionTable[122], 1, 85},
  { &yyActionTable[124], 0, 74},
  { &yyActionTable[125], 0, 73},
  { &yyActionTable[126], 3, 85},
  { &yyActionTable[130], 1, 85},
  { &yyActionTable[132], 0, 75},
  { &yyActionTable[133], 1, 85},
  { &yyActionTable[135], 1, 85},
  { &yyActionTable[137], 0, 76},
  { &yyActionTable[138], 3, 85},
  { &yyActionTable[142], 0, 85},
  { &yyActionTable[143], 0, 84},
  { &yyActionTable[144], 1, 85},
  { &yyActionTable[146], 1, 85},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = { 
  "$",             "BRACE_CLOSE",   "BRACE_OPEN",    "BRACKET_CLOSE",
  "BRACKET_OPEN",  "EQUAL",         "PAREN_CLOSE",   "PAREN_OPEN",  
  "QUOTE",         "SEP",           "STRING",        "STRUCT",      
  "brace_content",  "bracket",       "content",       "datatype",    
  "error",         "name",          "separator",     "struct",      
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(int)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (int)sizeof(yyParser) );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
#line 22 "gram.y"
{
	delete (yypminor->yy0).string;
}
#line 538 "gram.cpp"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from ParseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */
 
  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 15, 1 },
  { 19, 4 },
  { 19, 3 },
  { 12, 4 },
  { 14, 0 },
  { 14, 4 },
  { 14, 5 },
  { 14, 6 },
  { 14, 6 },
  { 14, 5 },
  { 14, 5 },
  { 14, 5 },
  { 14, 7 },
  { 14, 4 },
  { 14, 6 },
  { 14, 6 },
  { 14, 7 },
  { 17, 1 },
  { 17, 3 },
  { 17, 5 },
  { 17, 3 },
  { 17, 2 },
  { 18, 1 },
  { 18, 2 },
  { 13, 3 },
};

static void yy_accept(yyParser *  ParseANSIARGDECL);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  ParseANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("datatype ::= struct")
#line 27 "gram.y"
{
	obj->setRoot(yymsp[0].minor.yy0.node);
	obj->setFinished(true);
	
	PRINT(cerr << "struct (finished)" << endl);
}
#line 729 "gram.cpp"
        break;
      case 1:
        YYTRACE("struct ::= STRUCT STRING brace_content separator")
#line 40 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type = Struct;
	node->name = *yymsp[-2].minor.yy0.string;
	
	yygotominor.yy0.node = node;
	yygotominor.yy0.node->childList.append(yymsp[-1].minor.yy0.node);
	
	delete yymsp[-2].minor.yy0.string;
	
	PRINT(cerr << "struct string brace_content" << endl);
}
#line 747 "gram.cpp"
  yy_destructor(11,&yymsp[-3].minor);
        /* No destructor defined for separator */
        break;
      case 2:
        YYTRACE("struct ::= STRUCT brace_content separator")
#line 59 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type = Struct;
	
	yygotominor.yy0.node = node;
	yygotominor.yy0.node->childList.append(yymsp[-1].minor.yy0.node);
	
	PRINT(cerr << "struct brace_content" << endl);
}
#line 764 "gram.cpp"
  yy_destructor(11,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 3:
        YYTRACE("brace_content ::= BRACE_OPEN separator content BRACE_CLOSE")
#line 75 "gram.y"
{
	yygotominor.yy0.node = yymsp[-1].minor.yy0.node;
}
#line 774 "gram.cpp"
  yy_destructor(2,&yymsp[-3].minor);
        /* No destructor defined for separator */
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 4:
        YYTRACE("content ::=")
#line 79 "gram.y"
{
	yygotominor.yy0.node = new TreeNode;
	yygotominor.yy0.node->type	= Null;
}
#line 786 "gram.cpp"
        break;
      case 5:
        YYTRACE("content ::= content bracket name separator")
#line 87 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Array;
	node->name	= *yymsp[-2].minor.yy0.string;
	node->value	= *yymsp[-1].minor.yy0.string;
	yygotominor.yy0.node = yymsp[-3].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
		
	delete yymsp[-2].minor.yy0.string;
	delete yymsp[-1].minor.yy0.string;
	
	PRINT(cerr << "content bracket name separator" << endl);
}
#line 805 "gram.cpp"
        /* No destructor defined for separator */
        break;
      case 6:
        YYTRACE("content ::= content bracket STRUCT brace_content separator")
#line 107 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= ArrayStruct;
	node->name	= *yymsp[-3].minor.yy0.string;
	yygotominor.yy0.node		= yymsp[-4].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	node->childList.append(yymsp[-1].minor.yy0.node);
	
	delete yymsp[-3].minor.yy0.string;
}
#line 823 "gram.cpp"
  yy_destructor(11,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 7:
        YYTRACE("content ::= content bracket STRUCT name brace_content separator")
#line 125 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= ArrayStruct;
	node->name	= *yymsp[-4].minor.yy0.string;
	node->value	= *yymsp[-2].minor.yy0.string;
	yygotominor.yy0.node		= yymsp[-5].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);

	node->childList.append(yymsp[-1].minor.yy0.node);
	
	delete yymsp[-4].minor.yy0.string;
	delete yymsp[-2].minor.yy0.string;
	
	PRINT(cerr << "content bracket struct string brace_content sep" << endl);
}
#line 846 "gram.cpp"
  yy_destructor(11,&yymsp[-3].minor);
        /* No destructor defined for separator */
        break;
      case 8:
        YYTRACE("content ::= content bracket name EQUAL name separator")
#line 145 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Array;
	node->name	= *yymsp[-4].minor.yy0.string;
	node->value = *yymsp[-1].minor.yy0.string;
	yygotominor.yy0.node 		= yymsp[-5].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-4].minor.yy0.string;
	delete yymsp[-1].minor.yy0.string;
}
#line 865 "gram.cpp"
        /* No destructor defined for name */
  yy_destructor(5,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 9:
        YYTRACE("content ::= content bracket name brace_content separator")
#line 162 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= ArrayStruct;
	node->name	= *yymsp[-3].minor.yy0.string;
	node->value	= *yymsp[-2].minor.yy0.string;
	yygotominor.yy0.node = yymsp[-4].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	node->childList.append(yymsp[-1].minor.yy0.node);
	
	delete yymsp[-3].minor.yy0.string;
	delete yymsp[-2].minor.yy0.string;
	
	PRINT(cerr << "content bracket name brace_content sep" << endl);
}
#line 888 "gram.cpp"
        /* No destructor defined for separator */
        break;
      case 10:
        YYTRACE("content ::= content name EQUAL brace_content separator")
#line 183 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->childList.append(yymsp[-1].minor.yy0.node);
	node->type	= Array;
	node->name	= *yymsp[-3].minor.yy0.string;
	yygotominor.yy0.node		= yymsp[-4].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-3].minor.yy0.string;
	
	PRINT(cerr << "content << name << equal brace_content sep" << endl);
}
#line 907 "gram.cpp"
  yy_destructor(5,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 11:
        YYTRACE("content ::= content name EQUAL name separator")
#line 200 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Scalar;
	node->name	= *yymsp[-3].minor.yy0.string;
	node->value	= *yymsp[-1].minor.yy0.string;
	
	yygotominor.yy0.node = yymsp[-4].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-3].minor.yy0.string;
	delete yymsp[-1].minor.yy0.string;
	
	PRINT(cerr << "content name equal name sep" << endl);
}
#line 929 "gram.cpp"
  yy_destructor(5,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 12:
        YYTRACE("content ::= content name EQUAL name EQUAL name separator")
#line 219 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Scalar;
	node->name	= *yymsp[-5].minor.yy0.string;
	node->value	= *yymsp[-3].minor.yy0.string + " = " + *yymsp[-1].minor.yy0.string;
	
	yygotominor.yy0.node = yymsp[-6].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-5].minor.yy0.string;
	delete yymsp[-3].minor.yy0.string;
	delete yymsp[-1].minor.yy0.string;
	
	PRINT(cerr << "content name equal name equal string sep" << endl);
}
#line 952 "gram.cpp"
  yy_destructor(5,&yymsp[-4].minor);
  yy_destructor(5,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 13:
        YYTRACE("content ::= content name EQUAL separator")
#line 239 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Scalar;
	node->name	= *yymsp[-2].minor.yy0.string;
	node->value = "?";
	
	yygotominor.yy0.node = yymsp[-3].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-2].minor.yy0.string;
	
	PRINT(cerr << "content name equal sep" << endl);
}
#line 974 "gram.cpp"
  yy_destructor(5,&yymsp[-1].minor);
        /* No destructor defined for separator */
        break;
      case 14:
        YYTRACE("content ::= content name EQUAL name brace_content separator")
#line 259 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Struct;
	node->name	= *yymsp[-4].minor.yy0.string;
	node->childList.append(yymsp[-1].minor.yy0.node);
	
	yygotominor.yy0.node = yymsp[-5].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-4].minor.yy0.string;
	
	PRINT(cerr << "content << name equal name brace_content sep" << endl);
}
#line 995 "gram.cpp"
  yy_destructor(5,&yymsp[-3].minor);
        /* No destructor defined for name */
        /* No destructor defined for separator */
        break;
      case 15:
        YYTRACE("content ::= content name EQUAL STRUCT brace_content separator")
#line 279 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type = Struct;
	node->name = *yymsp[-4].minor.yy0.string;
	node->childList.append(yymsp[-1].minor.yy0.node);
	
	yygotominor.yy0.node = yymsp[-5].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-4].minor.yy0.string;
	
	PRINT(cerr << "content name equal struct brace_content sep" << endl);
}
#line 1017 "gram.cpp"
  yy_destructor(5,&yymsp[-3].minor);
  yy_destructor(11,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 16:
        YYTRACE("content ::= content name EQUAL STRUCT STRING brace_content separator")
#line 299 "gram.y"
{
	TreeNode* node = new TreeNode;
	
	node->type	= Struct;
	node->name	= *yymsp[-5].minor.yy0.string;
	node->childList.append(yymsp[-1].minor.yy0.node);
	
	yygotominor.yy0.node = yymsp[-6].minor.yy0.node;
	yygotominor.yy0.node->childList.append(node);
	
	delete yymsp[-5].minor.yy0.string;
	
	PRINT(cerr << "content name equal struct string brace_content sep" << endl);
}
#line 1039 "gram.cpp"
  yy_destructor(5,&yymsp[-4].minor);
  yy_destructor(11,&yymsp[-3].minor);
  yy_destructor(10,&yymsp[-2].minor);
        /* No destructor defined for separator */
        break;
      case 17:
        YYTRACE("name ::= STRING")
#line 317 "gram.y"
{
	yygotominor.yy0.string = yymsp[0].minor.yy0.string;
	yymsp[0].minor.yy0.string = 0;
}
#line 1052 "gram.cpp"
        break;
      case 18:
        YYTRACE("name ::= PAREN_OPEN STRING PAREN_CLOSE")
#line 325 "gram.y"
{
	yygotominor.yy0.string = new QString;
	*yygotominor.yy0.string = QString("(") + *yymsp[-1].minor.yy0.string + QString(")");
	delete yymsp[-1].minor.yy0.string;
}
#line 1062 "gram.cpp"
  yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(6,&yymsp[0].minor);
        break;
      case 19:
        YYTRACE("name ::= PAREN_OPEN STRING EQUAL STRING PAREN_CLOSE")
#line 334 "gram.y"
{
	yygotominor.yy0.string = new QString;
	*yygotominor.yy0.string = QString("(") + *yymsp[-3].minor.yy0.string + "=" + *yymsp[-1].minor.yy0.string + QString(")");
	delete yymsp[-3].minor.yy0.string;
	delete yymsp[-1].minor.yy0.string;
}
#line 1075 "gram.cpp"
  yy_destructor(7,&yymsp[-4].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(6,&yymsp[0].minor);
        break;
      case 20:
        YYTRACE("name ::= QUOTE STRING QUOTE")
#line 344 "gram.y"
{
	yygotominor.yy0.string = yymsp[-1].minor.yy0.string;
	yygotominor.yy0.string->prepend("\"");
	yygotominor.yy0.string->append("\"");
	yymsp[-1].minor.yy0.string = 0;
}
#line 1089 "gram.cpp"
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
        break;
      case 21:
        YYTRACE("name ::= QUOTE QUOTE")
#line 354 "gram.y"
{
	yygotominor.yy0.string = new QString("\"\"");
}
#line 1099 "gram.cpp"
  yy_destructor(8,&yymsp[-1].minor);
  yy_destructor(8,&yymsp[0].minor);
        break;
      case 22:
        YYTRACE("separator ::= SEP")
  yy_destructor(9,&yymsp[0].minor);
        break;
      case 23:
        YYTRACE("separator ::= separator SEP")
        /* No destructor defined for separator */
  yy_destructor(9,&yymsp[0].minor);
        break;
      case 24:
        YYTRACE("bracket ::= BRACKET_OPEN name BRACKET_CLOSE")
#line 364 "gram.y"
{
	yygotominor.yy0.string = new QString(*yymsp[-1].minor.yy0.string);
	delete yymsp[-1].minor.yy0.string;
}
#line 1119 "gram.cpp"
  yy_destructor(4,&yymsp[-2].minor);
  yy_destructor(3,&yymsp[0].minor);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser ParseARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  ParseANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 11 "gram.y"

	obj->setError(true);
	PRINT(cerr << "Parse error" << endl);

#line 1156 "gram.cpp"
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  ParseANSIARGDECL               /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 16 "gram.y"

	obj->setError(true);
	PRINT(cerr << "Syntax error" << endl);

#line 1174 "gram.cpp"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  ParseANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    if( yymajor==0 ) return;
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE ParseARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion ParseARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser ParseARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion ParseARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser ParseARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser ParseARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
