/*-*-c++-*-
 * $Id: ctableview.h,v 1.2 2002/04/19 15:24:17 felfert Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CQTABLEVIEW_H
#define CQTABLEVIEW_H

#include <qobject.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if QT_VERSION < 300
#include <qtableview.h>
#else
#include <qgridview.h>

/**A wrapper to imitate the API of QTableView.
  *@author Michael Geselbracht
  */

class QTableView : public QGridView {
public:
	QTableView(QWidget *parent=0, const char *name=0, int wFlags=0);
	~QTableView();
	
	// these are required by CNConsole but ignored by this class
	enum tblFlags {Tbl_vScrollBar, Tbl_autoHScrollBar};
	
protected:
	void setTableFlags(int);
	int totalHeight() const;
	int totalWidth() const;
	int viewHeight() const;
	int viewWidth() const;
	int xOffset() const;
	void setXOffset(int);
	int yOffset() const;
	void setYOffset(int);
	void updateCell(int x, int y, bool erase=true);
};

#endif /* QT_VERSION >= 300 */

#endif
