/*-*-c++-*-
 * $Id: ctableview.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "ctableview.h"

#if QT_VERSION >= 300

QTableView::QTableView(QWidget *parent, const char *name, int f) : QGridView(parent, name, f)
{
}

QTableView::~QTableView()
{
}

void
QTableView::setTableFlags(int)
{
}

int
QTableView::xOffset() const
{
	return contentsX();
}

void
QTableView::setXOffset(int x)
{
	setContentsPos(x, contentsY());
}

int
QTableView::yOffset() const
{
	return contentsY();
}

void
QTableView::setYOffset(int y)
{
	setContentsPos(contentsX(), y);
}

void
QTableView::updateCell(int x, int y, bool erase)
{
	repaintCell(x, y, erase);
}

int
QTableView::totalHeight() const
{
	return contentsHeight();
}

int
QTableView::totalWidth() const
{
	return contentsWidth();
}

int
QTableView::viewWidth() const
{
	return viewport()->width();
}

int
QTableView::viewHeight() const
{
	return viewport()->height();
}

#else

// don't try to compile an empty file

static void dummy()
{
}

#endif
