/*-*-c++-*-
 * $Id: cpreferencesdialog.cpp,v 1.2 2002/01/29 14:55:47 felfert Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "cpreferencesdialog.h"
#include "qlcrashdoc.h"
#include "cconfigmanager.h"

#include <qframe.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qfontdialog.h>
#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qapplication.h>
#include <qfontdatabase.h>

#include "resourceadapter.h"

#ifndef MAX
#define MAX(x,y) ((x>=y) ? x : y)
#endif

CPreferencesDialog::CPreferencesDialog(QLcrashDoc* doc, QWidget* parent, const char* name)
	: QDialog(parent, name, true)
	, oDoc(doc)
{
	setIcon(Resource::getBitmap(IDR_PNG7));
	setCaption(stdCaption(tr("Options")));
	oTop = new QFrame(this);
	oTop->setFrameStyle(QFrame::Panel | QFrame::Raised);
	oBot = new QFrame(this);
	oBot->setFrameStyle(QFrame::Panel | QFrame::Raised);
	
	oOk = new QPushButton(tr("Ok"), oBot);
	oOk->setDefault(true);
	oCancel = new QPushButton(tr("Cancel"), oBot);
	connect(oOk, SIGNAL(clicked()), SLOT(slotOk()));
	connect(oCancel, SIGNAL(clicked()), SLOT(slotCancel()));
	
	oGlobalFontT = new QLabel(tr("Global font") + ":", oTop);
	// get current font settings
	oGlobalFontFamily = oDoc->configManager()->item(CFG_GRP_APP, CFG_ATT_APP_FONTFAMILY,
		QApplication::font().family());
	oGlobalFontSize = oDoc->configManager()->item(CFG_GRP_APP, CFG_ATT_APP_FONTSIZE,
		QApplication::font().pointSize());
	oGlobalFont.setFamily(oGlobalFontFamily);
	oGlobalFont.setPointSize(oGlobalFontSize);
	oGlobalFontC = new QLabel(oTop);
	oGlobalFontC->setFont(oGlobalFont);
	oGlobalFontS = new QPushButton(tr("Change") + "...", oTop);
	connect(oGlobalFontS, SIGNAL(clicked()), SLOT(slotGlobalFontSelect()));
	
	oFontT = new QLabel(tr("Console font") + ":", oTop);
	// get current font settings
	QString cFamily = "Courier"; // Fallback
	QFontDatabase fdb;
#if QT_VERSION >= 230
	QStringList families = fdb.families();
	for (QStringList::Iterator it = families.begin(); it != families.end(); ++it)
		if (fdb.isFixedPitch(*it)) {
			cFamily = *it;
			break;
		}
#endif
	oFontFamily = oDoc->configManager()->item(CFG_GRP_CONSOLE, CFG_ATT_CONSOLE_FONTFAMILY, cFamily);
	int cSize = 10; // Fallback;
	QValueList<int> sizes = fdb.pointSizes(cFamily);
	for (QValueList<int>::Iterator sit = sizes.begin(); sit != sizes.end(); ++sit)
		if ((*sit <= oGlobalFontSize) && (*sit >= (oGlobalFontSize - 2))) {
			cSize = *sit;
			break;
		}
	oFontSize = oDoc->configManager()->item(CFG_GRP_CONSOLE, CFG_ATT_CONSOLE_FONTSIZE, cSize);
	oFont.setFamily(oFontFamily);
	oFont.setPointSize(oFontSize);
	oFontC = new QLabel(oTop);
	oFontC->setFont(oFont);
	oFontS = new QPushButton(tr("Change") + "...", oTop);
	connect(oFontS, SIGNAL(clicked()), SLOT(slotFontSelect()));
	
	setFontLabel();

	oPathT = new QLabel(tr("Lcrash plugin") + ":", oTop);
	oPath = oDoc->configManager()->item(CFG_GRP_FILES, CFG_ATT_FILES_PLUGIN, "none");
	oPathC = new QLineEdit(oPath, this);
	oPathS = new QPushButton(tr("Change") + "...", oTop);
	connect(oPathS, SIGNAL(clicked()), SLOT(slotPathSelect()));

	
	oPFormatT = new QLabel(tr("Print format") + ":", oTop);
	oPFormatC = new QComboBox(oTop);
	oPFormatC->insertItem(tr("Default"));
	oPFormatC->insertItem(tr("Hex"));
	oPFormatC->insertItem(tr("Decimal"));
	oPFormatC->insertItem(tr("Octal"));
	oPFormatC->insertItem(tr("Binary"));
	oPFormatC->setCurrentItem(oDoc->configManager()->item(CFG_GRP_GRAPH, CFG_ATT_GRAPH_PRINTFORMAT, 0));
	
	oDumpTBOnMainB = new QCheckBox(tr("Dock dump toolbar on main window"), oTop);
	oDumpTBOnMainB->setChecked(bool(oDoc->configManager()->item(CFG_GRP_DUMP, CFG_ATT_DUMP_TBDOCKMAIN, 0)));
	
	oFontT->adjustSize();
	oFontT->resize(oFontT->width(), oFontC->height());
	oPathT->adjustSize();
	oPathT->resize(oPathT->width(), oPathC->height());
	oPFormatT->adjustSize();
	oPFormatT->resize(oPFormatT->width(), oPFormatC->height());	
	oDumpTBOnMainB->adjustSize();
	
	// we did not change the font settings up to now...
	oFontChanged = false;
	
	setMinimumSize(400, 210);
}

CPreferencesDialog::~CPreferencesDialog()
{
}

void
CPreferencesDialog::resizeEvent(QResizeEvent*)
{
	const int x = 5;
	const int y = 5;
	
	oTop->setGeometry(0, 0, width(), height() - 2*y - oOk->height());
	oBot->setGeometry(0, oTop->y() + oTop->height(), width(), height() - oTop->x() - oTop->height());
	
	const int w1 = MAX(oFontT->width(), MAX(oPathT->width(), MAX(oGlobalFontT->width(), oPFormatT->width())));
	oGlobalFontC->setGeometry(w1 + 2*x, y
		, width() - w1 - 3*x - oGlobalFontS->width()
		, oGlobalFontC->height()
	);
	oFontC->setGeometry(w1 + 2*x, oGlobalFontC->y() + oGlobalFontC->height() + y
		, width() - w1 - 3*x - oFontS->width()
		, oFontC->height()
	);
	oPathC->setGeometry(w1 + 2*x, oFontC->y() + oFontC->height() + y
		, width() - w1 - 4*x - oFontS->width()
		, oPathC->height()
	);
	oPFormatC->move(w1 + 2*x, oPathC->y() + oPathC->height() + y);
	
	oGlobalFontT->move(x, oGlobalFontC->y());
	oFontT->move(x, oFontC->y());
	oPathT->move(x, oPathC->y());
	oPFormatT->move(x, oPFormatC->y());
	
	oGlobalFontS->move(width() - oGlobalFontS->width() - x, y);
	oFontS->move(oGlobalFontS->x(), oFontT->y());
	oPathS->move(oGlobalFontS->x(), oPathT->y());
	
	oDumpTBOnMainB->move(x, oPFormatT->y() + oPFormatT->height() + y);
	
	oOk->move(width() - oOk->width() - 2*x - oCancel->width(), y);
	oCancel->move(width() - x - oCancel->width(), y);
}

void
CPreferencesDialog::slotOk()
{
	CConfigManager* man = oDoc->configManager();
	
	// fonts
	man->setItem(CFG_GRP_APP, CFG_ATT_APP_FONTFAMILY, oGlobalFontFamily);
	man->setItem(CFG_GRP_APP, CFG_ATT_APP_FONTSIZE, oGlobalFontSize);
	man->setItem(CFG_GRP_CONSOLE, CFG_ATT_CONSOLE_FONTFAMILY, oFontFamily);
	man->setItem(CFG_GRP_CONSOLE, CFG_ATT_CONSOLE_FONTSIZE, oFontSize);
	
	// print format
	man->setItem(CFG_GRP_GRAPH, CFG_ATT_GRAPH_PRINTFORMAT, oPFormatC->currentItem());
	
	// dump toolbar
	man->setItem(CFG_GRP_DUMP, CFG_ATT_DUMP_TBDOCKMAIN, int(oDumpTBOnMainB->isChecked()));
	
	man->saveConfig();
	accept();
}

void
CPreferencesDialog::slotCancel()
{
	reject();
}

void
CPreferencesDialog::slotGlobalFontSelect()
{
	bool ok;
	QFont font(oGlobalFontFamily, oGlobalFontSize);
	oGlobalFont = QFontDialog::getFont(&ok, font, this);
	
	if (ok) {
		oGlobalFontFamily = oGlobalFont.family();
		oGlobalFontSize = oGlobalFont.pointSize();
		
		setFontLabel();
	}
}

void
CPreferencesDialog::slotFontSelect()
{
	bool ok;
	QFont font(oFontFamily, oFontSize);
	oFont = QFontDialog::getFont(&ok, font, this);
	
	if (ok) {
		oFontFamily = oFont.family();
		oFontSize = oFont.pointSize();
		
		setFontLabel();
		oFontChanged = true;
	}
}

void
CPreferencesDialog::slotPathSelect()
{
	oDoc->slotSetup();
	oPathC->setText(oDoc->configManager()->item(CFG_GRP_FILES, CFG_ATT_FILES_PLUGIN, "none"));
}

void
CPreferencesDialog::setFontLabel()
{
	oGlobalFontC->setText(oGlobalFontFamily + " " + QString::number(oGlobalFontSize) + "pt");
	oFontC->setText(oFontFamily + " " + QString::number(oFontSize) + "pt");
}
