#include <lcrash.h>

extern int get_dump_header_asm(dump_header_asm_t *dump_header_asm);
extern int defcpu;

#define _RD_USAGE "[-w outfile]"

void
rd_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _RD_USAGE);
}

void
rd_help(command_t *cmd)
{
	CMD_HELP(cmd, _RD_USAGE,
			"Display the register contents of the default cpu."
			"This command can't be used on a live system ");
}

int
rd_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_WRITE), 0)) {
		return(1);
	}
	return 0;
}

int
rd_cmd(command_t *cmd)
{
	dump_header_asm_t dha;
	struct pt_regs * regs;

	if (cmd->nargs != 0) {
		rd_usage(cmd);
		return(1);
	}	

	if (MIP->core_type != reg_core) {
		fprintf(cmd->efp, "Can't use this command on live system\n");
		return(1);
	}
	
	if (get_dump_header_asm(&dha))
		return(1);

	if (defcpu == -1)
		defcpu = dha.dha_dumping_cpu;
	
	regs = &dha.dha_smp_regs[defcpu];

	fprintf(cmd->ofp, "CPU:    %d   EIP:    %04x:[<%08lx>]\nEFLAGS: %08lx\n",
		defcpu, regs->xcs & 0xffff, regs->eip, regs->eflags);
	fprintf(cmd->ofp, "eax: %08lx   ebx: %08lx   ecx: %08lx   edx: %08lx\n",
		regs->eax, regs->ebx, regs->ecx, regs->edx);
	fprintf(cmd->ofp, "esi: %08lx   edi: %08lx   ebp: %08lx   esp: %08lx\n",
		regs->esi, regs->edi, regs->ebp, regs->esp);
	fprintf(cmd->ofp, "ds: %04x   es: %04x   ss: %04x\n",
		regs->xds & 0xffff, regs->xes & 0xffff, regs->xss & 0xffff);

	return(0);
}
