.TH logformat.pl 1
.SH NAME
logformat.pl \- Display LKST trace data
.SH SYNOPSYS
logformat.pl [ \fB\-c \fIcpu_id\fR ] [ \fB-e \fIevent_name ...\fR ]
[ \fB\-h\fR ] [ \fB-n \fIentry_num\fR ] [ \fB-r\fR ] \fIfilename
.SH DESCRIPTION
\fBlogformat.pl\fR is a Perl Script that displays LKST trace data.
Argument \fIfilename\fR must be specified the file name of binary trace
data, which is created by using \fBlkstbuf\fR command.
(See lkstbuf)
.SH OPTION
.TP
\fB\-c \fIcpu_id
Specify the cpu number.
.TP
\fB\-e \fIevent_name ...

Specify event filter.
Enumerate the names of events which you want to trace.
( Event name list is displayed by option \fB\-h\fR. )
Each event is separated by comma.

example(1) Display only "\fBsystem_call_entry\fR" and "\fBsystem_call_exit\fR".

.B \-e system_call_entry,system_call_exit


If you don't want to trace some events, specify "\fB!\fR" followed by the
names of the events, like "\fB!system_call_entry\fR". 
You can specify "\fBall\fR" to specify all events.

example(2) Display all events except for "\fBsystem_call_entry\fR"
and "\fBsystem_call_exit\fR".

.B \-e all,!system_call_entry,!system_call_exit


.B NOTE:
Enumerated event name is evaluated from the left to the right.
If both display and non\-display are specified for the same
event, the specification of the right side is given to priority.

.B \-e all,!spin_lock
=> display all events except spin_lock
.br
.B \-e !spin_lock,all
=> display all events
.br
.B \-e !spin_lock,spin_lock
=> the same as "\fB-e spin_lock\fR"
.br
.B \-e spin_lock,!spin_lock
=> the same as "\fB-e !spin_lock\fR"

.TP
.B \-h
Display command help.
( Also event name list is displayed. )

.TP
\fB\-n \fIentry_num
Specify the number of output entry.

.TP
.B \-r
Reverse the order of output record.
.br
(default : time descending sort)