/*-*-c++-*-
 * $Id: structviewitem.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef STRUCTVIEWITEM_H
#define STRUCTVIEWITEM_H

#include <qstring.h>
#include <qwidget.h>
#include <qlistview.h>

#include "crashtypes.h"

/**A QListViewItem with type information
  *@author Michael Geselbracht
  */

class StructViewItem : public QListViewItem {
public:
	StructViewItem(QListView* parent);
	StructViewItem(QListViewItem* parent);
	StructViewItem(QListViewItem* parent, QListViewItem* after);
	~StructViewItem();
	
	void setPixmapType(const NodeType type);
	void setType(const QString& type) {
		oType = type;
	}
	inline const QString& type() const {
		return oType;
	}
	inline void setMarkedColumn(int c) {
		oMarkedColumn = c;
	}
	
	virtual void paintFocus(QPainter* p, const QColorGroup& cg, const QRect&);
	
private:
	void init();
	QString oType;
	int oMarkedColumn;
};

#endif
