/*-*-c++-*-
 * $Id: cs390dbf.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <qsplitter.h>
#include <qlistview.h>
#include <qtextview.h>
#include <qtimer.h>
#include <qvaluelist.h>
#include <qheader.h>
#include <qstringlist.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qpopupmenu.h>

#include "osdep.h"
#include "qlcrashdoc.h"
#include "cs390dbf.h"

CS390dbf::CS390dbf(QLcrashDoc* doc, QWidget* parent, const char* name, WFlags f)
	: QWidget(parent, name, f)
	, oDoc(doc)
	, oEmpty(false)
	, oSelectedItem(0)
{
	oSplitter = new QSplitter(Horizontal, this);
	
	oList = new QListView(oSplitter);
	oList->setRootIsDecorated(true);
	oList->setSorting(-1);
	oList->addColumn("");
	oList->header()->hide();
	connect(oList, SIGNAL(clicked(QListViewItem*)), SLOT(slotVLClicked(QListViewItem*)));
	connect(oList, SIGNAL(doubleClicked(QListViewItem*)), SLOT(slotVLDoubleClicked(QListViewItem*)));
	connect(oList, SIGNAL(rightButtonClicked(QListViewItem*, const QPoint&, int)), SLOT(slotRightButtonClicked(QListViewItem*, const QPoint&, int)));
	
	oText = new QTextView(oSplitter);
	oText->setFont(QFont("Courier", 12, QFont::Normal));
	
	 oEmpty = !initLogList();
	// the initial size problem...
	QTimer::singleShot(100, this, SLOT(slotInitialTimeout()));
}

CS390dbf::~CS390dbf()
{
}

void
CS390dbf::resizeEvent(QResizeEvent*)
{
	oSplitter->setGeometry(0, 0, width(), height());
}

void
CS390dbf::slotInitialTimeout()
{
	QValueList<int> vl;
	vl.append(width() / 4);
	vl.append(width() / 4 * 3);
	oSplitter->setSizes(vl);
}

bool
CS390dbf::initLogList()
{
	QStringList* logs = oDoc->s390AvailableLogs();
	QListViewItem* lvi = 0;
	
	if (logs->count() <= 0 || (logs->first()).isEmpty()) {
		QMessageBox::warning(this, stdCaption(tr("Warning")), tr("There are no logs!"), tr("Ok"));
		return false;
	}
	
	for (QStringList::Iterator it = logs->begin(); it != logs->end(); ++it) {
		lvi = ((lvi == 0) ? new QListViewItem(oList) : new QListViewItem(oList, lvi));
		lvi->setText(0, *it);
		
		QStringList* views = oDoc->s390AvailableViews(*it);
		QListViewItem* lli = 0;;
		for (QStringList::Iterator it2 = views->begin(); it2 != views->end(); ++it2) {
			lli = ((lli == 0) ? new QListViewItem(lvi) : new QListViewItem(lvi, lli));
			
			QString level = "";
			if (*it2 == "level") { // retrieve level info
				level = QString(" ") + "(" + oDoc->s390dbfText(lvi->text(0), "level") + ")";
			}
			
			lli->setText(0, (*it2) + level);
		}
		
		delete views;
	}
	
	delete logs;
	
	return true;
}

void
CS390dbf::slotVLClicked(QListViewItem* lvi)
{
	if (lvi != 0 && oSelectedItem != 0 && lvi != oSelectedItem && lvi->parent() != 0) {
		oText->setText("");
		oSelectedItem = 0;
	}
}

void
CS390dbf::slotVLDoubleClicked(QListViewItem* lvi)
{
	if (lvi != 0 && lvi->childCount() == 0) { // lvi has to be a child
		QString view = QStringList::split(' ', lvi->text(0)).first();
		
		if (view != "raw") { // don't display raw view
			QString text = oDoc->s390dbfText(lvi->parent()->text(0), view);	
			oText->setText(text);
			oSelectedItem = lvi;
		}
		else {
			int button = QMessageBox::information(
				0,
				stdCaption(tr("Raw view")),
				tr("I cannot display a raw view\nShall I write the data into a file ?"),
				tr("No"),
				tr("Yes")
			);
			if (button == 1) {
				saveToFile(lvi->parent()->text(0), view);
			}
		}
	}
}

void
CS390dbf::saveToFile(const QString& log, const QString& view)
{
	QString file = QFileDialog::getSaveFileName(oDoc->lastSaveDir());
	if (!file.isEmpty()) {
		oDoc->s390dbfSaveToFile(log, view, file);
	}
}

void
CS390dbf::slotRightButtonClicked(QListViewItem* lvi, const QPoint& p, int)
{
	if (lvi != 0 && lvi->parent() != 0) {
		QPopupMenu* menu = new QPopupMenu(0);
		menu->insertItem(tr("Save to file") + "...", 1);
		int opt = menu->exec(p);
		delete menu;
		
		switch (opt) {
			case 1:
				saveToFile(lvi->parent()->text(0), QStringList::split(' ', lvi->text(0)).first());
				break;
		}
	}
}
