/*-*-c++-*-
 * $Id: clistviewitem.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CLISTVIEWITEM_H
#define CLISTVIEWITEM_H

#include <qlistview.h>
#include <qcolor.h>

/** Supports columns with numbers. For these columns an
	appropriate key for sorting purposes will be created.
	Besides, it offers a color setting for the text.
	@author Michael Geselbracht
*/

class CListViewItem : public QListViewItem {
public: 
	CListViewItem(QListView*);
	CListViewItem(QListViewItem*);
	CListViewItem(QListView*, QListViewItem*);
	CListViewItem(QListViewItem*, QListViewItem*);
	~CListViewItem();
	
	void setColor(const QColor& c);
	
	virtual QString key(int col, bool asc) const;
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int col, int width, int align);

private:
	QColor oColor;
};

#endif
